/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.drill.common.expression.CastExpression;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.planner.index.CollationContext;
import org.apache.drill.exec.planner.index.IndexDefinition;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;

public class DrillIndexDefinition
implements IndexDefinition {
    @JsonProperty
    protected final List<LogicalExpression> indexColumns;
    @JsonProperty
    protected final List<LogicalExpression> nonIndexColumns;
    @JsonIgnore
    protected final Set<LogicalExpression> allIndexColumns;
    @JsonProperty
    protected final List<LogicalExpression> rowKeyColumns;
    @JsonProperty
    protected final CollationContext indexCollationContext;
    @JsonProperty
    protected final String indexName;
    protected final String tableName;
    @JsonProperty
    protected final IndexDefinition.IndexType indexType;
    @JsonProperty
    protected final RelFieldCollation.NullDirection nullsDirection;

    public DrillIndexDefinition(List<LogicalExpression> indexCols, CollationContext indexCollationContext, List<LogicalExpression> nonIndexCols, List<LogicalExpression> rowKeyColumns, String indexName, String tableName, IndexDefinition.IndexType type, RelFieldCollation.NullDirection nullsDirection) {
        this.indexColumns = indexCols;
        this.nonIndexColumns = nonIndexCols;
        this.rowKeyColumns = rowKeyColumns;
        this.indexName = indexName;
        this.tableName = tableName;
        this.indexType = type;
        this.allIndexColumns = Sets.newHashSet(this.indexColumns);
        this.allIndexColumns.addAll(this.nonIndexColumns);
        this.indexCollationContext = indexCollationContext;
        this.nullsDirection = nullsDirection;
    }

    @Override
    public int getIndexColumnOrdinal(LogicalExpression path) {
        int id = this.indexColumns.indexOf(path);
        return id;
    }

    @Override
    public boolean isCoveringIndex(List<LogicalExpression> columns) {
        return this.allIndexColumns.containsAll(columns);
    }

    @Override
    public boolean allColumnsIndexed(Collection<LogicalExpression> columns) {
        return this.columnsInIndexFields(columns, this.indexColumns);
    }

    @Override
    public boolean someColumnsIndexed(Collection<LogicalExpression> columns) {
        return this.someColumnsInIndexFields(columns, this.indexColumns);
    }

    public boolean pathExactIn(SchemaPath path, Collection<LogicalExpression> exprs) {
        for (LogicalExpression expr : exprs) {
            if (!(expr instanceof SchemaPath) || !((SchemaPath)expr).toExpr().equals(path.toExpr())) continue;
            return true;
        }
        return false;
    }

    boolean castIsCompatible(CastExpression castExpr, Collection<LogicalExpression> indexFields) {
        for (LogicalExpression indexExpr : indexFields) {
            if (indexExpr.getClass() != castExpr.getClass()) continue;
            CastExpression indexCastExpr = (CastExpression)indexExpr;
            if (!castExpr.getInput().equals(indexCastExpr.getInput()) || castExpr.getMajorType().getMinorType() != indexCastExpr.getMajorType().getMinorType()) continue;
            return true;
        }
        return false;
    }

    protected boolean columnsInIndexFields(Collection<LogicalExpression> columns, Collection<LogicalExpression> indexFields) {
        for (LogicalExpression col : columns) {
            if (!(col instanceof CastExpression ? !this.castIsCompatible((CastExpression)col, indexFields) : !this.pathExactIn((SchemaPath)col, indexFields))) continue;
            return false;
        }
        return true;
    }

    protected boolean someColumnsInIndexFields(Collection<LogicalExpression> columns, Collection<LogicalExpression> indexFields) {
        for (LogicalExpression col : columns) {
            if (!(col instanceof CastExpression ? this.castIsCompatible((CastExpression)col, indexFields) : this.pathExactIn((SchemaPath)col, indexFields))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String columnsDesc = " Index columns: " + this.indexColumns.toString() + " Non-Index columns: " + this.nonIndexColumns.toString();
        String desc = "Table: " + this.tableName + " Index: " + this.indexName + columnsDesc;
        return desc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DrillIndexDefinition index1 = (DrillIndexDefinition)o;
        return this.tableName.equals(index1.tableName) && this.indexName.equals(index1.indexName) && this.indexType.equals((Object)index1.indexType) && this.indexColumns.equals(index1.indexColumns);
    }

    public int hashCode() {
        int prime = 31;
        String fullName = this.tableName + this.indexName;
        int result = 1;
        result = 31 * result + fullName.hashCode();
        result = 31 * result + this.indexType.hashCode();
        return result;
    }

    @Override
    @JsonProperty
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    @JsonProperty
    public IndexDefinition.IndexType getIndexType() {
        return this.indexType;
    }

    @Override
    @JsonProperty
    public List<LogicalExpression> getRowKeyColumns() {
        return this.rowKeyColumns;
    }

    @Override
    @JsonProperty
    public List<LogicalExpression> getIndexColumns() {
        return this.indexColumns;
    }

    @Override
    @JsonProperty
    public List<LogicalExpression> getNonIndexColumns() {
        return this.nonIndexColumns;
    }

    @Override
    @JsonIgnore
    public RelCollation getCollation() {
        if (this.indexCollationContext != null) {
            return RelCollations.of(this.indexCollationContext.relFieldCollations);
        }
        return null;
    }

    @Override
    @JsonIgnore
    public Map<LogicalExpression, RelFieldCollation> getCollationMap() {
        return this.indexCollationContext.collationMap;
    }

    @Override
    @JsonIgnore
    public RelFieldCollation.NullDirection getNullsOrderingDirection() {
        return this.nullsDirection;
    }
}

