/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index;

import java.math.BigDecimal;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.common.expression.CastExpression;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import org.apache.drill.exec.planner.sql.TypeInferenceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprToRex
extends AbstractExprVisitor<RexNode, Void, RuntimeException> {
    static final Logger logger = LoggerFactory.getLogger(ExprToRex.class);
    private final RexBuilder builder;
    private final RelDataType newRowType;
    private final RelNode inputRel;

    public ExprToRex(RelNode inputRel, RelDataType newRowType, RexBuilder builder) {
        this.inputRel = inputRel;
        this.newRowType = newRowType;
        this.builder = builder;
    }

    public static RelDataTypeField findField(String fieldName, RelDataType rowType) {
        String rootPart = SchemaPath.parseFromString(fieldName).getRootSegmentPath();
        for (RelDataTypeField f : rowType.getFieldList()) {
            if (!rootPart.equalsIgnoreCase(f.getName())) continue;
            return f;
        }
        return null;
    }

    @Override
    public RexNode visitSchemaPath(SchemaPath path, Void value) throws RuntimeException {
        RexInputRef rexNode;
        PathSegment pathSegment = path.getRootSegment();
        RelDataTypeField field = ExprToRex.findField(pathSegment.getNameSegment().getPath(), this.newRowType);
        RexInputRef rexInputRef = rexNode = field == null ? null : this.builder.makeInputRef(field.getType(), field.getIndex());
        while (!pathSegment.isLastPath()) {
            RexLiteral ref = (pathSegment = pathSegment.getChild()).isNamed() ? this.builder.makeLiteral(pathSegment.getNameSegment().getPath()) : this.builder.makeBigintLiteral(BigDecimal.valueOf(pathSegment.getArraySegment().getIndex()));
            rexNode = this.builder.makeCall(SqlStdOperatorTable.ITEM, new RexNode[]{rexNode, ref});
        }
        return rexNode;
    }

    @Override
    public RexNode visitCastExpression(CastExpression e, Void value) throws RuntimeException {
        RexNode convertedInput = e.getInput().accept(this, null);
        String typeStr = e.getMajorType().getMinorType().toString();
        if (SqlTypeName.get((String)typeStr) == null) {
            logger.debug("SqlTypeName could not find {}", (Object)typeStr);
        }
        SqlTypeName typeName = TypeInferenceUtils.getCalciteTypeFromDrillType(e.getMajorType().getMinorType());
        RelDataType targetType = TypeInferenceUtils.createCalciteTypeWithNullability(this.inputRel.getCluster().getTypeFactory(), typeName, true);
        return this.builder.makeCast(targetType, convertedInput);
    }
}

