/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.common.expression.CastExpression;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.DbGroupScan;
import org.apache.drill.exec.physical.base.IndexGroupScan;
import org.apache.drill.exec.planner.common.DrillScanRelBase;
import org.apache.drill.exec.planner.index.FunctionalIndexInfo;
import org.apache.drill.exec.planner.index.IndexCallContext;
import org.apache.drill.exec.planner.index.IndexPlanUtils;
import org.apache.drill.exec.planner.index.IndexableExprMarker;
import org.apache.drill.exec.planner.index.SimpleRexRemap;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;

public class FunctionalIndexHelper {
    public static RelDataType rewriteFunctionalRowType(RelNode origScan, IndexCallContext indexContext, FunctionalIndexInfo functionInfo) {
        return FunctionalIndexHelper.rewriteFunctionalRowType(origScan, indexContext, functionInfo, null);
    }

    public static RelDataType rewriteFunctionalRowType(RelNode origScan, IndexCallContext indexContext, FunctionalIndexInfo functionInfo, Collection<SchemaPath> addedPaths) {
        RelDataType origRowType = origScan.getRowType();
        if (!functionInfo.hasFunctional()) {
            return origRowType;
        }
        ArrayList<RelDataTypeFieldImpl> fields = Lists.newArrayList();
        HashSet<String> leftOutFieldNames = Sets.newHashSet();
        if (indexContext.getLeftOutPathsInFunctions() != null) {
            for (LogicalExpression logicalExpression : indexContext.getLeftOutPathsInFunctions()) {
                leftOutFieldNames.add(((SchemaPath)logicalExpression).getRootSegmentPath());
            }
        }
        HashSet<String> fieldInFunctions = Sets.newHashSet();
        for (SchemaPath schemaPath : functionInfo.allPathsInFunction()) {
            fieldInFunctions.add(schemaPath.getRootSegmentPath());
        }
        RelDataTypeFactory relDataTypeFactory = origScan.getCluster().getTypeFactory();
        for (RelDataTypeField field : origRowType.getFieldList()) {
            String fieldName = field.getName();
            if (fieldInFunctions.contains(fieldName) && !leftOutFieldNames.contains(fieldName)) continue;
            fields.add(new RelDataTypeFieldImpl(SchemaPath.parseFromString(fieldName).getRootSegmentPath(), fields.size(), relDataTypeFactory.createSqlType(SqlTypeName.ANY)));
        }
        Collection<SchemaPath> collection = addedPaths == null ? functionInfo.allNewSchemaPaths() : addedPaths;
        for (SchemaPath dollarPath : collection) {
            fields.add(new RelDataTypeFieldImpl(dollarPath.getRootSegmentPath(), fields.size(), origScan.getCluster().getTypeFactory().createSqlType(SqlTypeName.ANY)));
        }
        return new RelRecordType(fields);
    }

    public static RelDataType convertRowTypeForIndexScan(DrillScanRelBase origScan, IndexableExprMarker idxMarker, IndexGroupScan idxScan, FunctionalIndexInfo functionInfo) {
        RelDataTypeFactory typeFactory = origScan.getCluster().getTypeFactory();
        ArrayList<RelDataTypeFieldImpl> fields = new ArrayList<RelDataTypeFieldImpl>();
        LinkedHashSet<SchemaPath> rowPaths = new LinkedHashSet<SchemaPath>();
        RelRecordType newRowType = null;
        DbGroupScan scan = (DbGroupScan)IndexPlanUtils.getGroupScan(origScan);
        RelDataTypeFieldImpl rowkey_primary = new RelDataTypeFieldImpl(scan.getRowKeyName(), fields.size(), typeFactory.createSqlType(SqlTypeName.ANY));
        fields.add(rowkey_primary);
        Map<RexNode, LogicalExpression> idxExprMap = idxMarker.getIndexableExpression();
        for (LogicalExpression indexedExpr : idxExprMap.values()) {
            SchemaPath newPath;
            if (indexedExpr instanceof SchemaPath) {
                rowPaths.add((SchemaPath)indexedExpr);
                continue;
            }
            if (!(indexedExpr instanceof CastExpression) || (newPath = functionInfo.getNewPathFromExpr(indexedExpr)) == null) continue;
            rowPaths.add(newPath);
        }
        for (SchemaPath newPath : rowPaths) {
            fields.add(new RelDataTypeFieldImpl(newPath.getRootSegmentPath(), fields.size(), typeFactory.createSqlType(SqlTypeName.ANY)));
        }
        LinkedHashSet<RelDataTypeFieldImpl> rowfields = Sets.newLinkedHashSet();
        ArrayList<SchemaPath> columns = Lists.newArrayList();
        for (RelDataTypeField relDataTypeField : fields) {
            SchemaPath path = SchemaPath.parseFromString(relDataTypeField.getName());
            rowfields.add(new RelDataTypeFieldImpl(path.getRootSegmentPath(), rowfields.size(), typeFactory.createSqlType(SqlTypeName.ANY)));
            columns.add(path);
        }
        idxScan.setColumns(columns);
        newRowType = new RelRecordType(Lists.newArrayList(rowfields));
        return newRowType;
    }

    public static RexNode convertConditionForIndexScan(RexNode idxCondition, RelNode origScan, RelDataType idxRowType, RexBuilder builder, FunctionalIndexInfo functionInfo) {
        IndexableExprMarker marker = new IndexableExprMarker(origScan);
        idxCondition.accept((RexVisitor)marker);
        SimpleRexRemap remap = new SimpleRexRemap(origScan, idxRowType, builder);
        remap.setExpressionMap(functionInfo.getExprMap());
        if (functionInfo.supportEqualCharConvertToLike()) {
            Map<LogicalExpression, LogicalExpression> indexedExprs = functionInfo.getExprMap();
            Map<RexNode, LogicalExpression> equalCastMap = marker.getEqualOnCastChar();
            HashMap<RexNode, LogicalExpression> toRewriteEqualCastMap = Maps.newHashMap();
            for (Map.Entry<RexNode, LogicalExpression> entry : equalCastMap.entrySet()) {
                CastExpression expr = (CastExpression)entry.getValue();
                for (LogicalExpression indexed : indexedExprs.keySet()) {
                    if (!(indexed instanceof CastExpression)) continue;
                    CastExpression indexedCast = (CastExpression)indexed;
                    if (!expr.getInput().equals(indexedCast.getInput()) || !expr.getMajorType().getMinorType().equals(indexedCast.getMajorType().getMinorType()) || expr.getMajorType().getPrecision() >= indexedCast.getMajorType().getPrecision()) continue;
                    toRewriteEqualCastMap.put(entry.getKey(), entry.getValue());
                }
            }
            if (toRewriteEqualCastMap.size() > 0) {
                idxCondition = remap.rewriteEqualOnCharToLike(idxCondition, toRewriteEqualCastMap);
            }
        }
        return remap.rewriteWithMap(idxCondition, marker.getIndexableExpression());
    }
}

