/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.DbGroupScan;
import org.apache.drill.exec.planner.common.DrillProjectRelBase;
import org.apache.drill.exec.planner.common.DrillScanRelBase;
import org.apache.drill.exec.planner.common.OrderedRel;
import org.apache.drill.exec.planner.index.IndexCallContext;
import org.apache.drill.exec.planner.index.IndexableExprMarker;
import org.apache.drill.exec.planner.logical.DrillFilterRel;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.logical.DrillSortRel;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class IndexLogicalPlanCallContext
implements IndexCallContext {
    public final RelOptRuleCall call;
    public final DrillSortRel sort;
    public final DrillProjectRel upperProject;
    public final DrillFilterRel filter;
    public final DrillProjectRel lowerProject;
    public final DrillScanRel scan;
    public final String indexHint;
    public Set<LogicalExpression> leftOutPathsInFunctions;
    public IndexableExprMarker origMarker;
    public List<LogicalExpression> sortExprs;
    public RexNode origPushedCondition;

    public IndexLogicalPlanCallContext(RelOptRuleCall call, DrillProjectRel capProject, DrillFilterRel filter, DrillProjectRel project, DrillScanRel scan) {
        this(call, null, capProject, filter, project, scan);
    }

    public IndexLogicalPlanCallContext(RelOptRuleCall call, DrillSortRel sort, DrillProjectRel capProject, DrillFilterRel filter, DrillProjectRel project, DrillScanRel scan) {
        this.call = call;
        this.sort = sort;
        this.upperProject = capProject;
        this.filter = filter;
        this.lowerProject = project;
        this.scan = scan;
        this.indexHint = ((DbGroupScan)this.scan.getGroupScan()).getIndexHint();
    }

    public IndexLogicalPlanCallContext(RelOptRuleCall call, DrillSortRel sort, DrillProjectRel project, DrillScanRel scan) {
        this.call = call;
        this.sort = sort;
        this.upperProject = null;
        this.filter = null;
        this.lowerProject = project;
        this.scan = scan;
        this.indexHint = ((DbGroupScan)this.scan.getGroupScan()).getIndexHint();
    }

    @Override
    public DbGroupScan getGroupScan() {
        return (DbGroupScan)this.scan.getGroupScan();
    }

    @Override
    public DrillScanRelBase getScan() {
        return this.scan;
    }

    @Override
    public RelCollation getCollation() {
        if (this.sort != null) {
            return this.sort.getCollation();
        }
        return null;
    }

    @Override
    public boolean hasLowerProject() {
        return this.lowerProject != null;
    }

    @Override
    public boolean hasUpperProject() {
        return this.upperProject != null;
    }

    @Override
    public RelOptRuleCall getCall() {
        return this.call;
    }

    @Override
    public Set<LogicalExpression> getLeftOutPathsInFunctions() {
        return this.leftOutPathsInFunctions;
    }

    @Override
    public RelNode getFilter() {
        return this.filter;
    }

    @Override
    public IndexableExprMarker getOrigMarker() {
        return this.origMarker;
    }

    @Override
    public List<LogicalExpression> getSortExprs() {
        return this.sortExprs;
    }

    @Override
    public DrillProjectRelBase getLowerProject() {
        return this.lowerProject;
    }

    @Override
    public DrillProjectRelBase getUpperProject() {
        return this.upperProject;
    }

    @Override
    public void setLeftOutPathsInFunctions(Set<LogicalExpression> exprs) {
        this.leftOutPathsInFunctions = exprs;
    }

    @Override
    public List<SchemaPath> getScanColumns() {
        return this.scan.getColumns();
    }

    @Override
    public RexNode getFilterCondition() {
        return this.filter.getCondition();
    }

    @Override
    public RexNode getOrigCondition() {
        return this.origPushedCondition;
    }

    @Override
    public OrderedRel getSort() {
        return this.sort;
    }

    @Override
    public void createSortExprs() {
        this.sortExprs = Lists.newArrayList();
    }

    @Override
    public RelNode getExchange() {
        return null;
    }

    @Override
    public List<DrillDistributionTrait.DistributionField> getDistributionFields() {
        return Collections.emptyList();
    }
}

