/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.DbGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.IndexGroupScan;
import org.apache.drill.exec.planner.common.DrillProjectRelBase;
import org.apache.drill.exec.planner.common.DrillScanRelBase;
import org.apache.drill.exec.planner.common.OrderedRel;
import org.apache.drill.exec.planner.fragment.DistributionAffinity;
import org.apache.drill.exec.planner.index.FunctionalIndexHelper;
import org.apache.drill.exec.planner.index.FunctionalIndexInfo;
import org.apache.drill.exec.planner.index.IndexCallContext;
import org.apache.drill.exec.planner.index.IndexConditionInfo;
import org.apache.drill.exec.planner.index.IndexDescriptor;
import org.apache.drill.exec.planner.index.IndexPhysicalPlanCallContext;
import org.apache.drill.exec.planner.index.IndexableExprMarker;
import org.apache.drill.exec.planner.index.PathInExpr;
import org.apache.drill.exec.planner.index.RexToExpression;
import org.apache.drill.exec.planner.index.SimpleRexRemap;
import org.apache.drill.exec.planner.logical.DrillOptiq;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;

public class IndexPlanUtils {
    public static ConditionIndexed conditionIndexed(IndexableExprMarker exprMarker, IndexDescriptor indexDesc) {
        Map<RexNode, LogicalExpression> mapRexExpr = exprMarker.getIndexableExpression();
        ArrayList<LogicalExpression> infoCols = Lists.newArrayList();
        infoCols.addAll(mapRexExpr.values());
        if (indexDesc.allColumnsIndexed(infoCols)) {
            return ConditionIndexed.FULL;
        }
        if (indexDesc.someColumnsIndexed(infoCols)) {
            return ConditionIndexed.PARTIAL;
        }
        return ConditionIndexed.NONE;
    }

    public static boolean checkScan(DrillScanRel scanRel) {
        GroupScan groupScan = scanRel.getGroupScan();
        if (groupScan instanceof DbGroupScan) {
            DbGroupScan dbscan = (DbGroupScan)groupScan;
            return dbscan.supportsSecondaryIndex() && !dbscan.isIndexScan() && !dbscan.isRestrictedScan();
        }
        return false;
    }

    public static boolean isCoveringIndex(IndexCallContext indexContext, FunctionalIndexInfo functionInfo) {
        if (functionInfo.hasFunctional()) {
            return IndexPlanUtils.queryCoveredByIndex(indexContext, functionInfo);
        }
        DbGroupScan groupScan = (DbGroupScan)IndexPlanUtils.getGroupScan(indexContext.getScan());
        ArrayList<LogicalExpression> tableCols = Lists.newArrayList();
        tableCols.addAll(groupScan.getColumns());
        return functionInfo.getIndexDesc().isCoveringIndex(tableCols);
    }

    private static boolean queryCoveredByIndex(IndexCallContext indexContext, FunctionalIndexInfo functionInfo) {
        Object expr;
        if (indexContext.getFilter() != null && indexContext.getUpperProject() == null && !IndexPlanUtils.isFullQuery(indexContext)) {
            return false;
        }
        DrillParseContext parserContext = new DrillParseContext(PrelUtil.getPlannerSettings(indexContext.getCall().rel(0).getCluster()));
        HashSet<Object> exprs = Sets.newHashSet();
        if (indexContext.getUpperProject() != null) {
            Object filterMarker;
            if (indexContext.getLowerProject() == null) {
                for (Object rex : indexContext.getUpperProject().getProjects()) {
                    expr = RexToExpression.toDrill(parserContext, null, indexContext.getScan(), (RexNode)rex);
                    exprs.add(expr);
                }
                filterMarker = new IndexableExprMarker(indexContext.getScan());
                indexContext.getFilterCondition().accept(filterMarker);
                for (RexNode rex : ((IndexableExprMarker)((Object)filterMarker)).getIndexableExpression().keySet()) {
                    LogicalExpression logicalExpression = RexToExpression.toDrill(parserContext, null, indexContext.getScan(), rex);
                    exprs.add(logicalExpression);
                }
            } else {
                for (Object rex : indexContext.getUpperProject().getProjects()) {
                    expr = RexToExpression.toDrill(parserContext, indexContext.getLowerProject(), indexContext.getScan(), (RexNode)rex);
                    exprs.add(expr);
                }
                filterMarker = new IndexableExprMarker(indexContext.getScan());
                indexContext.getOrigCondition().accept(filterMarker);
                for (RexNode rex : ((IndexableExprMarker)((Object)filterMarker)).getIndexableExpression().keySet()) {
                    LogicalExpression logicalExpression = RexToExpression.toDrill(parserContext, null, indexContext.getScan(), rex);
                    exprs.add(logicalExpression);
                }
            }
        } else if (indexContext.getLowerProject() != null) {
            for (Object rex : indexContext.getLowerProject().getProjects()) {
                expr = DrillOptiq.toDrill(parserContext, indexContext.getScan(), (RexNode)rex);
                exprs.add(expr);
            }
        } else {
            exprs.addAll(indexContext.getScanColumns());
        }
        Map<LogicalExpression, Set<SchemaPath>> exprPathMap = functionInfo.getPathsInFunctionExpr();
        PathInExpr exprSearch = new PathInExpr(exprPathMap);
        for (LogicalExpression logicalExpression : exprs) {
            if (logicalExpression.accept(exprSearch, null).booleanValue()) continue;
            return false;
        }
        ArrayList<LogicalExpression> leftPaths = Lists.newArrayList(exprSearch.getRemainderPaths());
        indexContext.setLeftOutPathsInFunctions(exprSearch.getRemainderPathsInFunctions());
        return functionInfo.getIndexDesc().isCoveringIndex(leftPaths);
    }

    private static boolean isFullQuery(IndexCallContext indexContext) {
        RelSubset rootSet;
        RelNode rootInCall = indexContext.getCall().rel(0);
        return indexContext.getCall().getPlanner().getRoot() instanceof RelSubset ? (rootSet = (RelSubset)indexContext.getCall().getPlanner().getRoot()).getRelList().contains(rootInCall) : indexContext.getCall().getPlanner().getRoot().equals(rootInCall);
    }

    public static RelCollation buildCollationLowerProject(List<RexNode> projectRexs, RelNode input, FunctionalIndexInfo indexInfo) {
        ArrayList<RelFieldCollation> newFields = Lists.newArrayList();
        if (!indexInfo.hasFunctional()) {
            LinkedHashMap<LogicalExpression, Integer> projectExprs = Maps.newLinkedHashMap();
            DrillParseContext parserContext = new DrillParseContext(PrelUtil.getPlannerSettings(input.getCluster()));
            int idx = 0;
            for (RexNode rex : projectRexs) {
                projectExprs.put(DrillOptiq.toDrill(parserContext, input, rex), idx);
                ++idx;
            }
            int idxFieldCount = 0;
            for (LogicalExpression expr : indexInfo.getIndexDesc().getIndexColumns()) {
                RelFieldCollation.Direction dir;
                if (!projectExprs.containsKey(expr) || (dir = ((RelFieldCollation)indexInfo.getIndexDesc().getCollation().getFieldCollations().get((int)idxFieldCount)).direction) == null) break;
                newFields.add(new RelFieldCollation(((Integer)projectExprs.get(expr)).intValue(), dir, RelFieldCollation.NullDirection.UNSPECIFIED));
            }
            ++idxFieldCount;
        }
        return RelCollations.of(newFields);
    }

    public static RelCollation buildCollationUpperProject(List<RexNode> projectRexs, RelCollation inputCollation, FunctionalIndexInfo indexInfo, Map<Integer, List<RexNode>> collationFilterMap) {
        ArrayList<RelFieldCollation> outputFieldCollations = Lists.newArrayList();
        if (inputCollation != null) {
            List inputFieldCollations = inputCollation.getFieldCollations();
            if (!indexInfo.hasFunctional()) {
                for (int projectExprIdx = 0; projectExprIdx < projectRexs.size(); ++projectExprIdx) {
                    RexNode n = projectRexs.get(projectExprIdx);
                    if (!(n instanceof RexInputRef)) continue;
                    RexInputRef ref = (RexInputRef)n;
                    boolean eligibleForCollation = true;
                    int maxIndex = IndexPlanUtils.getIndexFromCollation(ref.getIndex(), inputFieldCollations);
                    if (maxIndex < 0) {
                        eligibleForCollation = false;
                        continue;
                    }
                    block1: for (int i = 0; i < maxIndex; ++i) {
                        List<RexNode> conditions;
                        int fieldIdx = ((RelFieldCollation)inputFieldCollations.get(i)).getFieldIndex();
                        List<RexNode> list = conditions = collationFilterMap != null ? collationFilterMap.get(fieldIdx) : null;
                        if ((conditions == null || conditions.size() == 0) && i < maxIndex - 1) {
                            eligibleForCollation = false;
                            break;
                        }
                        for (RexNode r : conditions) {
                            if (r.getKind() == SqlKind.EQUALS) continue;
                            eligibleForCollation = false;
                            continue block1;
                        }
                    }
                    if (!eligibleForCollation) continue;
                    for (RelFieldCollation c : inputFieldCollations) {
                        if (ref.getIndex() != c.getFieldIndex()) continue;
                        RelFieldCollation outFieldCollation = new RelFieldCollation(projectExprIdx, c.getDirection(), c.nullDirection);
                        outputFieldCollations.add(outFieldCollation);
                    }
                }
            }
        }
        return RelCollations.of(outputFieldCollations);
    }

    public static int getIndexFromCollation(int refIndex, List<RelFieldCollation> inputFieldCollations) {
        for (int i = 0; i < inputFieldCollations.size(); ++i) {
            if (refIndex != inputFieldCollations.get(i).getFieldIndex()) continue;
            return i;
        }
        return -1;
    }

    public static List<RexNode> getProjects(DrillProjectRelBase proj) {
        return proj.getProjects();
    }

    public static boolean generateLimit(OrderedRel sort) {
        RexNode fetchNode = sort.getFetch();
        int fetchValue = fetchNode == null ? -1 : RexLiteral.intValue((RexNode)fetchNode);
        return fetchValue >= 0;
    }

    public static RexNode getOffset(OrderedRel sort) {
        return sort.getOffset();
    }

    public static RexNode getFetch(OrderedRel sort) {
        return sort.getFetch();
    }

    public static void updateSortExpression(IndexCallContext indexContext, List<RelFieldCollation> coll) {
        if (coll == null) {
            return;
        }
        DrillParseContext parserContext = new DrillParseContext(PrelUtil.getPlannerSettings(indexContext.getCall().rel(0).getCluster()));
        indexContext.createSortExprs();
        for (RelFieldCollation collation : coll) {
            DrillProjectRelBase oneProject;
            LogicalExpression expr;
            int idx = collation.getFieldIndex();
            if (indexContext.getUpperProject() != null && indexContext.getLowerProject() != null) {
                expr = RexToExpression.toDrill(parserContext, indexContext.getLowerProject(), indexContext.getScan(), (RexNode)indexContext.getUpperProject().getProjects().get(idx));
                indexContext.getSortExprs().add(expr);
                continue;
            }
            DrillProjectRelBase drillProjectRelBase = oneProject = indexContext.getUpperProject() != null ? indexContext.getUpperProject() : indexContext.getLowerProject();
            if (oneProject != null) {
                expr = RexToExpression.toDrill(parserContext, null, indexContext.getScan(), IndexPlanUtils.getProjects(oneProject).get(idx));
                indexContext.getSortExprs().add(expr);
                continue;
            }
            RelDataTypeField f = (RelDataTypeField)indexContext.getScan().getRowType().getFieldList().get(idx);
            String pathSeg = f.getName().replaceAll("`", "");
            String[] segs = pathSeg.split("\\.");
            SchemaPath path = SchemaPath.getCompoundPath(segs);
            indexContext.getSortExprs().add(path);
        }
    }

    public static void updateSortExpression(IndexPhysicalPlanCallContext indexContext, List<RelFieldCollation> coll) {
        if (coll == null) {
            return;
        }
        DrillParseContext parserContext = new DrillParseContext(PrelUtil.getPlannerSettings(indexContext.call.rel(0).getCluster()));
        indexContext.sortExprs = Lists.newArrayList();
        for (RelFieldCollation collation : coll) {
            ProjectPrel oneProject;
            LogicalExpression expr;
            int idx = collation.getFieldIndex();
            if (indexContext.upperProject != null && indexContext.lowerProject != null) {
                expr = RexToExpression.toDrill(parserContext, indexContext.lowerProject, indexContext.scan, (RexNode)indexContext.upperProject.getProjects().get(idx));
                indexContext.sortExprs.add(expr);
                continue;
            }
            ProjectPrel projectPrel = oneProject = indexContext.upperProject != null ? indexContext.upperProject : indexContext.lowerProject;
            if (oneProject != null) {
                expr = RexToExpression.toDrill(parserContext, null, indexContext.scan, (RexNode)oneProject.getProjects().get(idx));
                indexContext.sortExprs.add(expr);
                continue;
            }
            RelDataTypeField f = (RelDataTypeField)indexContext.scan.getRowType().getFieldList().get(idx);
            String pathSeg = f.getName().replaceAll("`", "");
            String[] segs = pathSeg.split("\\.");
            SchemaPath path = SchemaPath.getCompoundPath(segs);
            indexContext.sortExprs.add(path);
        }
    }

    private static boolean exprOnlyInEquality(LogicalExpression expr, IndexCallContext context) {
        if (context.getFilter() == null) {
            return false;
        }
        Set<LogicalExpression> onlyInEquality = context.getOrigMarker().getExpressionsOnlyInEquality();
        return onlyInEquality.contains(expr);
    }

    public static RelCollation buildCollationProject(List<RexNode> projectRexs, DrillProjectRelBase project, RelNode input, FunctionalIndexInfo indexInfo, IndexCallContext context) {
        Map<LogicalExpression, Integer> projectExprs = IndexPlanUtils.getProjectExprs(projectRexs, project, input);
        return IndexPlanUtils.buildCollationForExpressions(projectExprs, indexInfo.getIndexDesc(), context);
    }

    public static RelCollation buildCollationCoveringIndexScan(IndexDescriptor indexDesc, IndexCallContext context) {
        Map<LogicalExpression, Integer> rowTypeExprs = IndexPlanUtils.getExprsFromRowType(context.getScan().getRowType());
        return IndexPlanUtils.buildCollationForExpressions(rowTypeExprs, indexDesc, context);
    }

    public static Map<LogicalExpression, Integer> getProjectExprs(List<RexNode> projectRexs, DrillProjectRelBase project, RelNode input) {
        LinkedHashMap<LogicalExpression, Integer> projectExprs = Maps.newLinkedHashMap();
        DrillParseContext parserContext = new DrillParseContext(PrelUtil.getPlannerSettings(input.getCluster()));
        int idx = 0;
        for (RexNode rex : projectRexs) {
            LogicalExpression expr = RexToExpression.toDrill(parserContext, project, input, rex);
            projectExprs.put(expr, idx);
            ++idx;
        }
        return projectExprs;
    }

    public static Map<LogicalExpression, Integer> getExprsFromRowType(RelDataType indexScanRowType) {
        LinkedHashMap<LogicalExpression, Integer> rowTypeExprs = Maps.newLinkedHashMap();
        int idx = 0;
        for (RelDataTypeField field : indexScanRowType.getFieldList()) {
            rowTypeExprs.put(FieldReference.getWithQuotedRef(field.getName()), idx++);
        }
        return rowTypeExprs;
    }

    public static RelCollation buildCollationForExpressions(Map<LogicalExpression, Integer> projectExprs, IndexDescriptor indexDesc, IndexCallContext context) {
        assert (projectExprs != null);
        List<LogicalExpression> sortExpressions = context.getSortExprs();
        ArrayList<RelFieldCollation> newFields = Lists.newArrayList();
        if (indexDesc.getCollation() == null) {
            return RelCollations.of(newFields);
        }
        List<LogicalExpression> indexedCols = indexDesc.getIndexColumns();
        for (int idxFieldCount = 0; idxFieldCount < indexedCols.size(); ++idxFieldCount) {
            RelFieldCollation.Direction dir;
            LogicalExpression expr = indexedCols.get(idxFieldCount);
            if (!projectExprs.containsKey(expr)) {
                if (!IndexPlanUtils.exprOnlyInEquality(expr, context)) break;
                continue;
            }
            if (sortExpressions != null && !sortExpressions.contains(expr) && IndexPlanUtils.exprOnlyInEquality(expr, context)) continue;
            RelCollation idxCollation = indexDesc.getCollation();
            RelFieldCollation.NullDirection nullsDir = idxCollation == null ? RelFieldCollation.NullDirection.UNSPECIFIED : ((RelFieldCollation)idxCollation.getFieldCollations().get((int)idxFieldCount)).nullDirection;
            RelFieldCollation.Direction direction = dir = idxCollation == null ? null : ((RelFieldCollation)idxCollation.getFieldCollations().get((int)idxFieldCount)).direction;
            if (dir == null) break;
            newFields.add(new RelFieldCollation(projectExprs.get(expr).intValue(), dir, nullsDir));
        }
        return RelCollations.of(newFields);
    }

    public static boolean pathOnlyInIndexedFunction(SchemaPath path) {
        return true;
    }

    public static RelCollation buildCollationNonCoveringIndexScan(IndexDescriptor indexDesc, RelDataType indexScanRowType, RelDataType restrictedScanRowType, IndexCallContext context) {
        if (context.getSortExprs() == null) {
            return RelCollations.of((List)RelCollations.EMPTY.getFieldCollations());
        }
        List indexFields = indexScanRowType.getFieldList();
        List rsFields = restrictedScanRowType.getFieldList();
        Map<LogicalExpression, RelFieldCollation> collationMap = indexDesc.getCollationMap();
        assert (collationMap != null) : "Invalid collation map for index";
        ArrayList<RelFieldCollation> fieldCollations = Lists.newArrayList();
        TreeMap<Integer, RelFieldCollation> rsScanCollationMap = Maps.newTreeMap();
        for (int i = 0; i < indexScanRowType.getFieldCount(); ++i) {
            RelDataTypeField f1 = (RelDataTypeField)indexFields.get(i);
            for (int j = 0; j < rsFields.size(); ++j) {
                FieldReference ref;
                RelFieldCollation origCollation;
                RelDataTypeField f2 = (RelDataTypeField)rsFields.get(j);
                if (!f1.getName().equals(f2.getName()) || (origCollation = collationMap.get(ref = FieldReference.getWithQuotedRef(f1.getName()))) == null) continue;
                RelFieldCollation fc = new RelFieldCollation(j, origCollation.direction, origCollation.nullDirection);
                rsScanCollationMap.put(origCollation.getFieldIndex(), fc);
            }
        }
        for (Map.Entry entry : rsScanCollationMap.entrySet()) {
            RelFieldCollation fc = (RelFieldCollation)entry.getValue();
            if (fc == null) continue;
            fieldCollations.add(fc);
        }
        RelCollation collation = RelCollations.of(fieldCollations);
        return collation;
    }

    public static boolean scanIsPartition(GroupScan scan) {
        return scan.isDistributed() || scan.getDistributionAffinity() == DistributionAffinity.HARD;
    }

    public static GroupScan getGroupScan(DrillScanRelBase relNode) {
        return relNode.getGroupScan();
    }

    public static RelCollation getCollation(Sort sort) {
        return sort.getCollation();
    }

    public static List<DrillDistributionTrait.DistributionField> getDistributionField(Sort rel) {
        ArrayList<DrillDistributionTrait.DistributionField> distFields = Lists.newArrayList();
        for (RelFieldCollation relField : IndexPlanUtils.getCollation(rel).getFieldCollations()) {
            DrillDistributionTrait.DistributionField field = new DrillDistributionTrait.DistributionField(relField.getFieldIndex());
            distFields.add(field);
        }
        return distFields;
    }

    public static ScanPrel buildCoveringIndexScan(DrillScanRelBase origScan, IndexGroupScan indexGroupScan, IndexCallContext indexContext, IndexDescriptor indexDesc) {
        FunctionalIndexInfo functionInfo = indexDesc.getFunctionalInfo();
        ArrayList<SchemaPath> rewrittenPaths = Lists.newArrayList();
        DbGroupScan dbGroupScan = (DbGroupScan)IndexPlanUtils.getGroupScan(origScan);
        indexGroupScan.setColumns(IndexPlanUtils.rewriteFunctionColumn(dbGroupScan.getColumns(), functionInfo, rewrittenPaths));
        DrillDistributionTrait partition = IndexPlanUtils.scanIsPartition(IndexPlanUtils.getGroupScan(origScan)) ? DrillDistributionTrait.RANDOM_DISTRIBUTED : DrillDistributionTrait.SINGLETON;
        RelDataType newRowType = FunctionalIndexHelper.rewriteFunctionalRowType(origScan, indexContext, functionInfo, rewrittenPaths);
        RelTraitSet indexScanTraitSet = origScan.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)RelCollationTraitDef.INSTANCE.getDefault()).plus((RelTrait)partition);
        if (indexDesc.getCollation() != null) {
            RelCollation collationTrait = IndexPlanUtils.buildCollationCoveringIndexScan(indexDesc, indexContext);
            indexScanTraitSet = indexScanTraitSet.plus((RelTrait)collationTrait);
        }
        ScanPrel indexScanPrel = new ScanPrel(origScan.getCluster(), indexScanTraitSet, indexGroupScan, newRowType, origScan.getTable());
        return indexScanPrel;
    }

    public static List<SchemaPath> rewriteFunctionColumn(List<SchemaPath> paths, FunctionalIndexInfo functionInfo, List<SchemaPath> addedPaths) {
        if (!functionInfo.hasFunctional()) {
            return paths;
        }
        ArrayList<SchemaPath> newPaths = Lists.newArrayList(paths);
        for (int i = 0; i < paths.size(); ++i) {
            SchemaPath newPath = functionInfo.getNewPath(paths.get(i));
            if (newPath == null) continue;
            addedPaths.add(newPath);
            if (IndexPlanUtils.pathOnlyInIndexedFunction(paths.get(i))) {
                newPaths.set(i, newPath);
                continue;
            }
            newPaths.add(newPath);
        }
        return newPaths;
    }

    public static RexNode rewriteFunctionalRex(IndexCallContext indexContext, DrillParseContext parseContext, DrillProjectRelBase project, RelNode scan, RexNode toRewriteRex, RelDataType newRowType, FunctionalIndexInfo functionInfo) {
        Set<RexNode> rexs;
        if (!functionInfo.hasFunctional()) {
            return toRewriteRex;
        }
        RexToExpression.RexToDrillExt rexToDrill = new RexToExpression.RexToDrillExt(parseContext, project, scan);
        LogicalExpression expr = (LogicalExpression)toRewriteRex.accept((RexVisitor)rexToDrill);
        Map<LogicalExpression, Set<SchemaPath>> exprPathMap = functionInfo.getPathsInFunctionExpr();
        PathInExpr exprSearch = new PathInExpr(exprPathMap);
        expr.accept(exprSearch, null);
        Set<LogicalExpression> remainderPaths = exprSearch.getRemainderPaths();
        Map<LogicalExpression, Set<RexNode>> exprToRex = rexToDrill.getMapExprToRex();
        HashMap<RexNode, LogicalExpression> mapRexExpr = Maps.newHashMap();
        for (LogicalExpression leftExpr : remainderPaths) {
            if (!exprToRex.containsKey(leftExpr)) continue;
            rexs = exprToRex.get(leftExpr);
            for (RexNode rex : rexs) {
                mapRexExpr.put(rex, leftExpr);
            }
        }
        for (LogicalExpression functionExpr : functionInfo.getExprMap().keySet()) {
            if (!exprToRex.containsKey(functionExpr)) continue;
            rexs = exprToRex.get(functionExpr);
            for (RexNode rex : rexs) {
                mapRexExpr.put(rex, functionExpr);
            }
        }
        SimpleRexRemap remap = new SimpleRexRemap(indexContext.getScan(), newRowType, indexContext.getScan().getCluster().getRexBuilder());
        remap.setExpressionMap(functionInfo.getExprMap());
        return remap.rewriteWithMap(toRewriteRex, mapRexExpr);
    }

    public static RexNode getLeadingPrefixMap(Map<LogicalExpression, RexNode> leadingPrefixMap, List<LogicalExpression> indexCols, IndexConditionInfo.Builder builder, RexNode condition) {
        RexNode initCondition;
        boolean prefix = true;
        int i = 0;
        RexNode rexNode = initCondition = condition.isAlwaysTrue() ? null : condition;
        while (prefix && i < indexCols.size()) {
            LogicalExpression p;
            ImmutableList<LogicalExpression> prefixCol;
            IndexConditionInfo info;
            if ((info = builder.indexConditionRelatedToFields(prefixCol = ImmutableList.of(p = indexCols.get(i++)), initCondition)) != null && info.hasIndexCol) {
                leadingPrefixMap.put(p, info.indexCondition);
                initCondition = info.remainderCondition;
                if (!initCondition.isAlwaysTrue()) continue;
                initCondition = null;
                break;
            }
            prefix = false;
        }
        return initCondition;
    }

    public static List<RexNode> getLeadingFilters(Map<LogicalExpression, RexNode> leadingPrefixMap, List<LogicalExpression> indexCols) {
        ArrayList<RexNode> leadingFilters = Lists.newArrayList();
        if (leadingPrefixMap.size() > 0) {
            LogicalExpression p;
            RexNode n;
            Iterator<LogicalExpression> iterator = indexCols.iterator();
            while (iterator.hasNext() && (n = leadingPrefixMap.get(p = iterator.next())) != null) {
                leadingFilters.add(n);
            }
        }
        return leadingFilters;
    }

    public static RexNode getLeadingColumnsFilter(List<RexNode> leadingFilters, RexBuilder rexBuilder) {
        if (leadingFilters.size() > 0) {
            RexNode leadingColumnsFilter = RexUtil.composeConjunction((RexBuilder)rexBuilder, leadingFilters, (boolean)false);
            return leadingColumnsFilter;
        }
        return null;
    }

    public static RexNode getTotalRemainderFilter(RexNode indexColsRemFilter, RexNode incColsRemFilter, RexBuilder rexBuilder) {
        if (indexColsRemFilter != null && incColsRemFilter != null) {
            ArrayList<RexNode> operands = Lists.newArrayList();
            operands.add(indexColsRemFilter);
            operands.add(incColsRemFilter);
            RexNode totalRemainder = RexUtil.composeConjunction((RexBuilder)rexBuilder, operands, (boolean)false);
            return totalRemainder;
        }
        if (indexColsRemFilter != null) {
            return indexColsRemFilter;
        }
        return incColsRemFilter;
    }

    public static RexNode getTotalFilter(RexNode leadColsFilter, RexNode totRemColsFilter, RexBuilder rexBuilder) {
        RexNode condition = leadColsFilter;
        if (leadColsFilter != null && totRemColsFilter != null && !totRemColsFilter.isAlwaysTrue()) {
            ArrayList<RexNode> conditions = new ArrayList<RexNode>();
            conditions.add(leadColsFilter);
            conditions.add(totRemColsFilter);
            return RexUtil.composeConjunction((RexBuilder)rexBuilder, conditions, (boolean)true);
        }
        return condition;
    }

    public static enum ConditionIndexed {
        NONE,
        PARTIAL,
        FULL;

    }
}

