/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.exec.planner.logical.DrillOptiq;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;

public class IndexableExprMarker
extends RexVisitorImpl<Boolean> {
    final Map<RexNode, LogicalExpression> desiredExpressions = Maps.newHashMap();
    final Map<RexNode, LogicalExpression> equalityExpressions = Maps.newHashMap();
    final Map<RexNode, LogicalExpression> notInEquality = Maps.newHashMap();
    final Map<RexNode, LogicalExpression> equalOnCastChar = Maps.newHashMap();
    private final RelNode inputRel;
    boolean directCompareOp = false;
    RexCall contextCall = null;
    DrillParseContext parserContext;

    public IndexableExprMarker(RelNode inputRel) {
        super(true);
        this.inputRel = inputRel;
        this.parserContext = new DrillParseContext(PrelUtil.getPlannerSettings(inputRel.getCluster()));
    }

    public Map<RexNode, LogicalExpression> getIndexableExpression() {
        return ImmutableMap.copyOf(this.desiredExpressions);
    }

    public Map<RexNode, LogicalExpression> getEqualOnCastChar() {
        return ImmutableMap.copyOf(this.equalOnCastChar);
    }

    public Set<LogicalExpression> getExpressionsOnlyInEquality() {
        HashSet<LogicalExpression> onlyInEquality = Sets.newHashSet();
        HashSet<LogicalExpression> notInEqSet = Sets.newHashSet();
        HashSet<LogicalExpression> inEqMoreThanOnce = Sets.newHashSet();
        notInEqSet.addAll(this.notInEquality.values());
        for (LogicalExpression expr : this.equalityExpressions.values()) {
            if (notInEqSet.contains(expr) || inEqMoreThanOnce.contains(expr)) continue;
            if (onlyInEquality.contains(expr)) {
                inEqMoreThanOnce.add(expr);
                onlyInEquality.remove(expr);
                continue;
            }
            onlyInEquality.add(expr);
        }
        return onlyInEquality;
    }

    public Boolean visitInputRef(RexInputRef rexInputRef) {
        return this.directCompareOp;
    }

    public boolean containInputRef(RexNode rex) {
        if (rex instanceof RexInputRef) {
            return true;
        }
        return rex instanceof RexCall && "ITEM".equals(((RexCall)rex).getOperator().getName());
    }

    public boolean operandsAreIndexable(RexCall call) {
        boolean kindIsRight;
        SqlKind kind = call.getKind();
        boolean bl = kindIsRight = SqlKind.COMPARISON.contains(kind) || kind == SqlKind.LIKE || kind == SqlKind.SIMILAR;
        if (!kindIsRight) {
            return false;
        }
        int inputReference = 0;
        for (RexNode operand : call.operands) {
            if (!this.containInputRef(operand) || ++inputReference < 2) continue;
            return false;
        }
        return true;
    }

    public Boolean visitCall(RexCall call) {
        if (call.getKind() == SqlKind.NOT || call.getKind() == SqlKind.NOT_EQUALS || call.getKind() == SqlKind.NOT_IN) {
            return false;
        }
        if (this.operandsAreIndexable(call)) {
            for (RexNode operand : call.operands) {
                this.directCompareOp = true;
                this.contextCall = call;
                boolean markIt = (Boolean)operand.accept((RexVisitor)this);
                this.directCompareOp = false;
                this.contextCall = null;
                if (!markIt) continue;
                LogicalExpression expr = DrillOptiq.toDrill(this.parserContext, this.inputRel, operand);
                this.desiredExpressions.put(operand, expr);
                if (call.getKind() == SqlKind.EQUALS) {
                    this.equalityExpressions.put(operand, expr);
                    continue;
                }
                this.notInEquality.put(operand, expr);
            }
            return false;
        }
        if (this.directCompareOp) {
            if ("ITEM".equals(call.getOperator().getName())) {
                return this.directCompareOp;
            }
            if (call.getKind() == SqlKind.CAST) {
                RexNode castOp;
                if (this.contextCall != null && this.contextCall.getKind() == SqlKind.EQUALS && (call.getType().getSqlTypeName() == SqlTypeName.CHAR || call.getType().getSqlTypeName() == SqlTypeName.VARCHAR)) {
                    this.equalOnCastChar.put((RexNode)this.contextCall, DrillOptiq.toDrill(this.parserContext, this.inputRel, (RexNode)call));
                }
                if ((castOp = (RexNode)call.operands.get(0)) instanceof RexInputRef) {
                    return true;
                }
                if (castOp instanceof RexCall && "ITEM".equals(((RexCall)castOp).getOperator().getName())) {
                    return true;
                }
            }
        }
        for (RexNode operand : call.operands) {
            boolean bl = (Boolean)operand.accept((RexVisitor)this);
        }
        return false;
    }

    public Boolean visitLocalRef(RexLocalRef localRef) {
        return false;
    }

    public Boolean visitLiteral(RexLiteral literal) {
        return false;
    }

    public Boolean visitOver(RexOver over) {
        return false;
    }

    public Boolean visitCorrelVariable(RexCorrelVariable correlVariable) {
        return false;
    }

    public Boolean visitDynamicParam(RexDynamicParam dynamicParam) {
        return false;
    }

    public Boolean visitRangeRef(RexRangeRef rangeRef) {
        return false;
    }

    public Boolean visitFieldAccess(RexFieldAccess fieldAccess) {
        RexNode expr = fieldAccess.getReferenceExpr();
        return (Boolean)expr.accept((RexVisitor)this);
    }
}

