/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index.generators;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.DbGroupScan;
import org.apache.drill.exec.planner.common.DrillProjectRelBase;
import org.apache.drill.exec.planner.common.DrillScanRelBase;
import org.apache.drill.exec.planner.common.OrderedRel;
import org.apache.drill.exec.planner.index.IndexCallContext;
import org.apache.drill.exec.planner.index.IndexPlanUtils;
import org.apache.drill.exec.planner.logical.DrillFilterRel;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.DrillSortRel;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.HashToMergeExchangePrel;
import org.apache.drill.exec.planner.physical.LimitPrel;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.SingleMergeExchangePrel;
import org.apache.drill.exec.planner.physical.SortPrel;
import org.apache.drill.exec.planner.physical.SubsetTransformer;
import org.apache.drill.exec.planner.physical.TopNPrel;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIndexPlanGenerator
extends SubsetTransformer<RelNode, InvalidRelException> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractIndexPlanGenerator.class);
    protected final DrillProjectRelBase origProject;
    protected final DrillScanRelBase origScan;
    protected final DrillProjectRelBase upperProject;
    protected final RexNode indexCondition;
    protected final RexNode remainderCondition;
    protected final RexBuilder builder;
    protected final IndexCallContext indexContext;
    protected final PlannerSettings settings;

    public AbstractIndexPlanGenerator(IndexCallContext indexContext, RexNode indexCondition, RexNode remainderCondition, RexBuilder builder, PlannerSettings settings) {
        super(indexContext.getCall());
        this.origProject = indexContext.getLowerProject();
        this.origScan = indexContext.getScan();
        this.upperProject = indexContext.getUpperProject();
        this.indexCondition = indexCondition;
        this.remainderCondition = remainderCondition;
        this.indexContext = indexContext;
        this.builder = builder;
        this.settings = settings;
    }

    public static int getRowKeyIndex(RelDataType rowType, DrillScanRelBase origScan) {
        List fieldNames = rowType.getFieldNames();
        int idx = 0;
        for (String field : fieldNames) {
            if (field.equalsIgnoreCase(((DbGroupScan)IndexPlanUtils.getGroupScan(origScan)).getRowKeyName())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    protected RelDataType convertRowType(RelDataType origRowType, RelDataTypeFactory typeFactory) {
        if (AbstractIndexPlanGenerator.getRowKeyIndex(origRowType, this.origScan) >= 0) {
            return origRowType;
        }
        ArrayList<RelDataTypeFieldImpl> fields = new ArrayList<RelDataTypeFieldImpl>();
        fields.addAll(origRowType.getFieldList());
        fields.add(new RelDataTypeFieldImpl(((DbGroupScan)IndexPlanUtils.getGroupScan(this.origScan)).getRowKeyName(), fields.size(), typeFactory.createSqlType(SqlTypeName.ANY)));
        return new RelRecordType(fields);
    }

    protected boolean checkRowKey(List<SchemaPath> columns) {
        for (SchemaPath s : columns) {
            if (!s.equals(((DbGroupScan)IndexPlanUtils.getGroupScan(this.origScan)).getRowKeyPath())) continue;
            return true;
        }
        return false;
    }

    protected RelNode createRangeDistRight(RelNode rightPrel, RelDataTypeField rightRowKeyField, DbGroupScan origDbGroupScan) {
        ArrayList<DrillDistributionTrait.DistributionField> rangeDistFields = Lists.newArrayList(new DrillDistributionTrait.DistributionField(0));
        FieldReference rangeDistRef = FieldReference.getWithQuotedRef(rightRowKeyField.getName());
        ArrayList<FieldReference> rangeDistRefList = Lists.newArrayList();
        rangeDistRefList.add(rangeDistRef);
        DrillDistributionTrait distRight = IndexPlanUtils.scanIsPartition(origDbGroupScan) ? new DrillDistributionTrait(DrillDistributionTrait.DistributionType.RANGE_DISTRIBUTED, ImmutableList.copyOf(rangeDistFields), origDbGroupScan.getRangePartitionFunction(rangeDistRefList)) : DrillDistributionTrait.SINGLETON;
        RelTraitSet rightTraits = this.newTraitSet(distRight).plus((RelTrait)Prel.DRILL_PHYSICAL);
        RelNode convertedRight = Prule.convert(rightPrel, rightTraits);
        return convertedRight;
    }

    @Override
    public RelTraitSet newTraitSet(RelTrait ... traits) {
        RelTraitSet set = this.indexContext.getCall().getPlanner().emptyTraitSet();
        for (RelTrait t : traits) {
            if (t == null) continue;
            set = set.plus(t);
        }
        return set;
    }

    protected static boolean toRemoveSort(RelCollation sortCollation, RelCollation inputCollation) {
        return inputCollation != null && inputCollation.satisfies((RelTrait)sortCollation);
    }

    public static RelNode getExchange(RelOptCluster cluster, boolean isSingleton, boolean isExchangeRequired, RelTraitSet traits, DrillDistributionTrait distributionTrait, IndexCallContext indexContext, RelNode input) {
        if (!isExchangeRequired) {
            return input;
        }
        if (isSingleton) {
            return new SingleMergeExchangePrel(cluster, traits.replace((RelTrait)DrillDistributionTrait.SINGLETON), input, indexContext.getCollation());
        }
        return new HashToMergeExchangePrel(cluster, traits.replace((RelTrait)distributionTrait), input, distributionTrait.getFields(), indexContext.getCollation(), PrelUtil.getSettings(cluster).numEndPoints());
    }

    private static RelNode getSortOrTopN(IndexCallContext indexContext, RelNode sortNode, RelNode newRel, RelNode child) {
        if (sortNode instanceof TopNPrel) {
            return new TopNPrel(sortNode.getCluster(), newRel.getTraitSet().replace((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)indexContext.getCollation()), child, ((TopNPrel)sortNode).getLimit(), indexContext.getCollation());
        }
        return new SortPrel(sortNode.getCluster(), newRel.getTraitSet().replace((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)indexContext.getCollation()), child, indexContext.getCollation());
    }

    public static RelNode getSortNode(IndexCallContext indexContext, RelNode newRel, boolean donotGenerateSort, boolean isSingleton, boolean isExchangeRequired) {
        OrderedRel rel = indexContext.getSort();
        DrillDistributionTrait hashDistribution = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(indexContext.getDistributionFields()));
        if (AbstractIndexPlanGenerator.toRemoveSort(indexContext.getCollation(), (RelCollation)newRel.getTraitSet().getTrait((RelTraitDef)RelCollationTraitDef.INSTANCE))) {
            logger.debug("Not generating SortPrel since we have the required collation");
            if (IndexPlanUtils.generateLimit(rel)) {
                newRel = new LimitPrel(newRel.getCluster(), newRel.getTraitSet().plus((RelTrait)indexContext.getCollation()).plus((RelTrait)Prel.DRILL_PHYSICAL), newRel, IndexPlanUtils.getOffset(rel), IndexPlanUtils.getFetch(rel));
            }
            RelTraitSet traits = newRel.getTraitSet().plus((RelTrait)indexContext.getCollation()).plus((RelTrait)Prel.DRILL_PHYSICAL);
            newRel = Prule.convert(newRel, traits);
            newRel = AbstractIndexPlanGenerator.getExchange(newRel.getCluster(), isSingleton, isExchangeRequired, traits, hashDistribution, indexContext, newRel);
        } else {
            if (donotGenerateSort) {
                logger.debug("Not generating SortPrel and index plan, since just picking index for full index scan is not beneficial.");
                return null;
            }
            RelTraitSet traits = newRel.getTraitSet().plus((RelTrait)indexContext.getCollation()).plus((RelTrait)Prel.DRILL_PHYSICAL);
            newRel = AbstractIndexPlanGenerator.getSortOrTopN(indexContext, rel, newRel, Prule.convert(newRel, newRel.getTraitSet().replace((RelTrait)Prel.DRILL_PHYSICAL)));
            newRel = AbstractIndexPlanGenerator.getExchange(newRel.getCluster(), isSingleton, isExchangeRequired, traits, hashDistribution, indexContext, newRel);
        }
        return newRel;
    }

    @Override
    public abstract RelNode convertChild(RelNode var1, RelNode var2) throws InvalidRelException;

    @Override
    public boolean forceConvert() {
        return true;
    }

    public void go() throws InvalidRelException {
        RelNode input;
        RelNode top = this.indexContext.getCall().rel(0);
        if (top instanceof DrillProjectRel) {
            DrillProjectRel topProject = (DrillProjectRel)top;
            input = topProject.getInput();
        } else if (top instanceof DrillFilterRel) {
            DrillFilterRel topFilter = (DrillFilterRel)top;
            input = topFilter.getInput();
        } else if (top instanceof DrillSortRel) {
            DrillSortRel topSort = (DrillSortRel)top;
            input = topSort.getInput();
        } else {
            return;
        }
        RelTraitSet traits = input.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL);
        RelNode convertedInput = Prule.convert(input, traits);
        this.go(top, convertedInput);
    }
}

