/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index.generators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.drill.exec.physical.base.IndexGroupScan;
import org.apache.drill.exec.planner.index.FunctionalIndexHelper;
import org.apache.drill.exec.planner.index.FunctionalIndexInfo;
import org.apache.drill.exec.planner.index.IndexDescriptor;
import org.apache.drill.exec.planner.index.IndexLogicalPlanCallContext;
import org.apache.drill.exec.planner.index.IndexPlanUtils;
import org.apache.drill.exec.planner.index.SimpleRexRemap;
import org.apache.drill.exec.planner.index.generators.AbstractIndexPlanGenerator;
import org.apache.drill.exec.planner.logical.DrillMergeProjectRule;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.physical.FilterPrel;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoveringIndexPlanGenerator
extends AbstractIndexPlanGenerator {
    static final Logger logger = LoggerFactory.getLogger(CoveringIndexPlanGenerator.class);
    protected final IndexGroupScan indexGroupScan;
    protected final IndexDescriptor indexDesc;
    protected final FunctionalIndexInfo functionInfo;

    public CoveringIndexPlanGenerator(IndexLogicalPlanCallContext indexContext, FunctionalIndexInfo functionInfo, IndexGroupScan indexGroupScan, RexNode indexCondition, RexNode remainderCondition, RexBuilder builder, PlannerSettings settings) {
        super(indexContext, indexCondition, remainderCondition, builder, settings);
        this.indexGroupScan = indexGroupScan;
        this.functionInfo = functionInfo;
        this.indexDesc = functionInfo.getIndexDesc();
    }

    private RexNode rewriteFunctionalCondition(RexNode inputIndex, RelDataType newRowType, FunctionalIndexInfo functionInfo) {
        if (!functionInfo.hasFunctional()) {
            return inputIndex;
        }
        return FunctionalIndexHelper.convertConditionForIndexScan(inputIndex, this.origScan, newRowType, this.builder, functionInfo);
    }

    @Override
    public RelNode convertChild(RelNode filter, RelNode input) throws InvalidRelException {
        if (this.indexGroupScan == null) {
            logger.error("Null indexgroupScan in CoveringIndexPlanGenerator.convertChild");
            return null;
        }
        ScanPrel indexScanPrel = IndexPlanUtils.buildCoveringIndexScan(this.origScan, this.indexGroupScan, this.indexContext, this.indexDesc);
        RexNode coveringCondition = IndexPlanUtils.getTotalFilter(this.indexCondition, this.remainderCondition, indexScanPrel.getCluster().getRexBuilder());
        RexNode newIndexCondition = this.rewriteFunctionalCondition(coveringCondition, indexScanPrel.getRowType(), this.functionInfo);
        RelTraitSet indexFilterTraitSet = indexScanPrel.getTraitSet();
        FilterPrel indexFilterPrel = new FilterPrel(indexScanPrel.getCluster(), indexFilterTraitSet, indexScanPrel, newIndexCondition);
        Prel indexProjectPrel = null;
        if (this.origProject != null) {
            RelCollation collation = IndexPlanUtils.buildCollationProject(IndexPlanUtils.getProjects(this.origProject), null, this.origScan, this.functionInfo, this.indexContext);
            indexProjectPrel = new ProjectPrel(this.origScan.getCluster(), indexFilterTraitSet.plus((RelTrait)collation), indexFilterPrel, IndexPlanUtils.getProjects(this.origProject), this.origProject.getRowType());
        }
        Prel finalRel = indexProjectPrel != null ? indexProjectPrel : indexFilterPrel;
        if (this.upperProject != null) {
            RelCollation newCollation = IndexPlanUtils.buildCollationProject(IndexPlanUtils.getProjects(this.upperProject), this.origProject, this.origScan, this.functionInfo, this.indexContext);
            ProjectPrel cap = new ProjectPrel(this.upperProject.getCluster(), newCollation == null ? finalRel.getTraitSet() : finalRel.getTraitSet().plus((RelTrait)newCollation), finalRel, IndexPlanUtils.getProjects(this.upperProject), this.upperProject.getRowType());
            if (this.functionInfo.hasFunctional()) {
                ProjectPrel rewrittenProject;
                ProjectPrel newProject = cap;
                if (indexProjectPrel != null) {
                    newProject = (ProjectPrel)DrillMergeProjectRule.replace(newProject, (Project)indexProjectPrel);
                }
                ArrayList<RexNode> newProjects = Lists.newArrayList();
                DrillParseContext parseContxt = new DrillParseContext(PrelUtil.getPlannerSettings(newProject.getCluster()));
                for (RexNode projectRex : newProject.getProjects()) {
                    RexNode newRex = IndexPlanUtils.rewriteFunctionalRex(this.indexContext, parseContxt, null, this.origScan, projectRex, indexScanPrel.getRowType(), this.functionInfo);
                    newProjects.add(newRex);
                }
                cap = rewrittenProject = new ProjectPrel(newProject.getCluster(), newCollation == null ? newProject.getTraitSet() : newProject.getTraitSet().plus((RelTrait)newCollation), indexFilterPrel, newProjects, newProject.getRowType());
            }
            finalRel = cap;
        }
        if (this.indexContext.getSort() != null) {
            Preconditions.checkArgument((finalRel = CoveringIndexPlanGenerator.getSortNode(this.indexContext, finalRel, false, true, true)) != null);
        }
        finalRel = Prule.convert(finalRel, finalRel.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL));
        logger.debug("CoveringIndexPlanGenerator got finalRel {} from origScan {}, original digest {}, new digest {}.", new Object[]{finalRel.toString(), this.origScan.toString(), this.upperProject == null ? this.indexContext.getFilter().getDigest() : this.upperProject.getDigest(), finalRel.getDigest()});
        return finalRel;
    }

    private RexNode rewriteConditionForProject(RexNode condition, List<RexNode> projects) {
        HashMap<RexNode, RexNode> mapping = new HashMap<RexNode, RexNode>();
        this.rewriteConditionForProjectInternal(condition, projects, mapping);
        SimpleRexRemap.RexReplace replacer = new SimpleRexRemap.RexReplace(mapping);
        return (RexNode)condition.accept((RexVisitor)replacer);
    }

    private void rewriteConditionForProjectInternal(RexNode condition, List<RexNode> projects, Map<RexNode, RexNode> mapping) {
        block5: {
            if (!(condition instanceof RexCall)) break block5;
            if ("ITEM".equals(((RexCall)condition).getOperator().getName().toUpperCase())) {
                int index = 0;
                for (RexNode project : projects) {
                    if (project.toString().equals(condition.toString())) {
                        mapping.put(condition, (RexNode)new RexInputRef(index, project.getType()));
                    }
                    ++index;
                }
            } else {
                for (RexNode child : ((RexCall)condition).getOperands()) {
                    this.rewriteConditionForProjectInternal(child, projects, mapping);
                }
            }
        }
    }
}

