/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index.generators;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.DbGroupScan;
import org.apache.drill.exec.physical.base.IndexGroupScan;
import org.apache.drill.exec.planner.index.FunctionalIndexHelper;
import org.apache.drill.exec.planner.index.FunctionalIndexInfo;
import org.apache.drill.exec.planner.index.IndexDescriptor;
import org.apache.drill.exec.planner.index.IndexLogicalPlanCallContext;
import org.apache.drill.exec.planner.index.IndexPlanUtils;
import org.apache.drill.exec.planner.index.generators.AbstractIndexPlanGenerator;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.DrillDistributionTraitDef;
import org.apache.drill.exec.planner.physical.FilterPrel;
import org.apache.drill.exec.planner.physical.HashJoinPrel;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.RowKeyJoinPrel;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonCoveringIndexPlanGenerator
extends AbstractIndexPlanGenerator {
    static final Logger logger = LoggerFactory.getLogger(NonCoveringIndexPlanGenerator.class);
    protected final IndexGroupScan indexGroupScan;
    private final IndexDescriptor indexDesc;
    protected final FunctionalIndexInfo functionInfo;

    public NonCoveringIndexPlanGenerator(IndexLogicalPlanCallContext indexContext, IndexDescriptor indexDesc, IndexGroupScan indexGroupScan, RexNode indexCondition, RexNode remainderCondition, RexBuilder builder, PlannerSettings settings) {
        super(indexContext, indexCondition, remainderCondition, builder, settings);
        this.indexGroupScan = indexGroupScan;
        this.indexDesc = indexDesc;
        this.functionInfo = indexDesc.getFunctionalInfo();
    }

    @Override
    public RelNode convertChild(RelNode topRel, RelNode input) throws InvalidRelException {
        Prel newRel;
        RelDataType origRowType;
        ScanPrel dbScan;
        DbGroupScan restrictedGroupScan;
        RelNode rangeDistRight;
        if (this.indexGroupScan == null) {
            logger.error("Null indexgroupScan in NonCoveringIndexPlanGenerator.convertChild");
            return null;
        }
        RelDataType dbscanRowType = this.convertRowType(this.origScan.getRowType(), this.origScan.getCluster().getTypeFactory());
        RelDataType indexScanRowType = FunctionalIndexHelper.convertRowTypeForIndexScan(this.origScan, this.indexContext.getOrigMarker(), this.indexGroupScan, this.functionInfo);
        DrillDistributionTrait partition = IndexPlanUtils.scanIsPartition(IndexPlanUtils.getGroupScan(this.origScan)) ? DrillDistributionTrait.RANDOM_DISTRIBUTED : DrillDistributionTrait.SINGLETON;
        ScanPrel indexScanPrel = new ScanPrel(this.origScan.getCluster(), this.origScan.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)partition), this.indexGroupScan, indexScanRowType, this.origScan.getTable());
        DbGroupScan origDbGroupScan = (DbGroupScan)IndexPlanUtils.getGroupScan(this.origScan);
        RexNode convertedIndexCondition = FunctionalIndexHelper.convertConditionForIndexScan(this.indexCondition, this.origScan, indexScanRowType, this.builder, this.functionInfo);
        FilterPrel rightIndexFilterPrel = new FilterPrel(indexScanPrel.getCluster(), indexScanPrel.getTraitSet(), indexScanPrel, convertedIndexCondition);
        double finalRowCount = this.indexGroupScan.getRowCount(this.indexContext.getOrigCondition(), this.origScan);
        ArrayList<RexNode> rightProjectExprs = Lists.newArrayList();
        int rightRowKeyIndex = NonCoveringIndexPlanGenerator.getRowKeyIndex(indexScanPrel.getRowType(), this.origScan);
        assert (rightRowKeyIndex >= 0);
        rightProjectExprs.add((RexNode)RexInputRef.of((int)rightRowKeyIndex, (RelDataType)indexScanPrel.getRowType()));
        List indexScanFields = indexScanPrel.getRowType().getFieldList();
        RelDataTypeFactory.FieldInfoBuilder rightFieldTypeBuilder = indexScanPrel.getCluster().getTypeFactory().builder();
        RelDataTypeField rightRowKeyField = (RelDataTypeField)indexScanFields.get(rightRowKeyIndex);
        rightFieldTypeBuilder.add(rightRowKeyField);
        RelDataType rightProjectRowType = rightFieldTypeBuilder.build();
        ProjectPrel rightIndexProjectPrel = new ProjectPrel(indexScanPrel.getCluster(), indexScanPrel.getTraitSet(), rightIndexFilterPrel, rightProjectExprs, rightProjectRowType);
        RelNode convertedRight = rangeDistRight = this.createRangeDistRight(rightIndexProjectPrel, rightRowKeyField, origDbGroupScan);
        ArrayList<SchemaPath> cols = new ArrayList<SchemaPath>(origDbGroupScan.getColumns());
        if (!this.checkRowKey(cols)) {
            cols.add(origDbGroupScan.getRowKeyPath());
        }
        if ((restrictedGroupScan = origDbGroupScan.getRestrictedScan(cols)) == null) {
            logger.error("Null restricted groupscan in NonCoveringIndexPlanGenerator.convertChild");
            return null;
        }
        DrillScanRel rightIdxRel = new DrillScanRel(this.origScan.getCluster(), this.origScan.getTraitSet(), this.origScan.getTable(), this.origScan.getRowType(), this.indexContext.getScanColumns());
        double rightIdxRowCount = this.indexGroupScan.getRowCount(this.indexCondition, rightIdxRel);
        restrictedGroupScan.setRowCount(null, rightIdxRowCount, rightIdxRowCount);
        RelTraitSet origScanTraitSet = this.origScan.getTraitSet();
        RelTraitSet restrictedScanTraitSet = origScanTraitSet.plus((RelTrait)Prel.DRILL_PHYSICAL);
        RelCollation collation = null;
        if (this.indexDesc.getCollation() != null && !this.settings.isIndexForceSortNonCovering()) {
            collation = IndexPlanUtils.buildCollationNonCoveringIndexScan(this.indexDesc, indexScanRowType, dbscanRowType, this.indexContext);
            restrictedScanTraitSet = restrictedScanTraitSet.getTrait((RelTraitDef)RelCollationTraitDef.INSTANCE) != null ? restrictedScanTraitSet.plus((RelTrait)partition).replace((RelTrait)collation) : restrictedScanTraitSet.plus((RelTrait)partition).plus((RelTrait)collation);
        }
        Prel lastLeft = dbScan = new ScanPrel(this.origScan.getCluster(), restrictedScanTraitSet, restrictedGroupScan, dbscanRowType, this.origScan.getTable());
        ArrayList<RexNode> leftProjectExprs = Lists.newArrayList();
        int leftRowKeyIndex = NonCoveringIndexPlanGenerator.getRowKeyIndex(dbScan.getRowType(), this.origScan);
        RelDataTypeField leftRowKeyField = (RelDataTypeField)dbScan.getRowType().getFieldList().get(leftRowKeyIndex);
        RelDataTypeFactory.FieldInfoBuilder leftFieldTypeBuilder = dbScan.getCluster().getTypeFactory().builder();
        FilterPrel leftIndexFilterPrel = null;
        if (this.indexDesc.isAsyncIndex()) {
            leftIndexFilterPrel = new FilterPrel(dbScan.getCluster(), dbScan.getTraitSet(), dbScan, this.indexContext.getOrigCondition());
            lastLeft = leftIndexFilterPrel;
        }
        RelDataType relDataType = origRowType = this.origProject == null ? this.origScan.getRowType() : this.origProject.getRowType();
        if (this.origProject != null) {
            List origProjFields = origRowType.getFieldList();
            leftFieldTypeBuilder.addAll((Iterable)origProjFields);
            leftProjectExprs.addAll(IndexPlanUtils.getProjects(this.origProject));
            if (NonCoveringIndexPlanGenerator.getRowKeyIndex(origRowType, this.origScan) < 0) {
                leftFieldTypeBuilder.add(leftRowKeyField);
                leftProjectExprs.add((RexNode)RexInputRef.of((int)leftRowKeyIndex, (RelDataType)dbScan.getRowType()));
            }
            RelDataType leftProjectRowType = leftFieldTypeBuilder.build();
            if (!this.settings.isIndexForceSortNonCovering()) {
                collation = IndexPlanUtils.buildCollationProject(leftProjectExprs, null, dbScan, this.functionInfo, this.indexContext);
            }
            ProjectPrel leftIndexProjectPrel = new ProjectPrel(dbScan.getCluster(), collation != null ? dbScan.getTraitSet().plus((RelTrait)collation) : dbScan.getTraitSet(), leftIndexFilterPrel == null ? dbScan : leftIndexFilterPrel, leftProjectExprs, leftProjectRowType);
            lastLeft = leftIndexProjectPrel;
        }
        RelTraitSet leftTraits = dbScan.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL);
        RelNode convertedLeft = Prule.convert(lastLeft, leftTraits);
        int leftRowKeyIdx = NonCoveringIndexPlanGenerator.getRowKeyIndex(convertedLeft.getRowType(), this.origScan);
        boolean rightRowKeyIdx = false;
        assert (leftRowKeyIdx >= 0);
        ImmutableList<Integer> leftJoinKeys = ImmutableList.of(Integer.valueOf(leftRowKeyIdx));
        ImmutableList<Integer> rightJoinKeys = ImmutableList.of(Integer.valueOf(0));
        RexNode joinCondition = RelOptUtil.createEquiJoinCondition((RelNode)convertedLeft, leftJoinKeys, (RelNode)convertedRight, rightJoinKeys, (RexBuilder)this.builder);
        if (this.settings.isIndexUseHashJoinNonCovering()) {
            HashJoinPrel hjPrel;
            newRel = hjPrel = new HashJoinPrel(topRel.getCluster(), leftTraits, convertedLeft, convertedRight, joinCondition, JoinRelType.INNER, false, null, true, 0);
        } else {
            RowKeyJoinPrel rjPrel = new RowKeyJoinPrel(topRel.getCluster(), collation != null ? leftTraits.plus((RelTrait)collation) : leftTraits, convertedLeft, convertedRight, joinCondition, JoinRelType.INNER);
            rjPrel.setEstimatedRowCount(finalRowCount);
            newRel = rjPrel;
        }
        RelDataTypeFactory.FieldInfoBuilder finalFieldTypeBuilder = this.origScan.getCluster().getTypeFactory().builder();
        List rjRowFields = newRel.getRowType().getFieldList();
        int toRemoveRowKeyCount = 1;
        if (NonCoveringIndexPlanGenerator.getRowKeyIndex(origRowType, this.origScan) < 0) {
            toRemoveRowKeyCount = 2;
        }
        finalFieldTypeBuilder.addAll(rjRowFields.subList(0, rjRowFields.size() - toRemoveRowKeyCount));
        RelDataType finalProjectRowType = finalFieldTypeBuilder.build();
        ArrayList<RexNode> resetExprs = Lists.newArrayList();
        for (int idx = 0; idx < rjRowFields.size() - toRemoveRowKeyCount; ++idx) {
            resetExprs.add((RexNode)RexInputRef.of((int)idx, (RelDataType)newRel.getRowType()));
        }
        ProjectPrel resetProjectPrel = new ProjectPrel(newRel.getCluster(), newRel.getTraitSet(), newRel, resetExprs, finalProjectRowType);
        newRel = resetProjectPrel;
        if (this.upperProject != null) {
            RelCollation newCollation = RelCollations.of((List)RelCollations.EMPTY.getFieldCollations());
            DrillDistributionTrait newDist = null;
            newDist = (DrillDistributionTrait)this.upperProject.getInput().getTraitSet().getTrait((RelTraitDef)DrillDistributionTraitDef.INSTANCE);
            if (!this.settings.isIndexForceSortNonCovering()) {
                newCollation = IndexPlanUtils.buildCollationProject(IndexPlanUtils.getProjects(this.upperProject), this.origProject, this.origScan, this.functionInfo, this.indexContext);
            }
            RelTraitSet newProjectTraits = this.newTraitSet(new RelTrait[]{Prel.DRILL_PHYSICAL, newDist, newCollation});
            ProjectPrel cap = new ProjectPrel(this.upperProject.getCluster(), newProjectTraits, newRel, IndexPlanUtils.getProjects(this.upperProject), this.upperProject.getRowType());
            newRel = cap;
        }
        if (this.indexContext.getSort() != null) {
            if (NonCoveringIndexPlanGenerator.toRemoveSort(this.indexContext.getCollation(), (RelCollation)newRel.getTraitSet().getTrait((RelTraitDef)RelCollationTraitDef.INSTANCE))) {
                ((IndexGroupScan)indexScanPrel.getGroupScan()).setParallelizationWidth(1);
            }
            Preconditions.checkArgument((newRel = NonCoveringIndexPlanGenerator.getSortNode(this.indexContext, newRel, false, true, true)) != null);
        }
        RelNode finalRel = Prule.convert(newRel, newRel.getTraitSet());
        logger.debug("NonCoveringIndexPlanGenerator got finalRel {} from origScan {}", (Object)finalRel.toString(), (Object)this.origScan.toString());
        return finalRel;
    }
}

