/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index.rules;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.drill.exec.physical.base.DbGroupScan;
import org.apache.drill.exec.planner.common.OrderedRel;
import org.apache.drill.exec.planner.index.FunctionalIndexInfo;
import org.apache.drill.exec.planner.index.IndexCollection;
import org.apache.drill.exec.planner.index.IndexDescriptor;
import org.apache.drill.exec.planner.index.IndexPhysicalPlanCallContext;
import org.apache.drill.exec.planner.index.IndexPlanUtils;
import org.apache.drill.exec.planner.index.IndexProperties;
import org.apache.drill.exec.planner.index.IndexSelector;
import org.apache.drill.exec.planner.index.generators.AbstractIndexPlanGenerator;
import org.apache.drill.exec.planner.index.generators.CoveringPlanNoFilterGenerator;
import org.apache.drill.exec.planner.index.rules.AbstractMatchFunction;
import org.apache.drill.exec.planner.index.rules.MatchFunction;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.ExchangePrel;
import org.apache.drill.exec.planner.physical.HashToRandomExchangePrel;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbScanSortRemovalRule
extends Prule {
    static final Logger logger = LoggerFactory.getLogger(DbScanSortRemovalRule.class);
    public static final RelOptRule INDEX_SORT_EXCHANGE_SCAN = new DbScanSortRemovalRule(RelOptHelper.some(OrderedRel.class, RelOptHelper.some(HashToRandomExchangePrel.class, RelOptHelper.any(ScanPrel.class), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "DbScanSortRemovalRule:sort_exchange_Scan", new MatchSES());
    public static final RelOptRule INDEX_SORT_SCAN = new DbScanSortRemovalRule(RelOptHelper.some(OrderedRel.class, RelOptHelper.any(ScanPrel.class), new RelOptRuleOperand[0]), "DbScanSortRemovalRule:Sort_Scan", new MatchSS());
    public static final RelOptRule INDEX_SORT_PROJ_SCAN = new DbScanSortRemovalRule(RelOptHelper.some(OrderedRel.class, RelOptHelper.some(ProjectPrel.class, RelOptHelper.any(ScanPrel.class), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "DbScanSortRemovalRule:Sort_Proj_Scan", new MatchSPS());
    public static final RelOptRule INDEX_SORT_EXCHANGE_PROJ_SCAN = new DbScanSortRemovalRule(RelOptHelper.some(OrderedRel.class, RelOptHelper.some(HashToRandomExchangePrel.class, RelOptHelper.some(ProjectPrel.class, RelOptHelper.any(ScanPrel.class), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "DbScanSortRemovalRule:sort_exchange_proj_Scan", new MatchSEPS());
    private final MatchFunction match;

    private DbScanSortRemovalRule(RelOptRuleOperand operand, String description, MatchFunction match) {
        super(operand, description);
        this.match = match;
    }

    private static boolean isRemovableRel(OrderedRel node) {
        return node.canBeDropped();
    }

    public boolean matches(RelOptRuleCall call) {
        return this.match.match(call);
    }

    public void onMatch(RelOptRuleCall call) {
        this.doOnMatch((IndexPhysicalPlanCallContext)this.match.onMatch(call));
    }

    private void doOnMatch(IndexPhysicalPlanCallContext indexContext) {
        Stopwatch indexPlanTimer;
        block14: {
            indexPlanTimer = Stopwatch.createStarted();
            PlannerSettings settings = PrelUtil.getPlannerSettings(indexContext.call.getPlanner());
            DbGroupScan groupScan = (DbGroupScan)indexContext.scan.getGroupScan();
            boolean isIndexScan = groupScan.isIndexScan();
            if (!isIndexScan) {
                IndexCollection indexCollection = groupScan.getSecondaryIndexCollection(indexContext.scan);
                if (indexCollection == null) {
                    return;
                }
                if (settings.isStatisticsEnabled()) {
                    groupScan.getStatistics().initialize(null, indexContext.scan, indexContext);
                }
                IndexPlanUtils.updateSortExpression(indexContext, indexContext.getSort() != null ? indexContext.getCollation().getFieldCollations() : null);
                IndexSelector selector = new IndexSelector(indexContext);
                for (IndexDescriptor indexDesc : indexCollection) {
                    indexDesc.getIndexGroupScan().setStatistics(groupScan.getStatistics());
                    FunctionalIndexInfo functionInfo = indexDesc.getFunctionalInfo();
                    if (!IndexPlanUtils.isCoveringIndex(indexContext, functionInfo)) continue;
                    selector.addIndex(indexDesc, true, indexContext.lowerProject != null ? indexContext.lowerProject.getRowType().getFieldCount() : indexContext.scan.getRowType().getFieldCount());
                }
                IndexProperties idxProp = selector.getBestIndexNoFilter();
                if (idxProp != null) {
                    try {
                        CoveringPlanNoFilterGenerator planGen = new CoveringPlanNoFilterGenerator(indexContext, idxProp.getIndexDesc().getFunctionalInfo(), false, settings);
                        if (planGen.convertChild() != null) {
                            indexContext.getCall().transformTo(planGen.convertChild());
                            break block14;
                        }
                        logger.debug("Not able to generate index plan in {}", (Object)((Object)((Object)this)).getClass().toString());
                    }
                    catch (Exception e) {
                        logger.warn("Exception while trying to generate indexscan to remove sort", (Throwable)e);
                    }
                }
            } else {
                Preconditions.checkNotNull(indexContext.getSort());
                if (((RelCollation)indexContext.scan.getTraitSet().getTrait((RelTraitDef)RelCollationTraitDef.INSTANCE)).getFieldCollations().size() == 0) {
                    return;
                }
                try {
                    RelNode finalRel = indexContext.scan.copy(indexContext.scan.getTraitSet(), indexContext.scan.getInputs());
                    if (indexContext.lowerProject != null) {
                        ArrayList<RelNode> inputs = Lists.newArrayList();
                        inputs.add(finalRel);
                        finalRel = indexContext.lowerProject.copy(indexContext.lowerProject.getTraitSet(), inputs);
                    }
                    if ((finalRel = AbstractIndexPlanGenerator.getSortNode(indexContext, finalRel, true, false, indexContext.exch != null)) == null) {
                        logger.debug("Not able to generate index plan in {}", (Object)((Object)((Object)this)).getClass().toString());
                        return;
                    }
                    finalRel = Prule.convert(finalRel, finalRel.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL));
                    indexContext.getCall().transformTo(finalRel);
                }
                catch (Exception e) {
                    logger.warn("Exception while trying to use the indexscan to remove the sort", (Throwable)e);
                }
            }
        }
        indexPlanTimer.stop();
        logger.debug("Index Planning took {} ms", (Object)indexPlanTimer.elapsed(TimeUnit.MILLISECONDS));
    }

    private static class MatchSES
    extends AbstractMatchFunction<IndexPhysicalPlanCallContext> {
        private MatchSES() {
        }

        @Override
        public boolean match(RelOptRuleCall call) {
            OrderedRel sort = (OrderedRel)call.rel(0);
            ScanPrel scan = (ScanPrel)call.rel(2);
            return sort instanceof Prel && this.checkScan(scan.getGroupScan()) && DbScanSortRemovalRule.isRemovableRel(sort);
        }

        @Override
        public IndexPhysicalPlanCallContext onMatch(RelOptRuleCall call) {
            ScanPrel scan = (ScanPrel)call.rel(2);
            OrderedRel sort = (OrderedRel)call.rel(0);
            ExchangePrel exch = (ExchangePrel)call.rel(1);
            return new IndexPhysicalPlanCallContext(call, sort, null, scan, exch);
        }
    }

    private static class MatchSS
    extends AbstractMatchFunction<IndexPhysicalPlanCallContext> {
        private MatchSS() {
        }

        @Override
        public boolean match(RelOptRuleCall call) {
            OrderedRel sort = (OrderedRel)call.rel(0);
            ScanPrel scan = (ScanPrel)call.rel(1);
            return sort instanceof Prel && this.checkScan(scan.getGroupScan()) && DbScanSortRemovalRule.isRemovableRel(sort);
        }

        @Override
        public IndexPhysicalPlanCallContext onMatch(RelOptRuleCall call) {
            ScanPrel scan = (ScanPrel)call.rel(1);
            OrderedRel sort = (OrderedRel)call.rel(0);
            return new IndexPhysicalPlanCallContext(call, sort, null, scan, null);
        }
    }

    private static class MatchSPS
    extends AbstractMatchFunction<IndexPhysicalPlanCallContext> {
        private MatchSPS() {
        }

        @Override
        public boolean match(RelOptRuleCall call) {
            OrderedRel sort = (OrderedRel)call.rel(0);
            ScanPrel scan = (ScanPrel)call.rel(2);
            return sort instanceof Prel && this.checkScan(scan.getGroupScan()) && DbScanSortRemovalRule.isRemovableRel(sort);
        }

        @Override
        public IndexPhysicalPlanCallContext onMatch(RelOptRuleCall call) {
            ScanPrel scan = (ScanPrel)call.rel(2);
            ProjectPrel proj = (ProjectPrel)call.rel(1);
            OrderedRel sort = (OrderedRel)call.rel(0);
            return new IndexPhysicalPlanCallContext(call, sort, proj, scan, null);
        }
    }

    private static class MatchSEPS
    extends AbstractMatchFunction<IndexPhysicalPlanCallContext> {
        private MatchSEPS() {
        }

        @Override
        public boolean match(RelOptRuleCall call) {
            OrderedRel sort = (OrderedRel)call.rel(0);
            ScanPrel scan = (ScanPrel)call.rel(3);
            return sort instanceof Prel && this.checkScan(scan.getGroupScan()) && DbScanSortRemovalRule.isRemovableRel(sort);
        }

        @Override
        public IndexPhysicalPlanCallContext onMatch(RelOptRuleCall call) {
            ScanPrel scan = (ScanPrel)call.rel(3);
            OrderedRel sort = (OrderedRel)call.rel(0);
            ProjectPrel proj = (ProjectPrel)call.rel(2);
            ExchangePrel exch = (ExchangePrel)call.rel(1);
            return new IndexPhysicalPlanCallContext(call, sort, proj, scan, exch);
        }
    }
}

