/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.drill.exec.physical.base.DbGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.IndexGroupScan;
import org.apache.drill.exec.planner.common.DrillRelNode;
import org.apache.drill.exec.planner.index.FunctionalIndexInfo;
import org.apache.drill.exec.planner.index.IndexCollection;
import org.apache.drill.exec.planner.index.IndexConditionInfo;
import org.apache.drill.exec.planner.index.IndexDescriptor;
import org.apache.drill.exec.planner.index.IndexGroup;
import org.apache.drill.exec.planner.index.IndexLogicalPlanCallContext;
import org.apache.drill.exec.planner.index.IndexPlanUtils;
import org.apache.drill.exec.planner.index.IndexProperties;
import org.apache.drill.exec.planner.index.IndexSelector;
import org.apache.drill.exec.planner.index.IndexableExprMarker;
import org.apache.drill.exec.planner.index.generators.CoveringIndexPlanGenerator;
import org.apache.drill.exec.planner.index.generators.IndexIntersectPlanGenerator;
import org.apache.drill.exec.planner.index.generators.NonCoveringIndexPlanGenerator;
import org.apache.drill.exec.planner.index.rules.AbstractMatchFunction;
import org.apache.drill.exec.planner.index.rules.MatchFunction;
import org.apache.drill.exec.planner.logical.DrillFilterRel;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.logical.DrillSortRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.logical.partition.RewriteAsBinaryOperators;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbScanToIndexScanPrule
extends Prule {
    static final Logger logger = LoggerFactory.getLogger(DbScanToIndexScanPrule.class);
    public final MatchFunction match;
    public static final RelOptRule REL_FILTER_SCAN = new DbScanToIndexScanPrule(RelOptHelper.some(DrillRelNode.class, RelOptHelper.some(DrillFilterRel.class, RelOptHelper.any(DrillScanRel.class), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "DbScanToIndexScanPrule:Rel_Filter_Scan", new MatchRelFS());
    public static final RelOptRule PROJECT_FILTER_PROJECT_SCAN = new DbScanToIndexScanPrule(RelOptHelper.some(DrillProjectRel.class, RelOptHelper.some(DrillFilterRel.class, RelOptHelper.some(DrillProjectRel.class, RelOptHelper.any(DrillScanRel.class), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "DbScanToIndexScanPrule:Project_Filter_Project_Scan", new MatchPFPS());
    public static final RelOptRule SORT_FILTER_PROJECT_SCAN = new DbScanToIndexScanPrule(RelOptHelper.some(DrillSortRel.class, RelOptHelper.some(DrillFilterRel.class, RelOptHelper.some(DrillProjectRel.class, RelOptHelper.any(DrillScanRel.class), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "DbScanToIndexScanPrule:Sort_Filter_Project_Scan", new MatchSFPS());
    public static final RelOptRule SORT_PROJECT_FILTER_PROJECT_SCAN = new DbScanToIndexScanPrule(RelOptHelper.some(DrillSortRel.class, RelOptHelper.some(DrillProjectRel.class, RelOptHelper.some(DrillFilterRel.class, RelOptHelper.some(DrillProjectRel.class, RelOptHelper.any(DrillScanRel.class), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "DbScanToIndexScanPrule:Sort_Project_Filter_Project_Scan", new MatchSPFPS());
    public static final RelOptRule SORT_PROJECT_FILTER_SCAN = new DbScanToIndexScanPrule(RelOptHelper.some(DrillSortRel.class, RelOptHelper.some(DrillProjectRel.class, RelOptHelper.some(DrillFilterRel.class, RelOptHelper.any(DrillScanRel.class), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "DbScanToIndexScanPrule:Sort_Project_Filter_Scan", new MatchSPFS());
    public static final RelOptRule FILTER_SCAN = new DbScanToIndexScanPrule(RelOptHelper.some(DrillFilterRel.class, RelOptHelper.any(DrillScanRel.class), new RelOptRuleOperand[0]), "DbScanToIndexScanPrule:Filter_On_Scan", new MatchFS());
    public static final RelOptRule FILTER_PROJECT_SCAN = new DbScanToIndexScanPrule(RelOptHelper.some(DrillFilterRel.class, RelOptHelper.some(DrillProjectRel.class, RelOptHelper.any(DrillScanRel.class), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "DbScanToIndexScanPrule:Filter_Project_Scan", new MatchFPS());

    private DbScanToIndexScanPrule(RelOptRuleOperand operand, String description, MatchFunction match) {
        super(operand, description);
        this.match = match;
    }

    public boolean matches(RelOptRuleCall call) {
        if (this.getMatchIfRoot(call) != null) {
            return true;
        }
        return this.match.match(call);
    }

    public void onMatch(RelOptRuleCall call) {
        if (this.getMatchIfRoot(call) != null) {
            this.getMatchIfRoot(call).onMatch(call);
            return;
        }
        this.doOnMatch((IndexLogicalPlanCallContext)this.match.onMatch(call));
    }

    private MatchFunction getMatchIfRoot(RelOptRuleCall call) {
        List rels = call.getRelList();
        if (call.getPlanner().getRoot().equals(call.rel(0))) {
            if (rels.size() == 2) {
                if (rels.get(0) instanceof DrillFilterRel && rels.get(1) instanceof DrillScanRel) {
                    return ((DbScanToIndexScanPrule)DbScanToIndexScanPrule.FILTER_SCAN).match;
                }
            } else if (rels.size() == 3 && rels.get(0) instanceof DrillFilterRel && rels.get(1) instanceof DrillProjectRel && rels.get(2) instanceof DrillScanRel) {
                return ((DbScanToIndexScanPrule)DbScanToIndexScanPrule.FILTER_PROJECT_SCAN).match;
            }
        }
        return null;
    }

    protected void doOnMatch(IndexLogicalPlanCallContext indexContext) {
        Stopwatch indexPlanTimer = Stopwatch.createStarted();
        PlannerSettings settings = PrelUtil.getPlannerSettings(indexContext.call.getPlanner());
        IndexCollection indexCollection = this.getIndexCollection(settings, indexContext.scan);
        if (indexCollection == null) {
            return;
        }
        logger.debug("Index Rule {} starts", (Object)this.description);
        RexBuilder builder = indexContext.filter.getCluster().getRexBuilder();
        RexNode condition = null;
        condition = indexContext.lowerProject == null ? indexContext.filter.getCondition() : RelOptUtil.pushFilterPastProject((RexNode)indexContext.filter.getCondition(), (Project)indexContext.lowerProject);
        indexContext.origPushedCondition = condition;
        RewriteAsBinaryOperators visitor = new RewriteAsBinaryOperators(true, builder);
        condition = (RexNode)condition.accept((RexVisitor)visitor);
        if (indexCollection.supportsIndexSelection()) {
            try {
                this.processWithIndexSelection(indexContext, settings, condition, indexCollection, builder);
            }
            catch (Exception e) {
                logger.warn("Exception while doing index planning ", (Throwable)e);
            }
        } else {
            throw new UnsupportedOperationException("Index collection must support index selection");
        }
        indexPlanTimer.stop();
        logger.info("index_plan_info: Index Planning took {} ms", (Object)indexPlanTimer.elapsed(TimeUnit.MILLISECONDS));
    }

    public IndexCollection getIndexCollection(PlannerSettings settings, DrillScanRel scan) {
        DbGroupScan groupScan = (DbGroupScan)scan.getGroupScan();
        return groupScan.getSecondaryIndexCollection(scan);
    }

    private void processWithIndexSelection(IndexLogicalPlanCallContext indexContext, PlannerSettings settings, RexNode condition, IndexCollection collection, RexBuilder builder) {
        IndexGroupScan idxScan;
        Iterator indexDesc;
        double totalRows;
        double filterRows = totalRows = 0.0;
        DrillScanRel scan = indexContext.scan;
        if (!(indexContext.scan.getGroupScan() instanceof DbGroupScan)) {
            return;
        }
        IndexConditionInfo.Builder infoBuilder = IndexConditionInfo.newBuilder(condition, collection, builder, indexContext.scan);
        IndexConditionInfo cInfo = infoBuilder.getCollectiveInfo(indexContext);
        boolean isValidIndexHint = infoBuilder.isValidIndexHint(indexContext);
        if (!cInfo.hasIndexCol) {
            logger.info("index_plan_info: No index columns are projected from the scan..continue.");
            return;
        }
        if (cInfo.indexCondition == null) {
            logger.info("index_plan_info: No conditions were found eligible for applying index lookup.");
            return;
        }
        if (!indexContext.indexHint.equals("") && !isValidIndexHint) {
            logger.warn("index_plan_info: Index Hint {} is not useful as index with that name is not available", (Object)indexContext.indexHint);
        }
        RexNode indexCondition = cInfo.indexCondition;
        RexNode remainderCondition = cInfo.remainderCondition;
        if (remainderCondition.isAlwaysTrue()) {
            remainderCondition = null;
        }
        logger.debug("index_plan_info: condition split into indexcondition: {} and remaindercondition: {}", (Object)indexCondition, (Object)remainderCondition);
        IndexableExprMarker indexableExprMarker = new IndexableExprMarker(indexContext.scan);
        indexCondition.accept((RexVisitor)indexableExprMarker);
        indexContext.origMarker = indexableExprMarker;
        if (scan.getGroupScan() instanceof DbGroupScan) {
            DbGroupScan dbScan = (DbGroupScan)scan.getGroupScan();
            if (settings.isStatisticsEnabled()) {
                dbScan.getStatistics().initialize(condition, scan, indexContext);
            }
            totalRows = dbScan.getRowCount(null, scan);
            filterRows = dbScan.getRowCount(condition, scan);
            double sel = filterRows / totalRows;
            if (totalRows != -1.0 && filterRows != -1.0 && !settings.isDisableFullTableScan() && !isValidIndexHint && sel > Math.max(settings.getIndexCoveringSelThreshold(), settings.getIndexNonCoveringSelThreshold())) {
                logger.info("index_plan_info: Skip index planning because filter selectivity: {} is greater than thresholds {}, {}", new Object[]{sel, settings.getIndexCoveringSelThreshold(), settings.getIndexNonCoveringSelThreshold()});
                return;
            }
        }
        if (totalRows == -1.0 || totalRows == 0.0 || filterRows == -1.0) {
            logger.warn("index_plan_info: Total row count is UNKNOWN or 0, or filterRows UNKNOWN; skip index planning");
            return;
        }
        ArrayList<IndexGroup> coveringIndexes = Lists.newArrayList();
        ArrayList<IndexGroup> nonCoveringIndexes = Lists.newArrayList();
        ArrayList<IndexGroup> intersectIndexes = Lists.newArrayList();
        IndexPlanUtils.updateSortExpression(indexContext, indexContext.sort != null ? indexContext.sort.collation.getFieldCollations() : null);
        IndexSelector selector = new IndexSelector(indexCondition, remainderCondition, indexContext, collection, builder, totalRows);
        for (Iterator indexDesc2 : collection) {
            logger.info("index_plan_info indexDescriptor: {}", (Object)indexDesc2.toString());
            if (IndexPlanUtils.conditionIndexed(indexableExprMarker, (IndexDescriptor)((Object)indexDesc2)) == IndexPlanUtils.ConditionIndexed.NONE) continue;
            if (isValidIndexHint && !indexContext.indexHint.equals(indexDesc2.getIndexName())) {
                logger.info("index_plan_info: Index {} is being discarded due to index Hint", (Object)indexDesc2.getIndexName());
                continue;
            }
            FunctionalIndexInfo functionalIndexInfo = indexDesc2.getFunctionalInfo();
            selector.addIndex((IndexDescriptor)((Object)indexDesc2), IndexPlanUtils.isCoveringIndex(indexContext, functionalIndexInfo), indexContext.lowerProject != null ? indexContext.lowerProject.getRowType().getFieldCount() : scan.getRowType().getFieldCount());
        }
        selector.getCandidateIndexes(infoBuilder, coveringIndexes, nonCoveringIndexes, intersectIndexes);
        if (logger.isDebugEnabled()) {
            StringBuilder strb = new StringBuilder();
            if (coveringIndexes.size() > 0) {
                strb.append("Covering indexes:");
                for (IndexGroup indexGroup : coveringIndexes) {
                    strb.append(indexGroup.getIndexProps().get(0).getIndexDesc().getIndexName()).append(", ");
                }
            }
            if (nonCoveringIndexes.size() > 0) {
                strb.append("Non-covering indexes:");
                for (IndexGroup indexGroup : nonCoveringIndexes) {
                    strb.append(indexGroup.getIndexProps().get(0).getIndexDesc().getIndexName()).append(", ");
                }
            }
            logger.debug("index_plan_info: IndexSelector return: {}", (Object)strb.toString());
        }
        GroupScan primaryTableScan = indexContext.scan.getGroupScan();
        if (coveringIndexes.size() == 0 && nonCoveringIndexes.size() > 1) {
            ArrayList indexList = Lists.newArrayList();
            for (IndexGroup index : nonCoveringIndexes) {
                indexDesc = index.getIndexProps().get(0).getIndexDesc();
                idxScan = indexDesc.getIndexGroupScan();
                idxScan.setStatistics(((DbGroupScan)primaryTableScan).getStatistics());
                indexList.add(index.getIndexProps().get(0).getIndexDesc());
            }
            Map<IndexDescriptor, IndexConditionInfo> map = infoBuilder.getIndexConditionMap(indexList);
            if (map == null || map.size() == 0) {
                logger.info("index_plan_info: skipping intersect plan generation as there is no usable index");
                return;
            }
            if (map.size() > 1) {
                logger.info("index_plan_info: intersect plan is generated");
                if (logger.isDebugEnabled()) {
                    ArrayList<String> indices = new ArrayList<String>(nonCoveringIndexes.size());
                    for (IndexGroup index : nonCoveringIndexes) {
                        indices.add(index.getIndexProps().get(0).getIndexDesc().getIndexName());
                    }
                    logger.debug("index_plan_info: intersect plan is generated on index list {}", indices);
                }
                boolean intersectPlanGenerated = false;
                for (IndexGroup index : intersectIndexes) {
                    ArrayList<IndexDescriptor> candidateDesc = Lists.newArrayList();
                    for (IndexProperties candProp : index.getIndexProps()) {
                        candidateDesc.add(candProp.getIndexDesc());
                    }
                    Map<IndexDescriptor, IndexConditionInfo> intersectIdxInfoMap = infoBuilder.getIndexConditionMap(candidateDesc);
                    IndexIntersectPlanGenerator planGen = new IndexIntersectPlanGenerator(indexContext, intersectIdxInfoMap, builder, settings);
                    try {
                        planGen.go();
                        intersectPlanGenerated = true;
                    }
                    catch (Exception e) {
                        logger.warn("index_plan_info: Exception while trying to generate intersect index plan", (Throwable)e);
                    }
                }
                if (intersectPlanGenerated && settings.isIndexIntersectPlanPreferred()) {
                    return;
                }
            }
        }
        try {
            for (IndexGroup indexGroup : coveringIndexes) {
                IndexProperties indexProps = indexGroup.getIndexProps().get(0);
                indexDesc = indexProps.getIndexDesc();
                idxScan = indexDesc.getIndexGroupScan();
                FunctionalIndexInfo indexInfo = indexDesc.getFunctionalInfo();
                indexCondition = indexProps.getLeadingColumnsFilter();
                remainderCondition = indexProps.getTotalRemainderFilter();
                idxScan.setStatistics(((DbGroupScan)scan.getGroupScan()).getStatistics());
                logger.info("index_plan_info: Generating covering index plan for index: {}, query condition {}", (Object)indexDesc.getIndexName(), (Object)indexCondition.toString());
                CoveringIndexPlanGenerator planGen = new CoveringIndexPlanGenerator(indexContext, indexInfo, idxScan, indexCondition, remainderCondition, builder, settings);
                planGen.go();
            }
        }
        catch (Exception e) {
            logger.warn("Exception while trying to generate covering index plan", (Throwable)e);
        }
        if (primaryTableScan instanceof DbGroupScan && ((DbGroupScan)primaryTableScan).supportsRestrictedScan()) {
            try {
                for (IndexGroup indexGroup : nonCoveringIndexes) {
                    IndexProperties indexProps = indexGroup.getIndexProps().get(0);
                    indexDesc = indexProps.getIndexDesc();
                    idxScan = indexDesc.getIndexGroupScan();
                    indexCondition = indexProps.getLeadingColumnsFilter();
                    remainderCondition = indexProps.getTotalRemainderFilter();
                    idxScan.setStatistics(((DbGroupScan)primaryTableScan).getStatistics());
                    logger.info("index_plan_info: Generating non-covering index plan for index: {}, query condition {}", (Object)indexDesc.getIndexName(), (Object)indexCondition.toString());
                    NonCoveringIndexPlanGenerator planGen = new NonCoveringIndexPlanGenerator(indexContext, (IndexDescriptor)((Object)indexDesc), idxScan, indexCondition, remainderCondition, builder, settings);
                    planGen.go();
                }
            }
            catch (Exception e) {
                logger.warn("Exception while trying to generate non-covering index access plan", (Throwable)e);
            }
        }
    }

    private static class MatchRelFS
    extends AbstractMatchFunction<IndexLogicalPlanCallContext> {
        private MatchRelFS() {
        }

        @Override
        public boolean match(RelOptRuleCall call) {
            if (call.rel(0) instanceof DrillProjectRel || call.rel(0) instanceof DrillSortRel) {
                DrillScanRel scan = (DrillScanRel)call.rel(2);
                return this.checkScan(scan);
            }
            return false;
        }

        @Override
        public IndexLogicalPlanCallContext onMatch(RelOptRuleCall call) {
            DrillProjectRel capProject = null;
            DrillSortRel sort = null;
            if (call.rel(0) instanceof DrillProjectRel) {
                capProject = (DrillProjectRel)call.rel(0);
            } else if (call.rel(0) instanceof DrillSortRel) {
                sort = (DrillSortRel)call.rel(0);
            }
            DrillFilterRel filter = (DrillFilterRel)call.rel(1);
            DrillScanRel scan = (DrillScanRel)call.rel(2);
            return new IndexLogicalPlanCallContext(call, sort, capProject, filter, null, scan);
        }
    }

    private static class MatchPFPS
    extends AbstractMatchFunction<IndexLogicalPlanCallContext> {
        private MatchPFPS() {
        }

        @Override
        public boolean match(RelOptRuleCall call) {
            DrillScanRel scan = (DrillScanRel)call.rel(3);
            return this.checkScan(scan);
        }

        @Override
        public IndexLogicalPlanCallContext onMatch(RelOptRuleCall call) {
            DrillProjectRel capProject = (DrillProjectRel)call.rel(0);
            DrillFilterRel filter = (DrillFilterRel)call.rel(1);
            DrillProjectRel project = (DrillProjectRel)call.rel(2);
            DrillScanRel scan = (DrillScanRel)call.rel(3);
            return new IndexLogicalPlanCallContext(call, null, capProject, filter, project, scan);
        }
    }

    private static class MatchSFPS
    extends AbstractMatchFunction<IndexLogicalPlanCallContext> {
        private MatchSFPS() {
        }

        @Override
        public boolean match(RelOptRuleCall call) {
            DrillScanRel scan = (DrillScanRel)call.rel(3);
            return this.checkScan(scan);
        }

        @Override
        public IndexLogicalPlanCallContext onMatch(RelOptRuleCall call) {
            DrillSortRel sort = (DrillSortRel)call.rel(0);
            DrillFilterRel filter = (DrillFilterRel)call.rel(1);
            DrillProjectRel project = (DrillProjectRel)call.rel(2);
            DrillScanRel scan = (DrillScanRel)call.rel(3);
            return new IndexLogicalPlanCallContext(call, sort, null, filter, project, scan);
        }
    }

    private static class MatchSPFPS
    extends AbstractMatchFunction<IndexLogicalPlanCallContext> {
        private MatchSPFPS() {
        }

        @Override
        public boolean match(RelOptRuleCall call) {
            DrillScanRel scan = (DrillScanRel)call.rel(4);
            return this.checkScan(scan);
        }

        @Override
        public IndexLogicalPlanCallContext onMatch(RelOptRuleCall call) {
            DrillSortRel sort = (DrillSortRel)call.rel(0);
            DrillProjectRel capProject = (DrillProjectRel)call.rel(1);
            DrillFilterRel filter = (DrillFilterRel)call.rel(2);
            DrillProjectRel project = (DrillProjectRel)call.rel(3);
            DrillScanRel scan = (DrillScanRel)call.rel(4);
            return new IndexLogicalPlanCallContext(call, sort, capProject, filter, project, scan);
        }
    }

    private static class MatchSPFS
    extends AbstractMatchFunction<IndexLogicalPlanCallContext> {
        private MatchSPFS() {
        }

        @Override
        public boolean match(RelOptRuleCall call) {
            DrillScanRel scan = (DrillScanRel)call.rel(3);
            return this.checkScan(scan);
        }

        @Override
        public IndexLogicalPlanCallContext onMatch(RelOptRuleCall call) {
            DrillSortRel sort = (DrillSortRel)call.rel(0);
            DrillProjectRel capProject = (DrillProjectRel)call.rel(1);
            DrillFilterRel filter = (DrillFilterRel)call.rel(2);
            DrillScanRel scan = (DrillScanRel)call.rel(3);
            return new IndexLogicalPlanCallContext(call, sort, capProject, filter, null, scan);
        }
    }

    private static class MatchFS
    extends AbstractMatchFunction<IndexLogicalPlanCallContext> {
        private MatchFS() {
        }

        @Override
        public boolean match(RelOptRuleCall call) {
            DrillScanRel scan = (DrillScanRel)call.rel(1);
            return this.checkScan(scan);
        }

        @Override
        public IndexLogicalPlanCallContext onMatch(RelOptRuleCall call) {
            DrillFilterRel filter = (DrillFilterRel)call.rel(0);
            DrillScanRel scan = (DrillScanRel)call.rel(1);
            return new IndexLogicalPlanCallContext(call, null, filter, null, scan);
        }
    }

    private static class MatchFPS
    extends AbstractMatchFunction<IndexLogicalPlanCallContext> {
        private MatchFPS() {
        }

        @Override
        public boolean match(RelOptRuleCall call) {
            DrillScanRel scan = (DrillScanRel)call.rel(2);
            return this.checkScan(scan);
        }

        @Override
        public IndexLogicalPlanCallContext onMatch(RelOptRuleCall call) {
            DrillFilterRel filter = (DrillFilterRel)call.rel(0);
            DrillProjectRel project = (DrillProjectRel)call.rel(1);
            DrillScanRel scan = (DrillScanRel)call.rel(2);
            return new IndexLogicalPlanCallContext(call, null, filter, project, scan);
        }
    }
}

