/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.planner.common.CountToDirectScanUtils;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.planner.logical.DrillDirectScanRel;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillRelFactories;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.store.ColumnExplorer;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.FileSystemPlugin;
import org.apache.drill.exec.store.dfs.FormatSelection;
import org.apache.drill.exec.store.dfs.NamedFormatPluginConfig;
import org.apache.drill.exec.store.direct.MetadataDirectGroupScan;
import org.apache.drill.exec.store.parquet.ParquetFormatConfig;
import org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import org.apache.drill.exec.store.parquet.metadata.Metadata;
import org.apache.drill.exec.store.parquet.metadata.Metadata_V4;
import org.apache.drill.exec.store.pojo.DynamicPojoRecordReader;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertCountToDirectScanRule
extends RelOptRule {
    public static final RelOptRule AGG_ON_PROJ_ON_SCAN = new ConvertCountToDirectScanRule(RelOptHelper.some(Aggregate.class, RelOptHelper.some(Project.class, RelOptHelper.any(TableScan.class), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "Agg_on_proj_on_scan");
    public static final RelOptRule AGG_ON_SCAN = new ConvertCountToDirectScanRule(RelOptHelper.some(Aggregate.class, RelOptHelper.any(TableScan.class), new RelOptRuleOperand[0]), "Agg_on_scan");
    private static final Logger logger = LoggerFactory.getLogger(ConvertCountToDirectScanRule.class);

    private ConvertCountToDirectScanRule(RelOptRuleOperand rule, String id) {
        super(rule, DrillRelFactories.LOGICAL_BUILDER, "ConvertCountToDirectScanRule:" + id);
    }

    public void onMatch(RelOptRuleCall call) {
        Project project;
        Aggregate agg = (Aggregate)call.rel(0);
        TableScan scan = (TableScan)call.rel(call.rels.length - 1);
        Project project2 = project = call.rels.length == 3 ? (Project)call.rel(1) : null;
        if (agg.getGroupCount() > 0 || agg.containsDistinctCall()) {
            return;
        }
        DrillTable drillTable = DrillRelOptUtil.getDrillTable((RelNode)scan);
        if (drillTable == null) {
            logger.debug("Rule does not apply since an eligible drill table instance was not found.");
            return;
        }
        Object selection = drillTable.getSelection();
        if (!(selection instanceof FormatSelection)) {
            logger.debug("Rule does not apply since only Parquet file format is eligible.");
            return;
        }
        PlannerSettings settings = (PlannerSettings)call.getPlanner().getContext().unwrap(PlannerSettings.class);
        FormatSelection formatSelection = (FormatSelection)selection;
        if (formatSelection.getSelection().hadWildcard()) {
            logger.debug("Rule does not apply when there is a wild card since the COUNT could not be determined from metadata.");
            return;
        }
        Pair<Boolean, Metadata_V4.MetadataSummary> status = this.checkMetadataForScanStats(settings, drillTable, formatSelection);
        if (!((Boolean)status.getLeft()).booleanValue()) {
            logger.debug("Rule does not apply since MetadataSummary metadata was not found.");
            return;
        }
        Metadata_V4.MetadataSummary metadataSummary = (Metadata_V4.MetadataSummary)status.getRight();
        Map<String, Long> result = this.collectCounts(settings, metadataSummary, agg, scan, project);
        logger.trace("Calculated the following aggregate counts: {}", result);
        if (result.isEmpty()) {
            logger.debug("Rule does not apply since one or more COUNTs could not be determined from metadata.");
            return;
        }
        Path summaryFileName = Metadata.getSummaryFileName(formatSelection.getSelection().getSelectionRoot());
        RelDataType scanRowType = CountToDirectScanUtils.constructDataType(agg, result.keySet());
        DynamicPojoRecordReader reader = new DynamicPojoRecordReader(CountToDirectScanUtils.buildSchema(scanRowType.getFieldNames()), Collections.singletonList(new ArrayList<Long>(result.values())));
        ScanStats scanStats = new ScanStats(ScanStats.GroupScanProperty.EXACT_ROW_COUNT, 1.0, 1.0, scanRowType.getFieldCount());
        MetadataDirectGroupScan directScan = new MetadataDirectGroupScan(reader, summaryFileName, 1, scanStats, true, false);
        DrillDirectScanRel newScan = new DrillDirectScanRel(scan.getCluster(), scan.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL), directScan, scanRowType);
        DrillProjectRel newProject = new DrillProjectRel(agg.getCluster(), agg.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL), newScan, CountToDirectScanUtils.prepareFieldExpressions(scanRowType), agg.getRowType());
        call.transformTo((RelNode)newProject);
    }

    private Pair<Boolean, Metadata_V4.MetadataSummary> checkMetadataForScanStats(PlannerSettings settings, DrillTable drillTable, FormatSelection formatSelection) {
        DrillFileSystem fs;
        FormatPluginConfig formatConfig = formatSelection.getFormat();
        if (!(formatConfig instanceof ParquetFormatConfig || formatConfig instanceof NamedFormatPluginConfig && ((NamedFormatPluginConfig)formatConfig).getName().equals("parquet"))) {
            return new ImmutablePair((Object)false, null);
        }
        FileSystemPlugin plugin = (FileSystemPlugin)drillTable.getPlugin();
        try {
            fs = new DrillFileSystem(plugin.getFormatPlugin(formatSelection.getFormat()).getFsConf());
        }
        catch (IOException e) {
            logger.warn("Unable to create the file system object for retrieving statistics from metadata cache file ", (Throwable)e);
            return new ImmutablePair((Object)false, null);
        }
        Path selectionRoot = formatSelection.getSelection().getCacheFileRoot() != null ? formatSelection.getSelection().getCacheFileRoot() : formatSelection.getSelection().getSelectionRoot();
        ParquetReaderConfig parquetReaderConfig = ParquetReaderConfig.builder().withFormatConfig((ParquetFormatConfig)formatConfig).withOptions(settings.getOptions()).build();
        Metadata_V4.MetadataSummary metadataSummary = Metadata.getSummary(fs, selectionRoot, false, parquetReaderConfig);
        return metadataSummary != null ? new ImmutablePair((Object)true, (Object)metadataSummary) : new ImmutablePair((Object)false, null);
    }

    private Map<String, Long> collectCounts(PlannerSettings settings, Metadata_V4.MetadataSummary metadataSummary, Aggregate agg, TableScan scan, Project project) {
        Set<String> implicitColumnsNames = ColumnExplorer.initImplicitFileColumns(settings.getOptions()).keySet();
        long totalRecordCount = metadataSummary.getTotalRowCount();
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        for (int i = 0; i < agg.getAggCallList().size(); ++i) {
            long cnt;
            AggregateCall aggCall = (AggregateCall)agg.getAggCallList().get(i);
            if (!"count".equalsIgnoreCase(aggCall.getAggregation().getName())) {
                return ImmutableMap.of();
            }
            if (CountToDirectScanUtils.containsStarOrNotNullInput(aggCall, agg)) {
                cnt = totalRecordCount;
            } else if (aggCall.getArgList().size() == 1) {
                String columnName;
                int index = (Integer)aggCall.getArgList().get(0);
                if (project != null) {
                    if (!(project.getProjects().get(index) instanceof RexInputRef)) {
                        return ImmutableMap.of();
                    }
                    index = ((RexInputRef)project.getProjects().get(index)).getIndex();
                }
                if (implicitColumnsNames.contains(columnName = ((String)scan.getRowType().getFieldNames().get(index)).toLowerCase())) {
                    cnt = totalRecordCount;
                } else {
                    SchemaPath simplePath = SchemaPath.getSimplePath(columnName);
                    if (ColumnExplorer.isPartitionColumn(settings.getOptions(), simplePath)) {
                        return ImmutableMap.of();
                    }
                    Metadata_V4.ColumnTypeMetadata_v4 columnMetadata = metadataSummary.getColumnTypeInfo(new Metadata_V4.ColumnTypeMetadata_v4.Key(simplePath));
                    if (columnMetadata == null) {
                        cnt = 0L;
                    } else {
                        if (columnMetadata.totalNullCount == -1L) {
                            return ImmutableMap.of();
                        }
                        cnt = totalRecordCount - columnMetadata.totalNullCount;
                    }
                }
            } else {
                return ImmutableMap.of();
            }
            String name = "count" + i + "$" + (aggCall.getName() == null ? aggCall.toString() : aggCall.getName());
            result.put(name, cnt);
        }
        return ImmutableMap.copyOf(result);
    }
}

