/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.BitSets;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionCallFactory;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.logical.data.GroupingAggregate;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.exec.planner.common.DrillAggregateRelBase;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.torel.ConversionContext;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class DrillAggregateRel
extends DrillAggregateRelBase
implements DrillRel {
    public DrillAggregateRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        super(cluster, traits, child, groupSet, groupSets, aggCalls);
    }

    public Aggregate copy(RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        return new DrillAggregateRel(this.getCluster(), traitSet, input, groupSet, groupSets, aggCalls);
    }

    @Override
    public LogicalOperator implement(DrillImplementor implementor) {
        GroupingAggregate.Builder builder = GroupingAggregate.builder();
        builder.setInput(implementor.visitChild(this, 0, this.getInput()));
        List childFields = this.getInput().getRowType().getFieldNames();
        List fields = this.getRowType().getFieldNames();
        Iterator<Object> iterator = BitSets.toIter((ImmutableBitSet)this.groupSet).iterator();
        while (iterator.hasNext()) {
            int group = (Integer)iterator.next();
            FieldReference fr = new FieldReference((CharSequence)childFields.get(group), ExpressionPosition.UNKNOWN);
            builder.addKey(fr, fr);
        }
        for (Ord aggCall : Ord.zip((List)this.aggCalls)) {
            FieldReference ref = new FieldReference((CharSequence)fields.get(this.groupSet.cardinality() + aggCall.i));
            LogicalExpression expr = DrillAggregateRel.toDrill((AggregateCall)aggCall.e, childFields, implementor);
            builder.addExpr(ref, expr);
        }
        return builder.build();
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        for (AggregateCall aggCall : this.getAggCallList()) {
            String name = aggCall.getAggregation().getName();
            if (!name.equals(SqlKind.AVG.name()) && !name.equals(SqlKind.STDDEV_POP.name()) && !name.equals(SqlKind.STDDEV_SAMP.name()) && !name.equals(SqlKind.VAR_POP.name()) && !name.equals(SqlKind.VAR_SAMP.name()) || aggCall.getType().getSqlTypeName() == SqlTypeName.DECIMAL) continue;
            return planner.getCostFactory().makeHugeCost();
        }
        return this.computeLogicalAggCost(planner, mq);
    }

    public static LogicalExpression toDrill(AggregateCall call, List<String> fn, DrillImplementor implementor) {
        ArrayList<LogicalExpression> args = Lists.newArrayList();
        for (Integer i : call.getArgList()) {
            args.add(new FieldReference(fn.get(i)));
        }
        if (args.isEmpty()) {
            args.add(new ValueExpressions.LongExpression(1L));
        }
        return FunctionCallFactory.createExpression(call.getAggregation().getName().toLowerCase(), ExpressionPosition.UNKNOWN, args);
    }

    public static DrillAggregateRel convert(GroupingAggregate groupBy, ConversionContext value) {
        throw new UnsupportedOperationException();
    }
}

