/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.drill.common.logical.data.Analyze;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.torel.ConversionContext;

public class DrillAnalyzeRel
extends SingleRel
implements DrillRel {
    double samplePercent;

    public DrillAnalyzeRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, double samplePercent) {
        super(cluster, traits, child);
        this.samplePercent = samplePercent;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double dRows = mq.getRowCount(this.getInput());
        double dCpu = dRows * 4.0;
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, 0.0);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DrillAnalyzeRel(this.getCluster(), traitSet, (RelNode)DrillAnalyzeRel.sole(inputs), this.samplePercent);
    }

    @Override
    public LogicalOperator implement(DrillImplementor implementor) {
        LogicalOperator inputOp = implementor.visitChild(this, 0, this.getInput());
        Analyze rel = new Analyze();
        rel.setInput(inputOp);
        return rel;
    }

    public double getSamplePercent() {
        return this.samplePercent;
    }

    public static DrillAnalyzeRel convert(Analyze analyze, ConversionContext context) throws InvalidRelException {
        RelNode input = context.toRel(analyze.getInput());
        return new DrillAnalyzeRel(context.getCluster(), context.getLogicalTraits(), input, analyze.getSamplePercent());
    }
}

