/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.drill.exec.planner.logical.DrillLateralJoinRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillRelFactories;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.slf4j.Logger;

public class DrillCorrelateRule
extends RelOptRule {
    public static final RelOptRule INSTANCE = new DrillCorrelateRule();
    protected static final Logger tracer = CalciteTrace.getPlannerTracer();

    private DrillCorrelateRule() {
        super(RelOptHelper.any(LogicalCorrelate.class, (RelTrait)Convention.NONE), DrillRelFactories.LOGICAL_BUILDER, "DrillLateralJoinRule");
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalCorrelate correlate = (LogicalCorrelate)call.rel(0);
        RelNode left = correlate.getLeft();
        RelNode right = correlate.getRight();
        RelNode convertedLeft = DrillCorrelateRule.convert((RelNode)left, (RelTraitSet)left.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL).simplify());
        RelNode convertedRight = DrillCorrelateRule.convert((RelNode)right, (RelTraitSet)right.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL).simplify());
        RelTraitSet traits = correlate.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL);
        DrillLateralJoinRel lateralJoinRel = new DrillLateralJoinRel(correlate.getCluster(), traits, convertedLeft, convertedRight, false, correlate.getCorrelationId(), correlate.getRequiredColumns(), correlate.getJoinType());
        call.transformTo((RelNode)lateralJoinRel);
    }
}

