/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.store.direct.DirectGroupScan;

public class DrillDirectScanRel
extends AbstractRelNode
implements DrillRel {
    private final DirectGroupScan groupScan;
    private final RelDataType rowType;

    public DrillDirectScanRel(RelOptCluster cluster, RelTraitSet traitSet, DirectGroupScan directGroupScan, RelDataType rowType) {
        super(cluster, traitSet);
        this.groupScan = directGroupScan;
        this.rowType = rowType;
    }

    @Override
    public LogicalOperator implement(DrillImplementor implementor) {
        return null;
    }

    public RelDataType deriveRowType() {
        return this.rowType;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("directscan", (Object)this.groupScan.getDigest());
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        PlannerSettings settings = PrelUtil.getPlannerSettings(this.getCluster());
        return this.groupScan.getScanStats(settings).getRecordCount();
    }

    public DirectGroupScan getGroupScan() {
        return this.groupScan;
    }
}

