/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.math.BigDecimal;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.common.logical.data.Limit;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.exec.planner.common.DrillLimitRelBase;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.torel.ConversionContext;

public class DrillLimitRel
extends DrillLimitRelBase
implements DrillRel {
    public DrillLimitRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, child, offset, fetch);
    }

    public DrillLimitRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode offset, RexNode fetch, boolean pushDown) {
        super(cluster, traitSet, child, offset, fetch, pushDown);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DrillLimitRel(this.getCluster(), traitSet, (RelNode)DrillLimitRel.sole(inputs), this.offset, this.fetch, this.isPushDown());
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs, boolean pushDown) {
        return new DrillLimitRel(this.getCluster(), traitSet, (RelNode)DrillLimitRel.sole(inputs), this.offset, this.fetch, pushDown);
    }

    @Override
    public LogicalOperator implement(DrillImplementor implementor) {
        LogicalOperator inputOp = implementor.visitChild(this, 0, this.getInput());
        int first = this.offset != null ? Math.max(0, RexLiteral.intValue((RexNode)this.offset)) : 0;
        Integer last = this.fetch != null ? Integer.valueOf(Math.max(0, RexLiteral.intValue((RexNode)this.fetch)) + first) : null;
        Limit limit = new Limit(first, last);
        limit.setInput(inputOp);
        return limit;
    }

    public static DrillLimitRel convert(Limit limit, ConversionContext context) throws InvalidRelException {
        RelNode input = context.toRel(limit.getInput());
        RexLiteral first = context.getRexBuilder().makeExactLiteral(BigDecimal.valueOf(limit.getFirst().intValue()), context.getTypeFactory().createSqlType(SqlTypeName.INTEGER));
        RexLiteral last = context.getRexBuilder().makeExactLiteral(BigDecimal.valueOf(limit.getLast().intValue()), context.getTypeFactory().createSqlType(SqlTypeName.INTEGER));
        return new DrillLimitRel(context.getCluster(), context.getLogicalTraits(), input, (RexNode)first, (RexNode)last);
    }
}

