/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.ReduceExpressionsRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.Util;
import org.apache.drill.exec.planner.logical.DrillRelFactories;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public abstract class DrillReduceExpressionsRule
extends ReduceExpressionsRule<ReduceExpressionsRule.Config> {
    public static final DrillReduceFilterRule FILTER_INSTANCE_DRILL = new DrillReduceFilterRule();
    public static final DrillReduceCalcRule CALC_INSTANCE_DRILL = new DrillReduceCalcRule();
    public static final DrillReduceProjectRule PROJECT_INSTANCE_DRILL = new DrillReduceProjectRule();

    protected DrillReduceExpressionsRule(ReduceExpressionsRule.Config config) {
        super(config);
    }

    protected static boolean reduceExpressionsNoSimplify(RelNode rel, List<RexNode> expList, RelOptPredicateList predicates, boolean unknownAsFalse, boolean treatDynamicCallsAsConstant) {
        RelOptCluster cluster = rel.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RexExecutor executor = (RexExecutor)Util.first((Object)cluster.getPlanner().getExecutor(), (Object)RexUtil.EXECUTOR);
        RexSimplify simplify = new RexSimplify(rexBuilder, predicates, executor);
        RexUnknownAs unknownAs = RexUnknownAs.falseIf((boolean)unknownAsFalse);
        return ReduceExpressionsRule.reduceExpressionsInternal((RelNode)rel, (RexSimplify)simplify, (RexUnknownAs)unknownAs, expList, (RelOptPredicateList)predicates, (boolean)treatDynamicCallsAsConstant);
    }

    private static RelNode createEmptyEmptyRelHelper(SingleRel input) {
        return LogicalSort.create((RelNode)input.getInput(), (RelCollation)RelCollations.EMPTY, (RexNode)input.getCluster().getRexBuilder().makeExactLiteral(BigDecimal.valueOf(0L)), (RexNode)input.getCluster().getRexBuilder().makeExactLiteral(BigDecimal.valueOf(0L)));
    }

    private static class DrillReduceFilterRule
    extends ReduceExpressionsRule.FilterReduceExpressionsRule {
        DrillReduceFilterRule() {
            super((ReduceExpressionsRule.FilterReduceExpressionsRule.FilterReduceExpressionsRuleConfig)ReduceExpressionsRule.FilterReduceExpressionsRule.FilterReduceExpressionsRuleConfig.DEFAULT.withOperandFor(Filter.class).withMatchNullability(false).withRelBuilderFactory(DrillRelFactories.LOGICAL_BUILDER).as(ReduceExpressionsRule.FilterReduceExpressionsRule.FilterReduceExpressionsRuleConfig.class));
        }

        protected RelNode createEmptyRelOrEquivalent(RelOptRuleCall call, Filter filter) {
            return DrillReduceExpressionsRule.createEmptyEmptyRelHelper((SingleRel)filter);
        }

        public void onMatch(RelOptRuleCall call) {
            boolean reduced;
            RexNode newConditionExp;
            RelMetadataQuery mq;
            RelOptPredicateList predicates;
            ArrayList<RexNode> expList;
            Filter filter = (Filter)call.rel(0);
            if (DrillReduceExpressionsRule.reduceExpressionsNoSimplify((RelNode)filter, expList = Lists.newArrayList(filter.getCondition()), predicates = (mq = call.getMetadataQuery()).getPulledUpPredicates(filter.getInput()), true, ((ReduceExpressionsRule.FilterReduceExpressionsRule.FilterReduceExpressionsRuleConfig)this.config).treatDynamicCallsAsConstant())) {
                assert (expList.size() == 1);
                newConditionExp = (RexNode)expList.get(0);
                reduced = true;
            } else {
                newConditionExp = filter.getCondition();
                reduced = false;
            }
            if (newConditionExp.isAlwaysTrue()) {
                call.transformTo(filter.getInput());
            } else if (newConditionExp instanceof RexLiteral || RexUtil.isNullLiteral((RexNode)newConditionExp, (boolean)true)) {
                call.transformTo(this.createEmptyRelOrEquivalent(call, filter));
            } else if (reduced) {
                call.transformTo(call.builder().push(filter.getInput()).filter(new RexNode[]{newConditionExp}).build());
            } else {
                if (newConditionExp instanceof RexCall) {
                    boolean reverse;
                    boolean bl = reverse = newConditionExp.getKind() == SqlKind.NOT;
                    if (reverse) {
                        newConditionExp = (RexNode)((RexCall)newConditionExp).getOperands().get(0);
                    }
                    this.reduceNotNullableFilter(call, filter, newConditionExp, reverse);
                }
                return;
            }
            call.getPlanner().prune((RelNode)filter);
        }

        private void reduceNotNullableFilter(RelOptRuleCall call, Filter filter, RexNode rexNode, boolean reverse) {
            RexInputRef inputRef;
            RexNode operand;
            boolean alwaysTrue;
            switch (rexNode.getKind()) {
                case IS_NULL: 
                case IS_UNKNOWN: {
                    alwaysTrue = false;
                    break;
                }
                case IS_NOT_NULL: {
                    alwaysTrue = true;
                    break;
                }
                default: {
                    return;
                }
            }
            if (reverse) {
                boolean bl = alwaysTrue = !alwaysTrue;
            }
            if ((operand = (RexNode)((RexCall)rexNode).getOperands().get(0)) instanceof RexInputRef && !(inputRef = (RexInputRef)operand).getType().isNullable()) {
                if (alwaysTrue) {
                    call.transformTo(filter.getInput());
                } else {
                    call.transformTo(this.createEmptyRelOrEquivalent(call, filter));
                }
                call.getPlanner().prune((RelNode)filter);
            }
        }
    }

    private static class DrillReduceCalcRule
    extends ReduceExpressionsRule.CalcReduceExpressionsRule {
        DrillReduceCalcRule() {
            super((ReduceExpressionsRule.CalcReduceExpressionsRule.CalcReduceExpressionsRuleConfig)ReduceExpressionsRule.CalcReduceExpressionsRule.CalcReduceExpressionsRuleConfig.DEFAULT.withOperandFor(Calc.class).withMatchNullability(true).withRelBuilderFactory(DrillRelFactories.LOGICAL_BUILDER).as(ReduceExpressionsRule.CalcReduceExpressionsRule.CalcReduceExpressionsRuleConfig.class));
        }

        protected RelNode createEmptyRelOrEquivalent(RelOptRuleCall call, Calc input) {
            return DrillReduceExpressionsRule.createEmptyEmptyRelHelper((SingleRel)input);
        }

        public void onMatch(RelOptRuleCall call) {
            Calc calc = (Calc)call.rel(0);
            RexProgram program = calc.getProgram();
            List exprList = program.getExprList();
            final ArrayList<RexNode> expandedExprList = new ArrayList<RexNode>();
            RexShuttle shuttle = new RexShuttle(){

                public RexNode visitLocalRef(RexLocalRef localRef) {
                    return (RexNode)expandedExprList.get(localRef.getIndex());
                }
            };
            for (RexNode expr : exprList) {
                expandedExprList.add((RexNode)expr.accept((RexVisitor)shuttle));
            }
            RelOptPredicateList predicates = RelOptPredicateList.EMPTY;
            if (DrillReduceExpressionsRule.reduceExpressionsNoSimplify((RelNode)calc, expandedExprList, predicates, false, ((ReduceExpressionsRule.CalcReduceExpressionsRule.CalcReduceExpressionsRuleConfig)this.config).treatDynamicCallsAsConstant())) {
                int conditionIndex;
                RexNode newConditionExp;
                RexProgramBuilder builder = new RexProgramBuilder(calc.getInput().getRowType(), calc.getCluster().getRexBuilder());
                ArrayList<RexLocalRef> list = new ArrayList<RexLocalRef>();
                for (RexNode expr : expandedExprList) {
                    list.add(builder.registerInput(expr));
                }
                if (program.getCondition() != null && !(newConditionExp = (RexNode)expandedExprList.get(conditionIndex = program.getCondition().getIndex())).isAlwaysTrue()) {
                    if (newConditionExp instanceof RexLiteral || RexUtil.isNullLiteral((RexNode)newConditionExp, (boolean)true)) {
                        call.transformTo(this.createEmptyRelOrEquivalent(call, calc));
                        return;
                    }
                    builder.addCondition((RexNode)list.get(conditionIndex));
                }
                int k = 0;
                for (RexLocalRef projectExpr : program.getProjectList()) {
                    int index = projectExpr.getIndex();
                    builder.addProject(((RexLocalRef)list.get(index)).getIndex(), (String)program.getOutputRowType().getFieldNames().get(k++));
                }
                call.transformTo((RelNode)calc.copy(calc.getTraitSet(), calc.getInput(), builder.getProgram()));
                call.getPlanner().prune((RelNode)calc);
            }
        }
    }

    private static class DrillReduceProjectRule
    extends ReduceExpressionsRule.ProjectReduceExpressionsRule {
        DrillReduceProjectRule() {
            super((ReduceExpressionsRule.ProjectReduceExpressionsRule.ProjectReduceExpressionsRuleConfig)ReduceExpressionsRule.ProjectReduceExpressionsRule.ProjectReduceExpressionsRuleConfig.DEFAULT.withOperandFor(Project.class).withMatchNullability(true).withRelBuilderFactory(DrillRelFactories.LOGICAL_BUILDER).as(ReduceExpressionsRule.ProjectReduceExpressionsRule.ProjectReduceExpressionsRuleConfig.class));
        }

        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            RelMetadataQuery mq = call.getMetadataQuery();
            RelOptPredicateList predicates = mq.getPulledUpPredicates(project.getInput());
            ArrayList<RexNode> expList = Lists.newArrayList(project.getProjects());
            if (DrillReduceExpressionsRule.reduceExpressionsNoSimplify((RelNode)project, expList, predicates, false, ((ReduceExpressionsRule.ProjectReduceExpressionsRule.ProjectReduceExpressionsRuleConfig)this.config).treatDynamicCallsAsConstant())) {
                assert (!project.getProjects().equals(expList)) : "Reduced expressions should be different from original expressions";
                call.transformTo(call.builder().push(project.getInput()).project(expList, (Iterable)project.getRowType().getFieldNames()).build());
                call.getPlanner().prune((RelNode)project);
            }
        }
    }
}

