/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.drill.exec.planner.DrillRelBuilder;
import org.apache.drill.exec.planner.logical.DrillAggregateRel;
import org.apache.drill.exec.planner.logical.DrillExceptRel;
import org.apache.drill.exec.planner.logical.DrillFilterRel;
import org.apache.drill.exec.planner.logical.DrillIntersectRel;
import org.apache.drill.exec.planner.logical.DrillJoinRel;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillSemiJoinRel;

public class DrillRelFactories {
    public static final RelFactories.SetOpFactory DRILL_LOGICAL_SET_OP_FACTORY = new DrillSetOpFactoryImpl();
    public static final RelFactories.ProjectFactory DRILL_LOGICAL_PROJECT_FACTORY = new DrillProjectFactoryImpl();
    public static final RelFactories.FilterFactory DRILL_LOGICAL_FILTER_FACTORY = new DrillFilterFactoryImpl();
    public static final RelFactories.JoinFactory DRILL_LOGICAL_JOIN_FACTORY = new DrillJoinFactoryImpl();
    public static final RelFactories.AggregateFactory DRILL_LOGICAL_AGGREGATE_FACTORY = new DrillAggregateFactoryImpl();
    public static final RelFactories.SemiJoinFactory DRILL_SEMI_JOIN_FACTORY = new SemiJoinFactoryImpl();
    public static final RelBuilderFactory LOGICAL_BUILDER = DrillRelBuilder.proto(Contexts.of((Object[])new Object[]{RelFactories.DEFAULT_PROJECT_FACTORY, RelFactories.DEFAULT_FILTER_FACTORY, RelFactories.DEFAULT_JOIN_FACTORY, DRILL_SEMI_JOIN_FACTORY, RelFactories.DEFAULT_SORT_FACTORY, RelFactories.DEFAULT_AGGREGATE_FACTORY, RelFactories.DEFAULT_MATCH_FACTORY, RelFactories.DEFAULT_SET_OP_FACTORY, RelFactories.DEFAULT_VALUES_FACTORY, RelFactories.DEFAULT_TABLE_SCAN_FACTORY}));

    private static class DrillSetOpFactoryImpl
    implements RelFactories.SetOpFactory {
        private DrillSetOpFactoryImpl() {
        }

        public RelNode createSetOp(SqlKind kind, List<RelNode> inputs, boolean all) {
            switch (kind) {
                case EXCEPT: {
                    return DrillExceptRel.create(inputs, all);
                }
                case INTERSECT: {
                    return DrillIntersectRel.create(inputs, all);
                }
            }
            throw new AssertionError((Object)("unsupported set op: " + kind));
        }
    }

    private static class DrillProjectFactoryImpl
    implements RelFactories.ProjectFactory {
        private DrillProjectFactoryImpl() {
        }

        public RelNode createProject(RelNode input, List<RelHint> hints, List<? extends RexNode> childExprs, List<? extends String> fieldNames, Set<CorrelationId> variablesSet) {
            RelOptCluster cluster = input.getCluster();
            RelDataType rowType = RexUtil.createStructType((RelDataTypeFactory)cluster.getTypeFactory(), childExprs, fieldNames, null);
            return DrillProjectRel.create(cluster, input.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL), input, childExprs, rowType);
        }
    }

    private static class DrillFilterFactoryImpl
    implements RelFactories.FilterFactory {
        private DrillFilterFactoryImpl() {
        }

        public RelNode createFilter(RelNode child, RexNode condition, Set<CorrelationId> variablesSet) {
            return DrillFilterRel.create(child, condition);
        }
    }

    private static class DrillJoinFactoryImpl
    implements RelFactories.JoinFactory {
        private DrillJoinFactoryImpl() {
        }

        public RelNode createJoin(RelNode left, RelNode right, List<RelHint> hints, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType, boolean semiJoinDone) {
            switch (joinType) {
                case SEMI: {
                    JoinInfo joinInfo = JoinInfo.of((RelNode)left, (RelNode)right, (RexNode)condition);
                    return DrillSemiJoinRel.create(left, right, condition, (List<Integer>)joinInfo.leftKeys, (List<Integer>)joinInfo.rightKeys);
                }
            }
            return new DrillJoinRel(left.getCluster(), left.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL), left, right, condition, joinType);
        }
    }

    private static class DrillAggregateFactoryImpl
    implements RelFactories.AggregateFactory {
        private DrillAggregateFactoryImpl() {
        }

        public RelNode createAggregate(RelNode input, List<RelHint> hints, ImmutableBitSet groupSet, ImmutableList<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
            return new DrillAggregateRel(input.getCluster(), input.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL), input, groupSet, groupSets, aggCalls);
        }
    }

    private static class SemiJoinFactoryImpl
    implements RelFactories.SemiJoinFactory {
        private SemiJoinFactoryImpl() {
        }

        public RelNode createSemiJoin(RelNode left, RelNode right, RexNode condition) {
            JoinInfo joinInfo = JoinInfo.of((RelNode)left, (RelNode)right, (RexNode)condition);
            return DrillSemiJoinRel.create(left, right, condition, (List<Integer>)joinInfo.leftKeys, (List<Integer>)joinInfo.rightKeys);
        }
    }
}

