/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.Scan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.planner.common.DrillScanRelBase;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.torel.ConversionContext;
import org.apache.drill.exec.util.Utilities;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class DrillScanRel
extends DrillScanRelBase
implements DrillRel {
    public static final int STAR_COLUMN_COST = 10000;
    private PlannerSettings settings;
    private final List<SchemaPath> columns;
    private final boolean partitionFilterPushdown;
    private final RelDataType rowType;

    public DrillScanRel(RelOptCluster cluster, RelTraitSet traits, RelOptTable table) {
        this(cluster, traits, table, false);
    }

    public DrillScanRel(RelOptCluster cluster, RelTraitSet traits, RelOptTable table, boolean partitionFilterPushdown) {
        this(cluster, traits, table, table.getRowType(), DrillScanRel.getProjectedColumns(table, false), partitionFilterPushdown);
        this.settings = PrelUtil.getPlannerSettings(cluster.getPlanner());
    }

    public DrillScanRel(RelOptCluster cluster, RelTraitSet traits, RelOptTable table, RelDataType rowType, List<SchemaPath> columns) {
        this(cluster, traits, table, rowType, columns, false);
    }

    public DrillScanRel(RelOptCluster cluster, RelTraitSet traits, RelOptTable table, RelDataType rowType, List<SchemaPath> columns, boolean partitionFilterPushdown) {
        super(cluster, traits, table, columns);
        this.settings = PrelUtil.getPlannerSettings(cluster.getPlanner());
        this.rowType = rowType;
        Preconditions.checkNotNull(columns);
        this.columns = columns;
        this.partitionFilterPushdown = partitionFilterPushdown;
    }

    public DrillScanRel(RelOptCluster cluster, RelTraitSet traits, RelOptTable table, GroupScan groupScan, RelDataType rowType, List<SchemaPath> columns) {
        this(cluster, traits, table, groupScan, rowType, columns, false);
    }

    public DrillScanRel(RelOptCluster cluster, RelTraitSet traits, RelOptTable table, GroupScan groupScan, RelDataType rowType, List<SchemaPath> columns, boolean partitionFilterPushdown) {
        super(cluster, traits, groupScan, table);
        this.rowType = rowType;
        this.columns = columns;
        this.settings = PrelUtil.getPlannerSettings(cluster.getPlanner());
        this.partitionFilterPushdown = partitionFilterPushdown;
    }

    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    @Override
    public LogicalOperator implement(DrillImplementor implementor) {
        Scan.Builder builder = Scan.builder();
        builder.storageEngine(this.drillTable.getStorageEngineName());
        builder.selection(new JSONOptions(this.drillTable.getSelection()));
        implementor.registerSource(this.drillTable);
        return builder.build();
    }

    public static DrillScanRel convert(Scan scan, ConversionContext context) {
        return new DrillScanRel(context.getCluster(), context.getLogicalTraits(), context.getTable(scan));
    }

    public RelDataType deriveRowType() {
        return this.rowType;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("groupscan", (Object)this.getGroupScan().getDigest());
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return this.getGroupScan().getScanStats(this.settings).getRecordCount();
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double ioCost;
        double cpuCost;
        ScanStats stats = this.getGroupScan().getScanStats(this.settings);
        double columnCount = Utilities.isStarQuery(this.columns) ? 10000.0 : Math.pow(this.getRowType().getFieldCount(), 2.0) / (double)Math.max(this.columns.size(), 1);
        double rowCount = Math.max(1.0, stats.getRecordCount());
        double valueCount = rowCount * columnCount;
        if (PrelUtil.getSettings(this.getCluster()).useDefaultCosting()) {
            return planner.getCostFactory().makeCost(valueCount, stats.getCpuCost(), stats.getDiskCost());
        }
        if (stats.getGroupScanProperty().hasFullCost()) {
            cpuCost = stats.getCpuCost();
            ioCost = stats.getDiskCost();
        } else {
            cpuCost = valueCount;
            ioCost = 0.0;
        }
        return planner.getCostFactory().makeCost(rowCount, cpuCost, ioCost);
    }

    public boolean partitionFilterPushdown() {
        return this.partitionFilterPushdown;
    }

    public static List<SchemaPath> getProjectedColumns(RelOptTable table, boolean isSelectStar) {
        List columnNames = table.getRowType().getFieldNames();
        ArrayList<SchemaPath> projectedColumns = new ArrayList<SchemaPath>(columnNames.size());
        for (String columnName : columnNames) {
            projectedColumns.add(SchemaPath.getSimplePath(columnName));
        }
        if (isSelectStar && !Utilities.isStarQuery(projectedColumns)) {
            projectedColumns.add(SchemaPath.STAR_COLUMN);
        }
        return projectedColumns;
    }

    @Override
    public DrillScanRel copy(RelTraitSet traitSet, GroupScan scan, RelDataType rowType) {
        return new DrillScanRel(this.getCluster(), this.getTraitSet(), this.getTable(), scan, rowType, this.getColumns(), this.partitionFilterPushdown());
    }
}

