/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillRelFactories;
import org.apache.drill.exec.planner.logical.RelOptHelper;

public class DrillSetOpRule
extends RelOptRule {
    private final RelFactories.SetOpFactory setOpFactory;
    public static final List<RelOptRule> INSTANCES = Arrays.asList(new RelOptRule[]{new DrillSetOpRule(RelOptHelper.any(LogicalIntersect.class, (RelTrait)Convention.NONE), "DrillIntersectRelRule", DrillRelFactories.DRILL_LOGICAL_SET_OP_FACTORY), new DrillSetOpRule(RelOptHelper.any(LogicalMinus.class, (RelTrait)Convention.NONE), "DrillExceptRelRule", DrillRelFactories.DRILL_LOGICAL_SET_OP_FACTORY)});

    public DrillSetOpRule(RelOptRuleOperand operand, String description, RelFactories.SetOpFactory setOpFactory) {
        super(operand, description);
        this.setOpFactory = setOpFactory;
    }

    public void onMatch(RelOptRuleCall call) {
        SetOp setOp = (SetOp)call.rel(0);
        ArrayList<RelNode> convertedInputs = new ArrayList<RelNode>();
        for (RelNode input : setOp.getInputs()) {
            RelNode convertedInput = DrillSetOpRule.convert((RelNode)input, (RelTraitSet)input.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL).simplify());
            convertedInputs.add(convertedInput);
        }
        RelNode newRelNode = this.setOpFactory.createSetOp(setOp.kind, convertedInputs, setOp.all);
        if (newRelNode != null) {
            call.transformTo(newRelNode);
        }
    }
}

