/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.exec.planner.common.DrillSortRelBase;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.ExprHelper;
import org.apache.drill.exec.planner.torel.ConversionContext;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;

public class DrillSortRel
extends DrillSortRelBase
implements DrillRel {
    public DrillSortRel(RelOptCluster cluster, RelTraitSet traits, RelNode input, RelCollation collation) {
        super(cluster, traits, input, collation);
    }

    public DrillSortRel(RelOptCluster cluster, RelTraitSet traits, RelNode input, RelCollation collation, RexNode offset, RexNode fetch) {
        super(cluster, traits, input, collation, offset, fetch);
    }

    public DrillSortRel copy(RelTraitSet traitSet, RelNode input, RelCollation collation, RexNode offset, RexNode fetch) {
        return new DrillSortRel(this.getCluster(), traitSet, input, collation, offset, fetch);
    }

    @Override
    public LogicalOperator implement(DrillImplementor implementor) {
        Order.Builder builder = Order.builder();
        builder.setInput(implementor.visitChild(this, 0, this.getInput()));
        List childFields = this.getInput().getRowType().getFieldNames();
        for (RelFieldCollation fieldCollation : this.collation.getFieldCollations()) {
            builder.addOrdering(fieldCollation.getDirection(), new FieldReference((CharSequence)childFields.get(fieldCollation.getFieldIndex())), fieldCollation.nullDirection);
        }
        return builder.build();
    }

    public static RelNode convert(Order order, ConversionContext context) throws InvalidRelException {
        RelNode input = context.toRel(order.getInput());
        List fields = input.getRowType().getFieldNames();
        HashMap<String, Integer> fieldMap = Maps.newHashMap();
        int i = 0;
        for (String field : fields) {
            fieldMap.put(field, i);
            ++i;
        }
        ArrayList<RelFieldCollation> collations = Lists.newArrayList();
        for (Order.Ordering o : order.getOrderings()) {
            String fieldName = ExprHelper.getFieldName(o.getExpr());
            int fieldId = (Integer)fieldMap.get(fieldName);
            RelFieldCollation c = new RelFieldCollation(fieldId, o.getDirection(), o.getNullDirection());
            collations.add(c);
        }
        return new DrillSortRel(context.getCluster(), context.getLogicalTraits(), input, RelCollations.of(collations));
    }

    @Override
    public boolean canBeDropped() {
        return true;
    }
}

