/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.io.IOException;
import java.util.Objects;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.metastore.MetadataProviderManager;
import org.apache.drill.exec.metastore.store.FileSystemMetadataProviderManager;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.SchemalessScan;
import org.apache.drill.exec.planner.logical.DrillTableSelection;
import org.apache.drill.exec.planner.logical.SelectionBasedTableScan;
import org.apache.drill.exec.server.options.SessionOptionManager;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.util.ImpersonationUtil;

public abstract class DrillTable
implements Table,
TranslatableTable {
    private final String storageEngineName;
    private final StoragePluginConfig storageEngineConfig;
    private final Schema.TableType tableType;
    private final DrillTableSelection selection;
    private final StoragePlugin plugin;
    private final String userName;
    private GroupScan scan;
    private SessionOptionManager options;
    private MetadataProviderManager metadataProviderManager;

    public DrillTable(String storageEngineName, StoragePlugin plugin, String userName, DrillTableSelection selection) {
        this(storageEngineName, plugin, Schema.TableType.TABLE, userName, selection);
    }

    public DrillTable(String storageEngineName, StoragePlugin plugin, Schema.TableType tableType, String userName, DrillTableSelection selection) {
        this(storageEngineName, plugin, tableType, userName, selection, null);
    }

    public DrillTable(String storageEngineName, StoragePlugin plugin, Schema.TableType tableType, String userName, DrillTableSelection selection, MetadataProviderManager metadataProviderManager) {
        this.selection = selection;
        this.plugin = plugin;
        this.tableType = tableType;
        this.storageEngineConfig = plugin.getConfig();
        this.storageEngineName = storageEngineName;
        this.userName = userName;
        this.metadataProviderManager = metadataProviderManager;
    }

    public DrillTable(String storageEngineName, StoragePlugin plugin, DrillTableSelection selection) {
        this(storageEngineName, plugin, ImpersonationUtil.getProcessUserName(), selection);
    }

    public void setOptions(SessionOptionManager options) {
        this.options = options;
    }

    public void setGroupScan(GroupScan scan) {
        this.scan = scan;
    }

    public void setTableMetadataProviderManager(MetadataProviderManager metadataProviderManager) {
        this.metadataProviderManager = metadataProviderManager;
    }

    public GroupScan getGroupScan() throws IOException {
        if (this.scan == null) {
            this.scan = this.selection instanceof FileSelection && ((FileSelection)this.selection).isEmptyDirectory() ? new SchemalessScan(this.userName, ((FileSelection)this.selection).getSelectionRoot()) : this.plugin.getPhysicalScan(this.userName, new JSONOptions(this.selection), this.options, this.metadataProviderManager);
        }
        return this.scan;
    }

    public MetadataProviderManager getMetadataProviderManager() {
        if (this.metadataProviderManager == null) {
            this.metadataProviderManager = FileSystemMetadataProviderManager.init();
            if (this.scan != null) {
                this.metadataProviderManager.setTableMetadataProvider(this.scan.getMetadataProvider());
            }
        }
        return this.metadataProviderManager;
    }

    public StoragePluginConfig getStorageEngineConfig() {
        return this.storageEngineConfig;
    }

    public StoragePlugin getPlugin() {
        return this.plugin;
    }

    public Object getSelection() {
        return this.selection;
    }

    public String getStorageEngineName() {
        return this.storageEngineName;
    }

    public String getUserName() {
        return this.userName;
    }

    public Statistic getStatistic() {
        return Statistics.UNKNOWN;
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable table) {
        return SelectionBasedTableScan.create(context.getCluster(), table, this.selection.digest());
    }

    public Schema.TableType getJdbcTableType() {
        return this.tableType;
    }

    public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, SqlNode parent, CalciteConnectionConfig config) {
        return true;
    }

    public boolean isRolledUp(String column) {
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.selection, this.storageEngineConfig, this.storageEngineName, this.userName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DrillTable other = (DrillTable)obj;
        return Objects.equals(this.selection, other.selection) && Objects.equals(this.storageEngineConfig, other.storageEngineConfig) && Objects.equals(this.storageEngineName, other.storageEngineName) && Objects.equals(this.userName, other.userName);
    }
}

