/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.common.logical.data.InsertWriter;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillRel;

public class DrillTableModify
extends TableModify
implements DrillRel {
    protected DrillTableModify(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode input, TableModify.Operation operation, List<String> updateColumnList, List<RexNode> sourceExpressionList, boolean flattened) {
        super(cluster, traitSet, table, catalogReader, input, operation, updateColumnList, sourceExpressionList, flattened);
    }

    @Override
    public LogicalOperator implement(DrillImplementor implementor) {
        LogicalOperator childOp = implementor.visitChild(this, 0, this.getInput());
        InsertWriter logicalOperators = new InsertWriter(this.getTable());
        logicalOperators.setInput(childOp);
        return logicalOperators;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DrillTableModify(this.getCluster(), traitSet, this.getTable(), this.getCatalogReader(), inputs.get(0), this.getOperation(), this.getUpdateColumnList(), this.getSourceExpressionList(), this.isFlattened());
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount((RelNode)this);
        double inputRowCount = mq.getRowCount(this.getInput());
        double dIo = inputRowCount + 1.0;
        return planner.getCostFactory().makeCost(rowCount, 0.0, dIo).multiplyBy(10.0);
    }
}

