/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.Writer;
import org.apache.drill.exec.planner.common.DrillWriterRelBase;
import org.apache.drill.exec.planner.logical.CreateTableEntry;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class DrillWriterRel
extends DrillWriterRelBase
implements DrillRel {
    private final List<Integer> partitionKeys;

    public DrillWriterRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, CreateTableEntry createTableEntry) {
        super(DRILL_LOGICAL, cluster, traitSet, input, createTableEntry);
        this.setRowType();
        this.partitionKeys = this.resolvePartitionKeys();
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DrillWriterRel(this.getCluster(), traitSet, (RelNode)DrillWriterRel.sole(inputs), this.getCreateTableEntry());
    }

    @Override
    public LogicalOperator implement(DrillImplementor implementor) {
        LogicalOperator childOp = implementor.visitChild(this, 0, this.getInput());
        return ((Writer.Builder)Writer.builder().setInput(childOp)).setCreateTableEntry(this.getCreateTableEntry()).build();
    }

    private List<Integer> resolvePartitionKeys() {
        ArrayList<Integer> keys = Lists.newArrayList();
        RelDataType inputRowType = this.getInput().getRowType();
        List<String> partitionCol = this.getCreateTableEntry().getPartitionColumns();
        for (String col : partitionCol) {
            RelDataTypeField field = inputRowType.getField(col, false, false);
            Preconditions.checkArgument(field != null, String.format("partition col %s could not be resolved in table's column lists!", col));
            keys.add(field.getIndex());
        }
        return keys;
    }

    public List<Integer> getPartitionKeys() {
        return this.partitionKeys;
    }
}

