/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.MetadataAggregate;
import org.apache.drill.exec.metastore.analyze.MetadataAggregateContext;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillRel;

public class MetadataAggRel
extends SingleRel
implements DrillRel {
    private final MetadataAggregateContext context;

    public MetadataAggRel(RelOptCluster cluster, RelTraitSet traits, RelNode input, MetadataAggregateContext context) {
        super(cluster, traits, input);
        this.context = context;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double dRows = mq.getRowCount(this.getInput());
        double dCpu = dRows * 4.0;
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new MetadataAggRel(this.getCluster(), traitSet, (RelNode)MetadataAggRel.sole(inputs), this.context);
    }

    @Override
    public LogicalOperator implement(DrillImplementor implementor) {
        LogicalOperator inputOp = implementor.visitChild(this, 0, this.getInput());
        MetadataAggregate rel = new MetadataAggregate();
        rel.setInput(inputOp);
        return rel;
    }

    public MetadataAggregateContext getContext() {
        return this.context;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("context: ", (Object)this.context);
    }
}

