/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.MetadataController;
import org.apache.drill.exec.metastore.analyze.MetadataControllerContext;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class MetadataControllerRel
extends BiRel
implements DrillRel {
    private final MetadataControllerContext context;

    public MetadataControllerRel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, MetadataControllerContext context) {
        super(cluster, traits, left, right);
        this.context = context;
    }

    public MetadataControllerContext getContext() {
        return this.context;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double dRows = Math.max(mq.getRowCount(this.getLeft()), mq.getRowCount(this.getRight()));
        double dCpu = dRows * 4.0;
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        Preconditions.checkArgument(inputs.size() == 2);
        return new MetadataControllerRel(this.getCluster(), traitSet, inputs.get(0), inputs.get(1), this.context);
    }

    @Override
    public LogicalOperator implement(DrillImplementor implementor) {
        LogicalOperator left = implementor.visitChild(this, 0, this.getLeft());
        LogicalOperator right = implementor.visitChild(this, 1, this.getRight());
        return new MetadataController(left, right);
    }

    protected RelDataType deriveRowType() {
        return this.getCluster().getTypeFactory().builder().add("ok", SqlTypeName.BOOLEAN).add("summary", SqlTypeName.VARCHAR).build();
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("context: ", (Object)this.context);
    }
}

