/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.util.NlsString;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.exception.UnsupportedOperatorCollector;
import org.apache.drill.exec.planner.sql.DrillOperatorTable;
import org.apache.drill.exec.planner.sql.parser.DrillCalciteWrapperUtility;
import org.apache.drill.exec.util.ApproximateStringMatcher;
import org.apache.drill.exec.work.foreman.SqlUnsupportedException;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreProcessLogicalRel
extends RelShuttleImpl {
    private static final Logger logger = LoggerFactory.getLogger(PreProcessLogicalRel.class);
    private final RelDataTypeFactory factory;
    private final DrillOperatorTable table;
    private final UnsupportedOperatorCollector unsupportedOperatorCollector;
    private final UnwrappingExpressionVisitor unwrappingExpressionVisitor;

    public static PreProcessLogicalRel createVisitor(RelDataTypeFactory factory, DrillOperatorTable table, RexBuilder rexBuilder) {
        return new PreProcessLogicalRel(factory, table, rexBuilder);
    }

    private PreProcessLogicalRel(RelDataTypeFactory factory, DrillOperatorTable table, RexBuilder rexBuilder) {
        this.factory = factory;
        this.table = table;
        this.unsupportedOperatorCollector = new UnsupportedOperatorCollector();
        this.unwrappingExpressionVisitor = new UnwrappingExpressionVisitor(rexBuilder);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RelNode visit(LogicalProject project) {
        ArrayList<RexNode> projExpr = Lists.newArrayList();
        for (RexNode rexNode : project.getProjects()) {
            projExpr.add((RexNode)rexNode.accept((RexVisitor)this.unwrappingExpressionVisitor));
        }
        project = project.copy(project.getTraitSet(), project.getInput(), projExpr, project.getRowType());
        ArrayList<RexNode> exprList = new ArrayList<RexNode>();
        boolean rewrite = false;
        Iterator iterator = project.getProjects().iterator();
        while (iterator.hasNext()) {
            RexNode rex;
            RexNode newExpr = rex = (RexNode)iterator.next();
            if (rex instanceof RexCall) {
                RexCall function = (RexCall)rex;
                String functionName = function.getOperator().getName();
                int nArgs = function.getOperands().size();
                if (functionName.equalsIgnoreCase("convert_from") || functionName.equalsIgnoreCase("convert_to")) {
                    String literal;
                    if (nArgs != 2) throw UserException.parseError().message("'%s' expects a string literal as a second argument.", functionName).build(logger);
                    if (!(function.getOperands().get(1) instanceof RexLiteral)) throw this.getConvertFunctionInvalidTypeException(function);
                    try {
                        literal = ((NlsString)((RexLiteral)function.getOperands().get(1)).getValue()).getValue();
                    }
                    catch (ClassCastException e) {
                        throw this.getConvertFunctionInvalidTypeException(function);
                    }
                    RexBuilder builder = new RexBuilder(this.factory);
                    String newFunctionName = functionName + literal;
                    List<SqlOperator> operatorList = this.table.getSqlOperator(newFunctionName);
                    if (operatorList.size() == 0) {
                        throw this.getConvertFunctionException(functionName, literal);
                    }
                    SqlFunction newFunction = null;
                    for (SqlOperator op : operatorList) {
                        if (!op.getOperandTypeChecker().getOperandCountRange().isValidCount(nArgs - 1)) continue;
                        newFunction = (SqlFunction)op;
                        break;
                    }
                    if (newFunction == null) {
                        throw this.getConvertFunctionException(functionName, literal);
                    }
                    newExpr = builder.makeCall(newFunction, function.getOperands().subList(0, 1));
                    rewrite = true;
                }
            }
            exprList.add(newExpr);
        }
        if (!rewrite) return this.visitChild((RelNode)project, 0, project.getInput());
        LogicalProject newProject = project.copy(project.getTraitSet(), project.getInput(0), exprList, project.getRowType());
        return this.visitChild((RelNode)newProject, 0, project.getInput());
    }

    public RelNode visit(LogicalFilter filter) {
        RexNode condition = (RexNode)filter.getCondition().accept((RexVisitor)this.unwrappingExpressionVisitor);
        filter = filter.copy(filter.getTraitSet(), filter.getInput(), condition);
        return this.visitChild((RelNode)filter, 0, filter.getInput());
    }

    public RelNode visit(LogicalJoin join) {
        RexNode conditionExpr = (RexNode)join.getCondition().accept((RexVisitor)this.unwrappingExpressionVisitor);
        join = join.copy(join.getTraitSet(), conditionExpr, join.getLeft(), join.getRight(), join.getJoinType(), join.isSemiJoinDone());
        return this.visitChildren((RelNode)join);
    }

    public RelNode visit(LogicalUnion union) {
        for (RelNode child : union.getInputs()) {
            for (RelDataTypeField dataField : child.getRowType().getFieldList()) {
                if (!dataField.getName().contains("**")) continue;
                this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.RELATIONAL, "Union-All over schema-less tables must specify the columns explicitly\nSee Apache Drill JIRA: DRILL-2414");
                throw new UnsupportedOperationException();
            }
        }
        return this.visitChildren((RelNode)union);
    }

    public RelNode visit(LogicalIntersect intersect) {
        for (RelNode child : intersect.getInputs()) {
            for (RelDataTypeField dataField : child.getRowType().getFieldList()) {
                if (!dataField.getName().contains("**")) continue;
                this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.RELATIONAL, "Intersect(All) over schema-less tables must specify the columns explicitly\n");
                throw new UnsupportedOperationException();
            }
        }
        return this.visitChildren((RelNode)intersect);
    }

    public RelNode visit(LogicalMinus minus) {
        for (RelNode child : minus.getInputs()) {
            for (RelDataTypeField dataField : child.getRowType().getFieldList()) {
                if (!dataField.getName().contains("**")) continue;
                this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.RELATIONAL, "Except(All) over schema-less tables must specify the columns explicitly\n");
                throw new UnsupportedOperationException();
            }
        }
        return this.visitChildren((RelNode)minus);
    }

    private UserException getConvertFunctionInvalidTypeException(RexCall function) {
        String functionName = function.getOperator().getName();
        String typeName = ((RexNode)function.getOperands().get(1)).getType().getFullTypeString();
        return UserException.parseError().message("Invalid type %s passed as second argument to function '%s'. The function expects a literal argument.", typeName, functionName).build(logger);
    }

    private UserException getConvertFunctionException(String functionName, String typeName) {
        String newFunctionName = functionName + typeName;
        String typeNameToPrint = typeName.length() == 0 ? "<empty_string>" : typeName;
        UserException.Builder exceptionBuilder = UserException.unsupportedError().message("%s does not support conversion %s type '%s'.", functionName, functionName.substring(8).toLowerCase(), typeNameToPrint);
        if (typeName.length() > 0) {
            ArrayList<String> ops = new ArrayList<String>();
            for (SqlOperator op : this.table.getOperatorList()) {
                ops.add(op.getName());
            }
            String bestMatch = ApproximateStringMatcher.getBestMatch(ops, newFunctionName);
            if (bestMatch != null && bestMatch.length() > functionName.length() && bestMatch.toLowerCase().startsWith("convert")) {
                StringBuilder s = new StringBuilder("Did you mean ").append(bestMatch.substring(functionName.length())).append("?");
                exceptionBuilder.addContext(s.toString());
            }
        }
        return exceptionBuilder.build(logger);
    }

    public void convertException() throws SqlUnsupportedException {
        this.unsupportedOperatorCollector.convertException();
    }

    private static class UnwrappingExpressionVisitor
    extends RexShuttle {
        private final RexBuilder rexBuilder;

        private UnwrappingExpressionVisitor(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public RexNode visitCall(RexCall call) {
            List clonedOperands = this.visitList(call.operands, new boolean[]{true});
            SqlOperator sqlOperator = DrillCalciteWrapperUtility.extractSqlOperatorFromWrapper(call.getOperator());
            return RexUtil.flatten((RexBuilder)this.rexBuilder, (RexNode)this.rexBuilder.makeCall(call.getType(), sqlOperator, clonedOperands));
        }
    }
}

