/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.LogicalPlan;
import org.apache.drill.common.logical.data.Except;
import org.apache.drill.common.logical.data.Filter;
import org.apache.drill.common.logical.data.GroupingAggregate;
import org.apache.drill.common.logical.data.Intersect;
import org.apache.drill.common.logical.data.Join;
import org.apache.drill.common.logical.data.JoinCondition;
import org.apache.drill.common.logical.data.Limit;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.common.logical.data.Project;
import org.apache.drill.common.logical.data.Scan;
import org.apache.drill.common.logical.data.SinkOperator;
import org.apache.drill.common.logical.data.Store;
import org.apache.drill.common.logical.data.Union;
import org.apache.drill.common.logical.data.Values;
import org.apache.drill.common.logical.data.visitors.AbstractLogicalVisitor;
import org.apache.drill.exec.store.parquet.FilterEvaluatorUtils;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;

public class ScanFieldDeterminer
extends AbstractLogicalVisitor<Void, FieldList, RuntimeException> {
    private Map<Scan, FieldList> scanFields = Maps.newHashMap();

    public static Map<Scan, FieldList> getFieldLists(LogicalPlan plan) {
        Collection<SinkOperator> ops = plan.getGraph().getRoots();
        Preconditions.checkArgument(ops.size() == 1, "Scan Field determiner currently only works with plans that have a single root.");
        ScanFieldDeterminer sfd = new ScanFieldDeterminer();
        ops.iterator().next().accept(sfd, new FieldList());
        return sfd.scanFields;
    }

    private ScanFieldDeterminer() {
    }

    @Override
    public Void visitScan(Scan scan, FieldList value) {
        if (value == null) {
            this.scanFields.put(scan, new FieldList());
        } else {
            this.scanFields.put(scan, value);
        }
        return null;
    }

    @Override
    public Void visitStore(Store store, FieldList value) {
        store.getInput().accept(this, value);
        return null;
    }

    @Override
    public Void visitGroupingAggregate(GroupingAggregate groupBy, FieldList value) {
        FieldList list = new FieldList();
        for (NamedExpression e : groupBy.getExprs()) {
            list.addProjected((Collection<SchemaPath>)e.getExpr().accept(FilterEvaluatorUtils.FieldReferenceFinder.INSTANCE, null));
        }
        for (NamedExpression e : groupBy.getKeys()) {
            list.addProjected((Collection<SchemaPath>)e.getExpr().accept(FilterEvaluatorUtils.FieldReferenceFinder.INSTANCE, null));
        }
        groupBy.getInput().accept(this, list);
        return null;
    }

    @Override
    public Void visitFilter(Filter filter, FieldList value) {
        value.addReferenced((Collection<SchemaPath>)filter.getExpr().accept(FilterEvaluatorUtils.FieldReferenceFinder.INSTANCE, null));
        return null;
    }

    @Override
    public Void visitProject(Project project, FieldList value) {
        FieldList fl = new FieldList();
        for (NamedExpression e : project.getSelections()) {
            fl.addProjected((Collection<SchemaPath>)e.getExpr().accept(FilterEvaluatorUtils.FieldReferenceFinder.INSTANCE, null));
        }
        return null;
    }

    @Override
    public Void visitValues(Values constant, FieldList value) {
        return null;
    }

    @Override
    public Void visitOrder(Order order, FieldList fl) {
        for (Order.Ordering o : order.getOrderings()) {
            fl.addReferenced((Collection<SchemaPath>)o.getExpr().accept(FilterEvaluatorUtils.FieldReferenceFinder.INSTANCE, null));
        }
        return null;
    }

    @Override
    public Void visitJoin(Join join, FieldList fl) {
        FieldList leftList = fl.clone();
        for (JoinCondition c : join.getConditions()) {
            leftList.addReferenced((Collection<SchemaPath>)c.getLeft().accept(FilterEvaluatorUtils.FieldReferenceFinder.INSTANCE, null));
        }
        join.getLeft().accept(this, leftList);
        FieldList rightList = fl.clone();
        for (JoinCondition c : join.getConditions()) {
            rightList.addReferenced((Collection<SchemaPath>)c.getRight().accept(FilterEvaluatorUtils.FieldReferenceFinder.INSTANCE, null));
        }
        join.getLeft().accept(this, rightList);
        return null;
    }

    @Override
    public Void visitLimit(Limit limit, FieldList value) {
        limit.getInput().accept(this, value);
        return null;
    }

    @Override
    public Void visitUnion(Union union, FieldList value) {
        for (LogicalOperator o : union.getInputs()) {
            o.accept(this, value.clone());
        }
        return null;
    }

    @Override
    public Void visitExcept(Except except, FieldList value) {
        for (LogicalOperator o : except.getInputs()) {
            o.accept(this, value.clone());
        }
        return null;
    }

    @Override
    public Void visitIntersect(Intersect intersect, FieldList value) {
        for (LogicalOperator o : intersect.getInputs()) {
            o.accept(this, value.clone());
        }
        return null;
    }

    public static class FieldList {
        private Set<SchemaPath> projected = Sets.newHashSet();
        private Set<SchemaPath> referenced = Sets.newHashSet();

        public void addProjected(SchemaPath path) {
            this.projected.add(path);
        }

        public void addReferenced(SchemaPath path) {
            this.referenced.add(path);
        }

        public void addReferenced(Collection<SchemaPath> paths) {
            this.referenced.addAll(paths);
        }

        public void addProjected(Collection<SchemaPath> paths) {
            this.projected.addAll(paths);
        }

        public FieldList clone() {
            FieldList newList = new FieldList();
            for (SchemaPath p : this.projected) {
                newList.addProjected(p);
            }
            for (SchemaPath p : this.referenced) {
                newList.addReferenced(p);
            }
            return newList;
        }
    }
}

