/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.schema.Table;

public class SelectionBasedTableScan
extends TableScan {
    private final String digestFromSelection;

    public SelectionBasedTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, String digestFromSelection) {
        super(cluster, traitSet, Collections.emptyList(), table);
        this.digestFromSelection = digestFromSelection;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new SelectionBasedTableScan(this.getCluster(), traitSet, this.table, this.digestFromSelection);
    }

    public static TableScan create(RelOptCluster cluster, RelOptTable relOptTable, String digestFromSelection) {
        Table table = (Table)relOptTable.unwrap(Table.class);
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)Convention.NONE).replaceIfs((RelTraitDef)RelCollationTraitDef.INSTANCE, () -> table != null ? table.getStatistic().getCollations() : Collections.emptyList());
        return new SelectionBasedTableScan(cluster, traitSet, relOptTable, digestFromSelection);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("selection", (Object)this.digestFromSelection);
    }
}

