/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical.partition;

import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Deque;
import java.util.List;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlRowOperator;
import org.apache.calcite.util.Util;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class FindPartitionConditions
extends RexVisitorImpl<Void> {
    private final BitSet dirs;
    private final BitSet referencedDirs;
    private final List<PushDirFilter> pushStatusStack = Lists.newArrayList();
    private final Deque<OpState> opStack = new ArrayDeque<OpState>();
    private int holisticExpression = 0;
    private RexBuilder builder = null;
    private RexNode resultCondition = null;

    public FindPartitionConditions(BitSet dirs) {
        super(true);
        this.dirs = dirs;
        this.referencedDirs = new BitSet(dirs.size());
    }

    public FindPartitionConditions(BitSet dirs, RexBuilder builder) {
        super(true);
        this.dirs = dirs;
        this.builder = builder;
        this.referencedDirs = new BitSet(dirs.size());
    }

    public void analyze(RexNode exp) {
        assert (this.pushStatusStack.isEmpty());
        exp.accept((RexVisitor)this);
        assert (this.pushStatusStack.size() == 1);
        PushDirFilter rootPushDirFilter = this.pushStatusStack.get(0);
        if (rootPushDirFilter == PushDirFilter.PUSH) {
            this.addResult(exp);
        }
        this.pushStatusStack.clear();
    }

    public RexNode getFinalCondition() {
        return this.resultCondition;
    }

    public BitSet getReferencedDirs() {
        return this.referencedDirs;
    }

    private Void pushVariable() {
        this.pushStatusStack.add(PushDirFilter.NO_PUSH);
        return null;
    }

    private void addResult(RexNode exp) {
        if (this.holisticExpression > 0) {
            return;
        }
        if (!this.opStack.isEmpty()) {
            OpState op = this.opStack.peek();
            op.addChild(exp);
        } else {
            this.resultCondition = exp;
        }
    }

    private void clearChildren() {
        OpState op;
        if (!this.opStack.isEmpty() && (op = this.opStack.peek()).getChildren().size() >= 1) {
            op.clear();
        }
    }

    private void popOpStackAndBuildFilter() {
        if (this.holisticExpression > 0) {
            return;
        }
        OpState currentOp = this.opStack.pop();
        int size = currentOp.getChildren().size();
        RexNode newFilter = null;
        if (size >= 1) {
            if (size == 1 && currentOp.getOp() instanceof SqlBinaryOperator) {
                if (currentOp.getOp().getKind() == SqlKind.AND) {
                    newFilter = currentOp.getChildren().get(0);
                    for (OpState opState : this.opStack) {
                        if (opState.getOp().getKind() != SqlKind.NOT) continue;
                        newFilter = null;
                    }
                }
            } else {
                newFilter = this.builder.makeCall(currentOp.getOp(), currentOp.getChildren());
            }
        }
        if (newFilter != null) {
            if (!this.opStack.isEmpty()) {
                OpState parentOp = this.opStack.peek();
                parentOp.addChild(newFilter);
            } else {
                this.resultCondition = newFilter;
            }
        }
    }

    private boolean isHolisticExpression(RexCall call) {
        if (this.holisticExpression > 0) {
            return true;
        }
        return call.getOperator().getSyntax() == SqlSyntax.SPECIAL || call.getOperator().getSyntax() == SqlSyntax.FUNCTION;
    }

    protected boolean inputRefToPush(RexInputRef inputRef) {
        return this.dirs.get(inputRef.getIndex());
    }

    public Void visitInputRef(RexInputRef inputRef) {
        if (this.inputRefToPush(inputRef)) {
            this.pushStatusStack.add(PushDirFilter.PUSH);
            this.addResult((RexNode)inputRef);
            this.referencedDirs.set(inputRef.getIndex());
        } else {
            this.pushStatusStack.add(PushDirFilter.NO_PUSH);
        }
        return null;
    }

    public Void visitLiteral(RexLiteral literal) {
        this.pushStatusStack.add(PushDirFilter.PUSH);
        this.addResult((RexNode)literal);
        return null;
    }

    public Void visitOver(RexOver over) {
        this.analyzeCall((RexCall)over, PushDirFilter.NO_PUSH);
        return null;
    }

    public Void visitCorrelVariable(RexCorrelVariable correlVariable) {
        return this.pushVariable();
    }

    public Void visitCall(RexCall call) {
        this.analyzeCall(call, PushDirFilter.PUSH);
        return null;
    }

    private void analyzeCall(RexCall call, PushDirFilter callPushDirFilter) {
        OpState currentOp;
        if (this.isHolisticExpression(call)) {
            ++this.holisticExpression;
        } else {
            this.opStack.push(new OpState(call.getOperator()));
        }
        super.visitCall(call);
        int operandCount = call.getOperands().size();
        List operandStack = Util.last(this.pushStatusStack, (int)operandCount);
        for (PushDirFilter operandPushDirFilter : operandStack) {
            if (operandPushDirFilter == PushDirFilter.NO_PUSH) {
                callPushDirFilter = PushDirFilter.NO_PUSH;
                continue;
            }
            if (operandPushDirFilter != PushDirFilter.PARTIAL_PUSH) continue;
            callPushDirFilter = PushDirFilter.PARTIAL_PUSH;
        }
        if (!call.getOperator().isDeterministic()) {
            callPushDirFilter = PushDirFilter.NO_PUSH;
        } else if (call.getOperator().isDynamicFunction()) {
            callPushDirFilter = PushDirFilter.NO_PUSH;
        }
        if (callPushDirFilter == PushDirFilter.PUSH && call.getOperator() instanceof SqlRowOperator) {
            callPushDirFilter = PushDirFilter.NO_PUSH;
        }
        if (callPushDirFilter == PushDirFilter.NO_PUSH && (currentOp = this.opStack.peek()) != null) {
            if (currentOp.sqlOperator.getKind() != SqlKind.AND) {
                this.clearChildren();
            } else if (currentOp.children.size() > 0) {
                callPushDirFilter = PushDirFilter.PARTIAL_PUSH;
            }
        }
        operandStack.clear();
        if (this.isHolisticExpression(call)) {
            assert (this.holisticExpression > 0);
            --this.holisticExpression;
            if (callPushDirFilter == PushDirFilter.PUSH) {
                this.addResult((RexNode)call);
            }
        } else {
            this.popOpStackAndBuildFilter();
        }
        this.pushStatusStack.add(callPushDirFilter);
    }

    public Void visitDynamicParam(RexDynamicParam dynamicParam) {
        return this.pushVariable();
    }

    public Void visitRangeRef(RexRangeRef rangeRef) {
        return this.pushVariable();
    }

    public Void visitFieldAccess(RexFieldAccess fieldAccess) {
        return this.pushVariable();
    }

    static enum PushDirFilter {
        NO_PUSH,
        PUSH,
        PARTIAL_PUSH;

    }

    public class OpState {
        private SqlOperator sqlOperator;
        private List<RexNode> children = Lists.newArrayList();

        public OpState(SqlOperator op) {
            this.sqlOperator = op;
        }

        public SqlOperator getOp() {
            return this.sqlOperator;
        }

        public void addChild(RexNode n) {
            if (!this.children.contains(n)) {
                this.children.add(n);
            }
        }

        public List<RexNode> getChildren() {
            return this.children;
        }

        public void clear() {
            this.children.clear();
        }
    }
}

