/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical.partition;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class RewriteAsBinaryOperators
extends RexVisitorImpl<RexNode> {
    RexBuilder builder;

    public RewriteAsBinaryOperators(boolean deep, RexBuilder builder) {
        super(deep);
        this.builder = builder;
    }

    public RexNode visitInputRef(RexInputRef inputRef) {
        return inputRef;
    }

    public RexNode visitLiteral(RexLiteral literal) {
        return literal;
    }

    public RexNode visitOver(RexOver over) {
        return over;
    }

    public RexNode visitCorrelVariable(RexCorrelVariable correlVariable) {
        return correlVariable;
    }

    public RexNode visitCall(RexCall call) {
        SqlOperator op = call.getOperator();
        SqlKind kind = op.getKind();
        RelDataType type = call.getType();
        if ((kind == SqlKind.OR || kind == SqlKind.AND) && call.getOperands().size() > 2) {
            ArrayList children = new ArrayList(call.getOperands());
            RexNode left = (RexNode)((RexNode)children.remove(0)).accept((RexVisitor)this);
            RexNode right = (RexNode)this.builder.makeCall(type, op, children).accept((RexVisitor)this);
            return this.builder.makeCall(type, op, ImmutableList.of(left, right));
        }
        return this.builder.makeCall(type, op, this.visitChildren(call));
    }

    private List<RexNode> visitChildren(RexCall call) {
        ArrayList<RexNode> children = Lists.newArrayList();
        for (RexNode child : call.getOperands()) {
            children.add((RexNode)child.accept((RexVisitor)this));
        }
        return ImmutableList.copyOf(children);
    }

    public RexNode visitDynamicParam(RexDynamicParam dynamicParam) {
        return dynamicParam;
    }

    public RexNode visitRangeRef(RexRangeRef rangeRef) {
        return rangeRef;
    }

    public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
        return fieldAccess;
    }

    public RexNode visitLocalRef(RexLocalRef localRef) {
        return localRef;
    }
}

