/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.util.BitSets;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Optionality;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.IfExpression;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.NullExpression;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.exec.planner.common.DrillAggregateRelBase;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.visitor.PrelVisitor;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public abstract class AggPrelBase
extends DrillAggregateRelBase
implements Prel {
    protected OperatorPhase operPhase = OperatorPhase.PHASE_1of1;
    protected List<NamedExpression> keys = Lists.newArrayList();
    protected List<NamedExpression> aggExprs = Lists.newArrayList();
    protected List<AggregateCall> phase2AggCallList = Lists.newArrayList();

    public AggPrelBase(RelOptCluster cluster, RelTraitSet traits, RelNode child, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls, OperatorPhase phase) throws InvalidRelException {
        super(cluster, traits, child, groupSet, groupSets, aggCalls);
        this.operPhase = phase;
        this.createKeysAndExprs();
    }

    public OperatorPhase getOperatorPhase() {
        return this.operPhase;
    }

    public List<NamedExpression> getKeys() {
        return this.keys;
    }

    public List<NamedExpression> getAggExprs() {
        return this.aggExprs;
    }

    public List<AggregateCall> getPhase2AggCalls() {
        return this.phase2AggCallList;
    }

    protected void createKeysAndExprs() {
        List childFields = this.getInput().getRowType().getFieldNames();
        List fields = this.getRowType().getFieldNames();
        Iterator<Object> iterator = BitSets.toIter((ImmutableBitSet)this.groupSet).iterator();
        while (iterator.hasNext()) {
            int group = (Integer)iterator.next();
            FieldReference fr = FieldReference.getWithQuotedRef((CharSequence)childFields.get(group));
            this.keys.add(new NamedExpression(fr, fr));
        }
        for (Ord aggCall : Ord.zip((List)this.aggCalls)) {
            int aggExprOrdinal = this.groupSet.cardinality() + aggCall.i;
            FieldReference ref = FieldReference.getWithQuotedRef((CharSequence)fields.get(aggExprOrdinal));
            LogicalExpression expr = this.toDrill((AggregateCall)aggCall.e, childFields);
            NamedExpression ne = new NamedExpression(expr, ref);
            this.aggExprs.add(ne);
            if (this.getOperatorPhase() != OperatorPhase.PHASE_1of2) continue;
            if (((AggregateCall)aggCall.e).getAggregation().getName().equals("COUNT")) {
                SqlSumCountAggFunction sumAggFun = new SqlSumCountAggFunction(((AggregateCall)aggCall.e).getType());
                AggregateCall newAggCall = AggregateCall.create((SqlAggFunction)sumAggFun, (boolean)((AggregateCall)aggCall.e).isDistinct(), (boolean)((AggregateCall)aggCall.e).isApproximate(), (boolean)false, Collections.singletonList(aggExprOrdinal), (int)((AggregateCall)aggCall.e).filterArg, null, (RelCollation)RelCollations.EMPTY, (RelDataType)((AggregateCall)aggCall.e).getType(), (String)((AggregateCall)aggCall.e).getName());
                this.phase2AggCallList.add(newAggCall);
                continue;
            }
            AggregateCall newAggCall = AggregateCall.create((SqlAggFunction)((AggregateCall)aggCall.e).getAggregation(), (boolean)((AggregateCall)aggCall.e).isDistinct(), (boolean)((AggregateCall)aggCall.e).isApproximate(), (boolean)false, Collections.singletonList(aggExprOrdinal), (int)((AggregateCall)aggCall.e).filterArg, null, (RelCollation)RelCollations.EMPTY, (RelDataType)((AggregateCall)aggCall.e).getType(), (String)((AggregateCall)aggCall.e).getName());
            this.phase2AggCallList.add(newAggCall);
        }
    }

    protected LogicalExpression toDrill(AggregateCall call, List<String> fn) {
        ArrayList<LogicalExpression> args = Lists.newArrayList();
        for (Integer i : call.getArgList()) {
            LogicalExpression expr = FieldReference.getWithQuotedRef(fn.get(i));
            expr = AggPrelBase.getArgumentExpression(call, fn, expr);
            args.add(expr);
        }
        if (SqlKind.COUNT.name().equals(call.getAggregation().getName()) && args.isEmpty()) {
            LogicalExpression expr = new ValueExpressions.LongExpression(1L);
            expr = AggPrelBase.getArgumentExpression(call, fn, expr);
            args.add(expr);
        }
        return new FunctionCall(call.getAggregation().getName().toLowerCase(), args, ExpressionPosition.UNKNOWN);
    }

    private static LogicalExpression getArgumentExpression(AggregateCall call, List<String> fn, LogicalExpression expr) {
        if (call.hasFilter()) {
            return IfExpression.newBuilder().setIfCondition(new IfExpression.IfCondition(FieldReference.getWithQuotedRef(fn.get(call.filterArg)), expr)).setElse(NullExpression.INSTANCE).build();
        }
        return expr;
    }

    @Override
    public Iterator<Prel> iterator() {
        return PrelUtil.iter(this.getInput());
    }

    @Override
    public <T, X, E extends Throwable> T accept(PrelVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitPrel(this, value);
    }

    @Override
    public boolean needsFinalColumnReordering() {
        return true;
    }

    @Override
    public Prel prepareForLateralUnnestPipeline(List<RelNode> children) {
        ArrayList<Integer> groupingCols = Lists.newArrayList();
        groupingCols.add(0);
        Iterator iterator = this.groupSet.asList().iterator();
        while (iterator.hasNext()) {
            int groupingCol = (Integer)iterator.next();
            groupingCols.add(groupingCol + 1);
        }
        ImmutableBitSet groupingSet = ImmutableBitSet.of(groupingCols);
        ArrayList<ImmutableBitSet> groupingSets = Lists.newArrayList();
        groupingSets.add(groupingSet);
        ArrayList<AggregateCall> aggregateCalls = Lists.newArrayList();
        for (AggregateCall aggCall : this.aggCalls) {
            ArrayList<Integer> arglist = Lists.newArrayList();
            Iterator iterator2 = aggCall.getArgList().iterator();
            while (iterator2.hasNext()) {
                int arg = (Integer)iterator2.next();
                arglist.add(arg + 1);
            }
            aggregateCalls.add(AggregateCall.create((SqlAggFunction)aggCall.getAggregation(), (boolean)aggCall.isDistinct(), (boolean)aggCall.isApproximate(), (boolean)false, arglist, (int)aggCall.filterArg, null, (RelCollation)RelCollations.EMPTY, (RelDataType)aggCall.type, (String)aggCall.name));
        }
        return (Prel)this.copy(this.traitSet, children.get(0), groupingSet, groupingSets, aggregateCalls);
    }

    public static enum OperatorPhase {
        PHASE_1of1("Single"),
        PHASE_1of2("1st"),
        PHASE_2of2("2nd");

        private final String name;

        private OperatorPhase(String name) {
            this.name = name;
        }

        public boolean hasTwo() {
            return this != PHASE_1of1;
        }

        public boolean is1st() {
            return this == PHASE_1of2;
        }

        public boolean is2nd() {
            return this == PHASE_2of2;
        }

        public boolean isFinal() {
            return this != PHASE_1of2;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class SqlSumCountAggFunction
    extends SqlAggFunction {
        private final RelDataType type;

        public SqlSumCountAggFunction(RelDataType type) {
            super("$SUM0", null, SqlKind.OTHER_FUNCTION, ReturnTypes.BIGINT, null, (SqlOperandTypeChecker)OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC, false, false, Optionality.FORBIDDEN);
            this.type = type;
        }

        public RelDataType getType() {
            return this.type;
        }
    }
}

