/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.drill.exec.planner.logical.DrillAggregateRel;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public abstract class AggPruleBase
extends Prule {
    protected AggPruleBase(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    protected List<DrillDistributionTrait.DistributionField> getDistributionField(DrillAggregateRel rel, boolean allFields) {
        ArrayList<DrillDistributionTrait.DistributionField> groupByFields = Lists.newArrayList();
        Iterator iterator = AggPruleBase.remapGroupSet(rel.getGroupSet()).iterator();
        while (iterator.hasNext()) {
            int group = (Integer)iterator.next();
            DrillDistributionTrait.DistributionField field = new DrillDistributionTrait.DistributionField(group);
            groupByFields.add(field);
            if (allFields || groupByFields.size() != 1) continue;
            break;
        }
        return groupByFields;
    }

    protected boolean create2PhasePlan(RelOptRuleCall call, DrillAggregateRel aggregate) {
        boolean smallInput;
        PlannerSettings settings = PrelUtil.getPlannerSettings(call.getPlanner());
        RelNode child = (RelNode)call.rel(0).getInputs().get(0);
        boolean bl = smallInput = child.estimateRowCount(child.getCluster().getMetadataQuery()) < (double)settings.getSliceTarget();
        if (!settings.isMultiPhaseAggEnabled() || settings.isSingleMode() || smallInput && !settings.isForce2phaseAggr()) {
            return false;
        }
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            String name = aggCall.getAggregation().getName();
            if (name.equals(SqlKind.SUM.name()) || name.equals(SqlKind.MIN.name()) || name.equals(SqlKind.MAX.name()) || name.equals(SqlKind.COUNT.name()) || name.equals("$SUM0")) continue;
            return false;
        }
        return true;
    }

    public static ImmutableBitSet remapGroupSet(ImmutableBitSet groupSet) {
        ArrayList<Integer> newGroupSet = Lists.newArrayList();
        int groupSetToAdd = 0;
        Iterator iterator = groupSet.iterator();
        while (iterator.hasNext()) {
            int ignored = (Integer)iterator.next();
            newGroupSet.add(groupSetToAdd++);
        }
        return ImmutableBitSet.of(newGroupSet);
    }
}

