/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.BroadcastExchange;
import org.apache.drill.exec.physical.config.SelectionVectorRemover;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.physical.ExchangePrel;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.record.BatchSchema;

public class BroadcastExchangePrel
extends ExchangePrel {
    public BroadcastExchangePrel(RelOptCluster cluster, RelTraitSet traitSet, RelNode input) {
        super(cluster, traitSet, input);
        assert (input.getConvention() == Prel.DRILL_PHYSICAL);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        if (PrelUtil.getSettings(this.getCluster()).useDefaultCosting()) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.1);
        }
        RelNode child = this.getInput();
        int numEndPoints = PrelUtil.getSettings(this.getCluster()).numEndPoints();
        double broadcastFactor = PrelUtil.getSettings(this.getCluster()).getBroadcastFactor();
        double inputRows = mq.getRowCount(child);
        int rowWidth = child.getRowType().getFieldCount() * 8;
        double cpuCost = broadcastFactor * 8.0 * inputRows;
        double networkCost = broadcastFactor * 512.0 * inputRows * (double)rowWidth * ((double)numEndPoints - 0.9);
        return new DrillCostBase(inputRows, cpuCost, 0.0, networkCost);
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.DEFAULT;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new BroadcastExchangePrel(this.getCluster(), traitSet, (RelNode)BroadcastExchangePrel.sole(inputs));
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        Prel child = (Prel)this.getInput();
        PhysicalOperator childPOP = child.getPhysicalOperator(creator);
        if (!childPOP.getSVMode().equals((Object)BatchSchema.SelectionVectorMode.NONE)) {
            childPOP = new SelectionVectorRemover(childPOP);
        }
        BroadcastExchange g = new BroadcastExchange(childPOP);
        return creator.addMetadata(this, g);
    }
}

