/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.planner.common.CountToDirectScanUtils;
import org.apache.drill.exec.planner.logical.DrillAggregateRel;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.DirectScanPrel;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.store.ColumnExplorer;
import org.apache.drill.exec.store.direct.MetadataDirectGroupScan;
import org.apache.drill.exec.store.pojo.DynamicPojoRecordReader;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertCountToDirectScanPrule
extends Prule {
    public static final RelOptRule AGG_ON_PROJ_ON_SCAN = new ConvertCountToDirectScanPrule(RelOptHelper.some(DrillAggregateRel.class, RelOptHelper.some(DrillProjectRel.class, RelOptHelper.any(DrillScanRel.class), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "Agg_on_proj_on_scan");
    public static final RelOptRule AGG_ON_SCAN = new ConvertCountToDirectScanPrule(RelOptHelper.some(DrillAggregateRel.class, RelOptHelper.any(DrillScanRel.class), new RelOptRuleOperand[0]), "Agg_on_scan");
    private static final Logger logger = LoggerFactory.getLogger(ConvertCountToDirectScanPrule.class);

    private ConvertCountToDirectScanPrule(RelOptRuleOperand rule, String id) {
        super(rule, "ConvertCountToDirectScanPrule:" + id);
    }

    public void onMatch(RelOptRuleCall call) {
        PlannerSettings settings;
        DrillAggregateRel agg = (DrillAggregateRel)call.rel(0);
        DrillScanRel scan = (DrillScanRel)call.rel(call.rels.length - 1);
        DrillProjectRel project = call.rels.length == 3 ? (DrillProjectRel)call.rel(1) : null;
        GroupScan oldGrpScan = scan.getGroupScan();
        if (!oldGrpScan.getScanStats(settings = PrelUtil.getPlannerSettings(call.getPlanner())).getGroupScanProperty().hasExactRowCount() || agg.getGroupCount() != 0 || agg.containsDistinctCall()) {
            return;
        }
        Map<String, Long> result = this.collectCounts(settings, agg, scan, project);
        logger.trace("Calculated the following aggregate counts: {}", result);
        if (result.isEmpty()) {
            return;
        }
        RelDataType scanRowType = CountToDirectScanUtils.constructDataType(agg, result.keySet());
        DynamicPojoRecordReader reader = new DynamicPojoRecordReader(CountToDirectScanUtils.buildSchema(scanRowType.getFieldNames()), Collections.singletonList(new ArrayList<Long>(result.values())));
        ScanStats scanStats = new ScanStats(ScanStats.GroupScanProperty.EXACT_ROW_COUNT, 1.0, 1.0, scanRowType.getFieldCount());
        int numFiles = oldGrpScan.hasFiles() ? oldGrpScan.getFiles().size() : -1;
        MetadataDirectGroupScan directScan = new MetadataDirectGroupScan(reader, oldGrpScan.getSelectionRoot(), numFiles, scanStats, false, oldGrpScan.usedMetastore());
        DirectScanPrel newScan = DirectScanPrel.create(scan, scan.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)DrillDistributionTrait.SINGLETON), directScan, scanRowType);
        ProjectPrel newProject = new ProjectPrel(agg.getCluster(), agg.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)DrillDistributionTrait.SINGLETON), newScan, CountToDirectScanUtils.prepareFieldExpressions(scanRowType), agg.getRowType());
        call.transformTo((RelNode)newProject);
    }

    private Map<String, Long> collectCounts(PlannerSettings settings, DrillAggregateRel agg, DrillScanRel scan, DrillProjectRel project) {
        Set<String> implicitColumnsNames = ColumnExplorer.initImplicitFileColumns(settings.getOptions()).keySet();
        GroupScan oldGrpScan = scan.getGroupScan();
        long totalRecordCount = (long)oldGrpScan.getScanStats(settings).getRecordCount();
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        for (int i = 0; i < agg.getAggCallList().size(); ++i) {
            long cnt;
            AggregateCall aggCall = (AggregateCall)agg.getAggCallList().get(i);
            if (!"count".equalsIgnoreCase(aggCall.getAggregation().getName())) {
                return ImmutableMap.of();
            }
            if (CountToDirectScanUtils.containsStarOrNotNullInput(aggCall, agg)) {
                cnt = totalRecordCount;
            } else if (aggCall.getArgList().size() == 1) {
                String columnName;
                int index = (Integer)aggCall.getArgList().get(0);
                if (project != null) {
                    if (!(project.getProjects().get(index) instanceof RexInputRef)) {
                        return ImmutableMap.of();
                    }
                    index = ((RexInputRef)project.getProjects().get(index)).getIndex();
                }
                if (implicitColumnsNames.contains(columnName = ((String)scan.getRowType().getFieldNames().get(index)).toLowerCase())) {
                    cnt = totalRecordCount;
                } else {
                    SchemaPath simplePath = SchemaPath.getSimplePath(columnName);
                    if (ColumnExplorer.isPartitionColumn(settings.getOptions(), simplePath)) {
                        return ImmutableMap.of();
                    }
                    cnt = oldGrpScan.getColumnValueCount(simplePath);
                    if (cnt == -1L) {
                        return ImmutableMap.of();
                    }
                }
            } else {
                return ImmutableMap.of();
            }
            String name = "count" + i + "$" + (aggCall.getName() == null ? aggCall.toString() : aggCall.getName());
            result.put(name, cnt);
        }
        return ImmutableMap.copyOf(result);
    }
}

