/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.fragment.DistributionAffinity;
import org.apache.drill.exec.planner.physical.HasDistributionAffinity;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.visitor.PrelVisitor;
import org.apache.drill.exec.record.BatchSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectScanPrel
extends AbstractRelNode
implements Prel,
HasDistributionAffinity {
    static final Logger logger = LoggerFactory.getLogger(DirectScanPrel.class);
    private final GroupScan groupScan;
    private final RelDataType rowType;

    DirectScanPrel(RelOptCluster cluster, RelTraitSet traits, GroupScan groupScan, RelDataType rowType) {
        super(cluster, traits);
        this.groupScan = groupScan;
        this.rowType = rowType;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DirectScanPrel(this.getCluster(), traitSet, this.getGroupScan(), this.rowType);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new DirectScanPrel(this.getCluster(), this.getTraitSet(), DirectScanPrel.getCopy(this.getGroupScan()), this.rowType);
    }

    private static GroupScan getCopy(GroupScan scan) {
        try {
            return (GroupScan)scan.getNewWithChildren(Collections.emptyList());
        }
        catch (ExecutionSetupException e) {
            throw new DrillRuntimeException("Unexpected failure while coping node.", e);
        }
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        return creator.addMetadata(this, this.getGroupScan());
    }

    public GroupScan getGroupScan() {
        return this.groupScan;
    }

    @Override
    public boolean needsFinalColumnReordering() {
        return false;
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.DEFAULT;
    }

    @Override
    public DistributionAffinity getDistributionAffinity() {
        return this.getGroupScan().getDistributionAffinity();
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PrelVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitPrel(this, value);
    }

    @Override
    public Iterator<Prel> iterator() {
        return Collections.emptyIterator();
    }

    public static DirectScanPrel create(RelNode old, RelTraitSet traitSets, GroupScan scan, RelDataType rowType) {
        return new DirectScanPrel(old.getCluster(), traitSets, DirectScanPrel.getCopy(scan), rowType);
    }

    public RelDataType deriveRowType() {
        return this.rowType;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("groupscan", (Object)this.getGroupScan().getDigest());
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        PlannerSettings settings = PrelUtil.getPlannerSettings(this.getCluster());
        double rowCount = this.getGroupScan().getScanStats(settings).getRecordCount();
        logger.debug("#{}.estimateRowCount get rowCount {} from  groupscan {}", new Object[]{this.getId(), rowCount, System.identityHashCode(this.getGroupScan())});
        return rowCount;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        PlannerSettings settings = PrelUtil.getPlannerSettings(planner);
        ScanStats stats = this.getGroupScan().getScanStats(settings);
        int columnCount = this.getRowType().getFieldCount();
        if (PrelUtil.getSettings(this.getCluster()).useDefaultCosting()) {
            return planner.getCostFactory().makeCost(stats.getRecordCount() * (double)columnCount, stats.getCpuCost(), stats.getDiskCost());
        }
        double rowCount = stats.getRecordCount();
        double cpuCost = rowCount * (double)Math.max(columnCount, 1);
        if (stats.getCpuCost() > 0.0) {
            cpuCost *= stats.getCpuCost();
        }
        double ioCost = stats.getDiskCost();
        DrillCostBase.DrillCostFactory costFactory = (DrillCostBase.DrillCostFactory)planner.getCostFactory();
        return costFactory.makeCost(rowCount, cpuCost, ioCost, 0.0);
    }
}

