/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.drill.exec.planner.physical.DrillDistributionTraitDef;
import org.apache.drill.exec.planner.physical.PartitionFunction;

public class DrillDistributionTrait
implements RelTrait {
    public static DrillDistributionTrait SINGLETON = new DrillDistributionTrait(DistributionType.SINGLETON);
    public static DrillDistributionTrait RANDOM_DISTRIBUTED = new DrillDistributionTrait(DistributionType.RANDOM_DISTRIBUTED);
    public static DrillDistributionTrait ANY;
    public static DrillDistributionTrait DEFAULT;
    private final DistributionType type;
    private final List<DistributionField> fields;
    private PartitionFunction partitionFunction;

    public DrillDistributionTrait(DistributionType type) {
        assert (type == DistributionType.SINGLETON || type == DistributionType.RANDOM_DISTRIBUTED || type == DistributionType.ANY || type == DistributionType.ROUND_ROBIN_DISTRIBUTED || type == DistributionType.BROADCAST_DISTRIBUTED);
        this.type = type;
        this.fields = Collections.emptyList();
    }

    public DrillDistributionTrait(DistributionType type, List<DistributionField> fields) {
        assert (type == DistributionType.HASH_DISTRIBUTED || type == DistributionType.RANGE_DISTRIBUTED);
        this.type = type;
        this.fields = fields;
    }

    public DrillDistributionTrait(DistributionType type, List<DistributionField> fields, PartitionFunction partitionFunction) {
        assert (type == DistributionType.HASH_DISTRIBUTED || type == DistributionType.RANGE_DISTRIBUTED);
        this.type = type;
        this.fields = fields;
        this.partitionFunction = partitionFunction;
    }

    public void register(RelOptPlanner planner) {
    }

    public boolean satisfies(RelTrait trait) {
        if (trait instanceof DrillDistributionTrait) {
            DistributionType requiredDist = ((DrillDistributionTrait)trait).getType();
            if (requiredDist == DistributionType.ANY) {
                return true;
            }
            if (this.type == DistributionType.HASH_DISTRIBUTED) {
                if (requiredDist == DistributionType.HASH_DISTRIBUTED) {
                    return this.equals(trait);
                }
                if (requiredDist == DistributionType.RANDOM_DISTRIBUTED) {
                    return true;
                }
            }
            if (this.type == DistributionType.RANGE_DISTRIBUTED && requiredDist == DistributionType.RANDOM_DISTRIBUTED) {
                return true;
            }
        }
        return this.equals(trait);
    }

    public RelTraitDef<DrillDistributionTrait> getTraitDef() {
        return DrillDistributionTraitDef.INSTANCE;
    }

    public DistributionType getType() {
        return this.type;
    }

    public List<DistributionField> getFields() {
        return this.fields;
    }

    public PartitionFunction getPartitionFunction() {
        return this.partitionFunction;
    }

    private boolean arePartitionFunctionsSame(PartitionFunction f1, PartitionFunction f2) {
        return Objects.equals(f1, f2);
    }

    public int hashCode() {
        return this.fields == null ? this.type.hashCode() : this.type.hashCode() | this.fields.hashCode() << 4;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DrillDistributionTrait) {
            DrillDistributionTrait that = (DrillDistributionTrait)obj;
            return this.type == that.type && this.fields.equals(that.fields) && this.arePartitionFunctionsSame(this.partitionFunction, that.partitionFunction);
        }
        return false;
    }

    public String toString() {
        return this.fields == null ? this.type.toString() : this.type.toString() + "(" + this.fields + ")";
    }

    static {
        DEFAULT = ANY = new DrillDistributionTrait(DistributionType.ANY);
    }

    public static enum DistributionType {
        SINGLETON,
        HASH_DISTRIBUTED,
        RANGE_DISTRIBUTED,
        RANDOM_DISTRIBUTED,
        ROUND_ROBIN_DISTRIBUTED,
        BROADCAST_DISTRIBUTED,
        ANY;

    }

    public static class NamedDistributionField
    extends DistributionField {
        private final String fieldName;

        public NamedDistributionField(int fieldId, String fieldName) {
            super(fieldId);
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            NamedDistributionField that = (NamedDistributionField)o;
            return Objects.equals(this.fieldName, that.fieldName);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.fieldName);
        }

        @Override
        public String toString() {
            return String.format("%s(%s)", this.fieldName, this.getFieldId());
        }
    }

    public static class DistributionField {
        private final int fieldId;

        public DistributionField(int fieldId) {
            this.fieldId = fieldId;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DistributionField)) {
                return false;
            }
            DistributionField other = (DistributionField)obj;
            return this.fieldId == other.fieldId;
        }

        public int hashCode() {
            return this.fieldId;
        }

        public int getFieldId() {
            return this.fieldId;
        }

        public String toString() {
            return String.format("[$%s]", this.fieldId);
        }
    }
}

