/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.drill.exec.planner.logical.DrillAggregateRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.AggPrelBase;
import org.apache.drill.exec.planner.physical.AggPruleBase;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.DrillDistributionTraitDef;
import org.apache.drill.exec.planner.physical.HashAggPrel;
import org.apache.drill.exec.planner.physical.HashToRandomExchangePrel;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.SubsetTransformer;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;

public class HashAggPrule
extends AggPruleBase {
    public static final RelOptRule INSTANCE = new HashAggPrule();
    protected static final Logger tracer = CalciteTrace.getPlannerTracer();

    private HashAggPrule() {
        super(RelOptHelper.some(DrillAggregateRel.class, RelOptHelper.any(RelNode.class), new RelOptRuleOperand[0]), "HashAggPrule");
    }

    public boolean matches(RelOptRuleCall call) {
        PlannerSettings settings = PrelUtil.getPlannerSettings(call.getPlanner());
        return settings.isMemoryEstimationEnabled() || settings.isHashAggEnabled();
    }

    public void onMatch(RelOptRuleCall call) {
        if (!PrelUtil.getPlannerSettings(call.getPlanner()).isHashAggEnabled()) {
            return;
        }
        DrillAggregateRel aggregate = (DrillAggregateRel)call.rel(0);
        RelNode input = call.rel(1);
        if (aggregate.containsDistinctCall() || aggregate.getGroupCount() == 0) {
            return;
        }
        try {
            if (aggregate.getGroupSet().isEmpty()) {
                DrillDistributionTrait singleDist = DrillDistributionTrait.SINGLETON;
                RelTraitSet traits = call.getPlanner().emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)singleDist);
                this.createTransformRequest(call, aggregate, input, traits);
            } else {
                DrillDistributionTrait distOnAllKeys = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(this.getDistributionField(aggregate, true)));
                RelTraitSet traits = call.getPlanner().emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)distOnAllKeys);
                this.createTransformRequest(call, aggregate, input, traits);
                DrillDistributionTrait distOnOneKey = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(this.getDistributionField(aggregate, false)));
                traits = call.getPlanner().emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)distOnOneKey);
                this.createTransformRequest(call, aggregate, input, traits);
                if (this.create2PhasePlan(call, aggregate)) {
                    traits = call.getPlanner().emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL);
                    RelNode convertedInput = HashAggPrule.convert(input, traits);
                    new TwoPhaseSubset(call, distOnAllKeys).go(aggregate, convertedInput);
                }
            }
        }
        catch (InvalidRelException e) {
            tracer.warn(e.toString());
        }
    }

    private void createTransformRequest(RelOptRuleCall call, DrillAggregateRel aggregate, RelNode input, RelTraitSet traits) throws InvalidRelException {
        RelNode convertedInput = HashAggPrule.convert(input, PrelUtil.fixTraits(call, traits));
        HashAggPrel newAgg = new HashAggPrel(aggregate.getCluster(), traits, convertedInput, aggregate.getGroupSet(), aggregate.getGroupSets(), aggregate.getAggCallList(), AggPrelBase.OperatorPhase.PHASE_1of1);
        call.transformTo((RelNode)newAgg);
    }

    private class TwoPhaseSubset
    extends SubsetTransformer<DrillAggregateRel, InvalidRelException> {
        final RelTrait distOnAllKeys;

        public TwoPhaseSubset(RelOptRuleCall call, RelTrait distOnAllKeys) {
            super(call);
            this.distOnAllKeys = distOnAllKeys;
        }

        @Override
        public RelNode convertChild(DrillAggregateRel aggregate, RelNode input) throws InvalidRelException {
            RelTraitSet traits = this.newTraitSet(new RelTrait[]{Prel.DRILL_PHYSICAL, input.getTraitSet().getTrait((RelTraitDef)DrillDistributionTraitDef.INSTANCE)});
            RelNode newInput = Prule.convert(input, traits);
            HashAggPrel phase1Agg = new HashAggPrel(aggregate.getCluster(), traits, newInput, aggregate.getGroupSet(), aggregate.getGroupSets(), aggregate.getAggCallList(), AggPrelBase.OperatorPhase.PHASE_1of2);
            HashToRandomExchangePrel exch = new HashToRandomExchangePrel(phase1Agg.getCluster(), phase1Agg.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus(this.distOnAllKeys), phase1Agg, ImmutableList.copyOf(HashAggPrule.this.getDistributionField(aggregate, true)));
            ImmutableBitSet newGroupSet = AggPruleBase.remapGroupSet(aggregate.getGroupSet());
            ArrayList<ImmutableBitSet> newGroupSets = Lists.newArrayList();
            for (ImmutableBitSet groupSet : aggregate.getGroupSets()) {
                newGroupSets.add(AggPruleBase.remapGroupSet(groupSet));
            }
            return new HashAggPrel(aggregate.getCluster(), exch.getTraitSet(), exch, newGroupSet, newGroupSets, phase1Agg.getPhase2AggCalls(), AggPrelBase.OperatorPhase.PHASE_2of2);
        }
    }
}

