/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.drill.exec.planner.logical.DrillJoin;
import org.apache.drill.exec.planner.logical.DrillJoinRel;
import org.apache.drill.exec.planner.logical.DrillSemiJoinRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.JoinPruleBase;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.slf4j.Logger;

public class HashJoinPrule
extends JoinPruleBase {
    public static final RelOptRule DIST_INSTANCE = new HashJoinPrule("Prel.HashJoinDistPrule", RelOptHelper.any(DrillJoinRel.class), true);
    public static final RelOptRule BROADCAST_INSTANCE = new HashJoinPrule("Prel.HashJoinBroadcastPrule", RelOptHelper.any(DrillJoinRel.class), false);
    public static final RelOptRule SEMI_DIST_INSTANCE = new HashJoinPrule("Prel.HashSemiJoinDistPrule", RelOptHelper.any(DrillSemiJoinRel.class), true);
    public static final RelOptRule SEMI_BROADCAST_INSTANCE = new HashJoinPrule("Prel.HashSemiJoinBroadcastPrule", RelOptHelper.any(DrillSemiJoinRel.class), false);
    protected static final Logger tracer = CalciteTrace.getPlannerTracer();
    private final boolean isDist;
    private boolean isSemi = false;

    private HashJoinPrule(String name, RelOptRuleOperand operand, boolean isDist) {
        super(operand, name);
        this.isDist = isDist;
    }

    public boolean matches(RelOptRuleCall call) {
        PlannerSettings settings = PrelUtil.getPlannerSettings(call.getPlanner());
        this.isSemi = call.rel(0) instanceof DrillSemiJoinRel;
        return settings.isMemoryEstimationEnabled() || settings.isHashJoinEnabled();
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode right;
        RelNode left;
        PlannerSettings settings = PrelUtil.getPlannerSettings(call.getPlanner());
        if (!settings.isHashJoinEnabled() || this.isSemi && !settings.isSemiJoinEnabled()) {
            return;
        }
        DrillJoin join = (DrillJoin)call.rel(0);
        if (!this.checkPreconditions(join, left = join.getLeft(), right = join.getRight(), settings)) {
            return;
        }
        boolean hashSingleKey = PrelUtil.getPlannerSettings(call.getPlanner()).isHashSingleKey();
        try {
            if (this.isDist) {
                this.createDistBothPlan(call, join, JoinPruleBase.PhysicalJoinType.HASH_JOIN, left, right, null, null, hashSingleKey);
            } else if (this.checkBroadcastConditions(call.getPlanner(), join, left, right)) {
                this.createBroadcastPlan(call, join, join.getCondition(), JoinPruleBase.PhysicalJoinType.HASH_JOIN, left, right, null, null);
            }
        }
        catch (InvalidRelException e) {
            tracer.warn(e.toString());
        }
    }
}

