/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.sql.DrillSqlOperator;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;

public class HashPrelUtil {
    public static final String HASH_EXPR_NAME = "E_X_P_R_H_A_S_H_F_I_E_L_D";
    public static final int DIST_SEED = 1301011;
    public static HashExpressionCreatorHelper<LogicalExpression> HASH_HELPER_LOGICAL_EXPRESSION = (funcName, inputFiled) -> new FunctionCall(funcName, inputFiled, ExpressionPosition.UNKNOWN);
    private static final String HASH32_FUNCTION_NAME = "hash32";
    private static final String HASH32_DOUBLE_FUNCTION_NAME = "hash32AsDouble";
    private static final String HASH64_DOUBLE_FUNCTION_NAME = "hash64AsDouble";

    public static <T> T createHashBasedPartitionExpression(List<T> distFields, T seed, HashExpressionCreatorHelper<T> helper) {
        return HashPrelUtil.createHashExpression(distFields, seed, helper, true);
    }

    public static <T> T createHashExpression(List<T> inputExprs, T seed, HashExpressionCreatorHelper<T> helper, boolean hashAsDouble) {
        assert (inputExprs.size() > 0);
        String functionName = hashAsDouble ? HASH32_DOUBLE_FUNCTION_NAME : HASH32_FUNCTION_NAME;
        T func = helper.createCall(functionName, ImmutableList.of(inputExprs.get(0), seed));
        for (int i = 1; i < inputExprs.size(); ++i) {
            func = helper.createCall(functionName, ImmutableList.of(inputExprs.get(i), func));
        }
        return func;
    }

    public static <T> T createHash64Expression(List<T> inputExprs, T seed, HashExpressionCreatorHelper<T> helper, boolean hashAsDouble) {
        Preconditions.checkArgument(inputExprs.size() > 0);
        String functionName = hashAsDouble ? HASH64_DOUBLE_FUNCTION_NAME : HASH32_FUNCTION_NAME;
        T func = helper.createCall(functionName, ImmutableList.of(inputExprs.get(0), seed));
        for (int i = 1; i < inputExprs.size(); ++i) {
            func = helper.createCall(functionName, ImmutableList.of(inputExprs.get(i), func));
        }
        return func;
    }

    public static LogicalExpression getHash64Expression(LogicalExpression field, LogicalExpression seed, boolean hashAsDouble) {
        return HashPrelUtil.createHash64Expression(ImmutableList.of(field), seed, HASH_HELPER_LOGICAL_EXPRESSION, hashAsDouble);
    }

    public static LogicalExpression getHashExpression(LogicalExpression field, LogicalExpression seed, boolean hashAsDouble) {
        return HashPrelUtil.createHashExpression(ImmutableList.of(field), seed, HASH_HELPER_LOGICAL_EXPRESSION, hashAsDouble);
    }

    public static LogicalExpression getHashExpression(List<DrillDistributionTrait.DistributionField> fields, RelDataType rowType) {
        assert (fields.size() > 0);
        List childFields = rowType.getFieldNames();
        if (childFields.contains(HASH_EXPR_NAME)) {
            return new FieldReference(HASH_EXPR_NAME);
        }
        ArrayList<FieldReference> expressions = new ArrayList<FieldReference>();
        for (DrillDistributionTrait.DistributionField field : fields) {
            if (field instanceof DrillDistributionTrait.NamedDistributionField) {
                DrillDistributionTrait.NamedDistributionField namedDistributionField = (DrillDistributionTrait.NamedDistributionField)field;
                expressions.add(new FieldReference((CharSequence)namedDistributionField.getFieldName(), ExpressionPosition.UNKNOWN));
                continue;
            }
            expressions.add(new FieldReference((CharSequence)childFields.get(field.getFieldId()), ExpressionPosition.UNKNOWN));
        }
        LogicalExpression distSeed = ValueExpressions.getInt(1301011);
        return HashPrelUtil.createHashBasedPartitionExpression(expressions, distSeed, HASH_HELPER_LOGICAL_EXPRESSION);
    }

    public static interface HashExpressionCreatorHelper<T> {
        public T createCall(String var1, List<T> var2);
    }

    public static class RexNodeBasedHashExpressionCreatorHelper
    implements HashExpressionCreatorHelper<RexNode> {
        private final RexBuilder rexBuilder;

        public RexNodeBasedHashExpressionCreatorHelper(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        @Override
        public RexNode createCall(String funcName, List<RexNode> inputFields) {
            DrillSqlOperator op = new DrillSqlOperator(funcName, inputFields.size(), true, false);
            return this.rexBuilder.makeCall((SqlOperator)op, inputFields);
        }
    }
}

