/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.exec.physical.base.DbGroupScan;
import org.apache.drill.exec.physical.impl.join.JoinUtils;
import org.apache.drill.exec.planner.common.DrillScanRelBase;
import org.apache.drill.exec.planner.logical.DrillJoin;
import org.apache.drill.exec.planner.logical.DrillPushRowKeyJoinToScanRule;
import org.apache.drill.exec.planner.logical.RowKeyJoinRel;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.DrillDistributionTraitDef;
import org.apache.drill.exec.planner.physical.HashJoinPrel;
import org.apache.drill.exec.planner.physical.JoinPrel;
import org.apache.drill.exec.planner.physical.MergeJoinPrel;
import org.apache.drill.exec.planner.physical.NestedLoopJoinPrel;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.RowKeyJoinPrel;
import org.apache.drill.exec.planner.physical.SubsetTransformer;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public abstract class JoinPruleBase
extends Prule {
    protected JoinPruleBase(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    protected boolean checkPreconditions(DrillJoin join, RelNode left, RelNode right, PlannerSettings settings) {
        ArrayList<Integer> leftKeys = Lists.newArrayList();
        ArrayList<Integer> rightKeys = Lists.newArrayList();
        ArrayList<Boolean> filterNulls = Lists.newArrayList();
        JoinUtils.JoinCategory category = JoinUtils.getJoinCategory(left, right, join.getCondition(), leftKeys, rightKeys, filterNulls);
        return category != JoinUtils.JoinCategory.CARTESIAN && category != JoinUtils.JoinCategory.INEQUALITY;
    }

    protected List<DrillDistributionTrait.DistributionField> getDistributionField(List<Integer> keys) {
        ArrayList<DrillDistributionTrait.DistributionField> distFields = Lists.newArrayList();
        for (int key : keys) {
            distFields.add(new DrillDistributionTrait.DistributionField(key));
        }
        return distFields;
    }

    protected boolean checkBroadcastConditions(RelOptPlanner planner, DrillJoin join, RelNode left, RelNode right) {
        double estimatedRightRowCount = RelMetadataQuery.instance().getRowCount(right);
        return estimatedRightRowCount < (double)PrelUtil.getSettings(join.getCluster()).getBroadcastThreshold() && !((DrillDistributionTrait)left.getTraitSet().getTrait((RelTraitDef)DrillDistributionTraitDef.INSTANCE)).equals(DrillDistributionTrait.SINGLETON) && (join.getJoinType() == JoinRelType.INNER || join.getJoinType() == JoinRelType.LEFT);
    }

    protected void createRangePartitionRightPlan(RelOptRuleCall call, RowKeyJoinRel join, PhysicalJoinType physicalJoinType, boolean implementAsRowKeyJoin, RelNode left, RelNode right, RelCollation collationLeft, RelCollation collationRight) throws InvalidRelException {
        assert (join.getRightKeys().size() == 1) : "Cannot create range partition plan with multi-column join condition";
        int joinKeyRight = join.getRightKeys().get(0);
        ArrayList<DrillDistributionTrait.DistributionField> rangeDistFields = Lists.newArrayList(new DrillDistributionTrait.DistributionField(joinKeyRight));
        ArrayList<FieldReference> rangeDistRefList = Lists.newArrayList();
        FieldReference rangeDistRef = FieldReference.getWithQuotedRef(((RelDataTypeField)right.getRowType().getFieldList().get(joinKeyRight)).getName());
        rangeDistRefList.add(rangeDistRef);
        RelNode leftScan = DrillPushRowKeyJoinToScanRule.getValidJoinInput(left);
        DrillDistributionTrait rangePartRight = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.RANGE_DISTRIBUTED, ImmutableList.copyOf(rangeDistFields), ((DbGroupScan)((DrillScanRelBase)leftScan).getGroupScan()).getRangePartitionFunction(rangeDistRefList));
        RelTraitSet traitsLeft = null;
        RelTraitSet traitsRight = null;
        if (physicalJoinType == PhysicalJoinType.HASH_JOIN) {
            traitsLeft = left.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL);
            traitsRight = right.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)rangePartRight);
        }
        RelNode convertedLeft = JoinPruleBase.convert(left, traitsLeft);
        RelNode convertedRight = JoinPruleBase.convert(right, traitsRight);
        JoinPrel newJoin = null;
        if (physicalJoinType == PhysicalJoinType.HASH_JOIN) {
            newJoin = implementAsRowKeyJoin ? new RowKeyJoinPrel(join.getCluster(), traitsLeft, convertedLeft, convertedRight, join.getCondition(), join.getJoinType(), join.isSemiJoin()) : new HashJoinPrel(join.getCluster(), traitsLeft, convertedLeft, convertedRight, join.getCondition(), join.getJoinType(), false, null, true, 0, join.isSemiJoin());
        }
        if (newJoin != null) {
            call.transformTo(newJoin);
        }
    }

    protected void createDistBothPlan(RelOptRuleCall call, DrillJoin join, PhysicalJoinType physicalJoinType, RelNode left, RelNode right, RelCollation collationLeft, RelCollation collationRight, boolean hashSingleKey) throws InvalidRelException {
        DrillDistributionTrait hashLeftPartition = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(this.getDistributionField(join.getLeftKeys())));
        DrillDistributionTrait hashRightPartition = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(this.getDistributionField(join.getRightKeys())));
        this.createDistBothPlan(call, join, physicalJoinType, left, right, collationLeft, collationRight, hashLeftPartition, hashRightPartition);
        assert (join.getLeftKeys().size() == join.getRightKeys().size());
        if (!hashSingleKey) {
            return;
        }
        int numJoinKeys = join.getLeftKeys().size();
        if (numJoinKeys > 1) {
            for (int i = 0; i < numJoinKeys; ++i) {
                hashLeftPartition = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(this.getDistributionField(join.getLeftKeys().subList(i, i + 1))));
                hashRightPartition = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(this.getDistributionField(join.getRightKeys().subList(i, i + 1))));
                this.createDistBothPlan(call, join, physicalJoinType, left, right, collationLeft, collationRight, hashLeftPartition, hashRightPartition);
            }
        }
    }

    private void createDistBothPlan(RelOptRuleCall call, DrillJoin join, PhysicalJoinType physicalJoinType, RelNode left, RelNode right, RelCollation collationLeft, RelCollation collationRight, DrillDistributionTrait hashLeftPartition, DrillDistributionTrait hashRightPartition) throws InvalidRelException {
        RelTraitSet traitsLeft = null;
        RelTraitSet traitsRight = null;
        if (physicalJoinType == PhysicalJoinType.MERGE_JOIN) {
            assert (collationLeft != null && collationRight != null);
            traitsLeft = left.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)collationLeft).plus((RelTrait)hashLeftPartition);
            traitsRight = right.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)collationRight).plus((RelTrait)hashRightPartition);
        } else if (physicalJoinType == PhysicalJoinType.HASH_JOIN) {
            traitsLeft = left.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)hashLeftPartition);
            traitsRight = right.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)hashRightPartition);
        }
        RelNode convertedLeft = JoinPruleBase.convert(left, traitsLeft);
        RelNode convertedRight = JoinPruleBase.convert(right, traitsRight);
        JoinPrel newJoin = null;
        if (physicalJoinType == PhysicalJoinType.HASH_JOIN) {
            RelTraitSet traitSet = PrelUtil.removeCollation(traitsLeft, call);
            newJoin = new HashJoinPrel(join.getCluster(), traitSet, convertedLeft, convertedRight, join.getCondition(), join.getJoinType(), join.isSemiJoin());
        } else if (physicalJoinType == PhysicalJoinType.MERGE_JOIN) {
            newJoin = new MergeJoinPrel(join.getCluster(), traitsLeft, convertedLeft, convertedRight, join.getCondition(), join.getJoinType(), join.isSemiJoin());
        }
        call.transformTo(newJoin);
    }

    protected void createBroadcastPlan(RelOptRuleCall call, DrillJoin join, final RexNode joinCondition, PhysicalJoinType physicalJoinType, final RelNode left, RelNode right, final RelCollation collationLeft, RelCollation collationRight) throws InvalidRelException {
        DrillDistributionTrait distBroadcastRight = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.BROADCAST_DISTRIBUTED);
        RelTraitSet traitsRight = null;
        RelTraitSet traitsLeft = left.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL);
        if (physicalJoinType == PhysicalJoinType.MERGE_JOIN) {
            assert (collationLeft != null && collationRight != null);
            traitsLeft = traitsLeft.plus((RelTrait)collationLeft);
            traitsRight = right.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)collationRight).plus((RelTrait)distBroadcastRight);
        } else if (physicalJoinType == PhysicalJoinType.HASH_JOIN || physicalJoinType == PhysicalJoinType.NESTEDLOOP_JOIN) {
            traitsRight = right.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)distBroadcastRight);
        }
        RelNode convertedLeft = JoinPruleBase.convert(left, traitsLeft);
        final RelNode convertedRight = JoinPruleBase.convert(right, traitsRight);
        boolean traitProp = false;
        if (traitProp) {
            if (physicalJoinType == PhysicalJoinType.MERGE_JOIN) {
                new SubsetTransformer<DrillJoin, InvalidRelException>(call){

                    @Override
                    public RelNode convertChild(DrillJoin join, RelNode rel) throws InvalidRelException {
                        DrillDistributionTrait toDist = (DrillDistributionTrait)rel.getTraitSet().getTrait((RelTraitDef)DrillDistributionTraitDef.INSTANCE);
                        RelTraitSet newTraitsLeft = this.newTraitSet(new RelTrait[]{Prel.DRILL_PHYSICAL, collationLeft, toDist});
                        RelNode newLeft = Prule.convert(left, newTraitsLeft);
                        return new MergeJoinPrel(join.getCluster(), newTraitsLeft, newLeft, convertedRight, joinCondition, join.getJoinType());
                    }
                }.go(join, convertedLeft);
            } else if (physicalJoinType == PhysicalJoinType.HASH_JOIN) {
                new SubsetTransformer<DrillJoin, InvalidRelException>(call){

                    @Override
                    public RelNode convertChild(DrillJoin join, RelNode rel) throws InvalidRelException {
                        DrillDistributionTrait toDist = (DrillDistributionTrait)rel.getTraitSet().getTrait((RelTraitDef)DrillDistributionTraitDef.INSTANCE);
                        RelTraitSet newTraitsLeft = this.newTraitSet(new RelTrait[]{Prel.DRILL_PHYSICAL, toDist});
                        RelNode newLeft = Prule.convert(left, newTraitsLeft);
                        return new HashJoinPrel(join.getCluster(), newTraitsLeft, newLeft, convertedRight, joinCondition, join.getJoinType(), join.isSemiJoin());
                    }
                }.go(join, convertedLeft);
            } else if (physicalJoinType == PhysicalJoinType.NESTEDLOOP_JOIN) {
                new SubsetTransformer<DrillJoin, InvalidRelException>(call){

                    @Override
                    public RelNode convertChild(DrillJoin join, RelNode rel) throws InvalidRelException {
                        DrillDistributionTrait toDist = (DrillDistributionTrait)rel.getTraitSet().getTrait((RelTraitDef)DrillDistributionTraitDef.INSTANCE);
                        RelTraitSet newTraitsLeft = this.newTraitSet(new RelTrait[]{Prel.DRILL_PHYSICAL, toDist});
                        RelNode newLeft = Prule.convert(left, newTraitsLeft);
                        return new NestedLoopJoinPrel(join.getCluster(), newTraitsLeft, newLeft, convertedRight, joinCondition, join.getJoinType());
                    }
                }.go(join, convertedLeft);
            }
        } else if (physicalJoinType == PhysicalJoinType.MERGE_JOIN) {
            call.transformTo((RelNode)new MergeJoinPrel(join.getCluster(), convertedLeft.getTraitSet(), convertedLeft, convertedRight, joinCondition, join.getJoinType(), join.isSemiJoin()));
        } else if (physicalJoinType == PhysicalJoinType.HASH_JOIN) {
            RelTraitSet traitSet = PrelUtil.removeCollation(convertedLeft.getTraitSet(), call);
            call.transformTo((RelNode)new HashJoinPrel(join.getCluster(), traitSet, convertedLeft, convertedRight, joinCondition, join.getJoinType(), join.isSemiJoin()));
        } else if (physicalJoinType == PhysicalJoinType.NESTEDLOOP_JOIN) {
            call.transformTo((RelNode)new NestedLoopJoinPrel(join.getCluster(), convertedLeft.getTraitSet(), convertedLeft, convertedRight, joinCondition, join.getJoinType()));
        }
    }

    protected static enum PhysicalJoinType {
        HASH_JOIN,
        MERGE_JOIN,
        NESTEDLOOP_JOIN;

    }
}

