/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.commons.collections.ListUtils;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.LateralJoinPOP;
import org.apache.drill.exec.planner.common.DrillJoinRelBase;
import org.apache.drill.exec.planner.common.DrillLateralJoinRelBase;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.visitor.PrelVisitor;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class LateralJoinPrel
extends DrillLateralJoinRelBase
implements Prel {
    protected LateralJoinPrel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, boolean excludeCorrelateCol, CorrelationId correlationId, ImmutableBitSet requiredColumns, JoinRelType semiJoinType) {
        super(cluster, traits, left, right, excludeCorrelateCol, correlationId, requiredColumns, semiJoinType);
    }

    public Correlate copy(RelTraitSet traitSet, RelNode left, RelNode right, CorrelationId correlationId, ImmutableBitSet requiredColumns, JoinRelType joinType) {
        return new LateralJoinPrel(this.getCluster(), this.getTraitSet(), left, right, this.excludeCorrelateColumn, correlationId, requiredColumns, this.getJoinType());
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        PhysicalOperator leftPop = ((Prel)this.left).getPhysicalOperator(creator);
        PhysicalOperator rightPop = ((Prel)this.right).getPhysicalOperator(creator);
        JoinRelType jtype = this.getJoinType();
        ArrayList<SchemaPath> excludedColumns = new ArrayList<SchemaPath>();
        if (this.getColumn() != null) {
            excludedColumns.add(this.getColumn());
        }
        LateralJoinPOP ljoin = new LateralJoinPOP(leftPop, rightPop, jtype, "$drill_implicit_field$", excludedColumns);
        return creator.addMetadata(this, ljoin);
    }

    private SchemaPath getColumn() {
        if (this.excludeCorrelateColumn) {
            int index = (Integer)this.getRequiredColumns().asList().get(0);
            return SchemaPath.getSimplePath((String)this.getInput(0).getRowType().getFieldNames().get(index));
        }
        return null;
    }

    public RelNode getLateralInput(int ordinal, RelNode input) {
        int offset = ordinal == 0 ? 0 : this.getInputSize(0);
        Preconditions.checkArgument(DrillJoinRelBase.uniqueFieldNames(input.getRowType()));
        List fields = this.getRowType().getFieldNames();
        List inputFields = input.getRowType().getFieldNames();
        List<String> outputFields = fields.subList(offset, offset + this.getInputSize(ordinal));
        if (ListUtils.subtract(outputFields, (List)inputFields).size() != 0) {
            return this.rename(input, input.getRowType().getFieldList(), outputFields);
        }
        return input;
    }

    private RelNode rename(RelNode input, List<RelDataTypeField> inputFields, List<String> outputFieldNames) {
        ArrayList<RexNode> exprs = Lists.newArrayList();
        for (RelDataTypeField field : inputFields) {
            RexInputRef expr = input.getCluster().getRexBuilder().makeInputRef(field.getType(), field.getIndex());
            exprs.add((RexNode)expr);
        }
        RelDataType rowType = RexUtil.createStructType((RelDataTypeFactory)input.getCluster().getTypeFactory(), exprs, outputFieldNames, null);
        ProjectPrel proj = new ProjectPrel(input.getCluster(), input.getTraitSet(), input, exprs, rowType);
        return proj;
    }

    public RelWriter explainTerms(RelWriter pw) {
        if (this.excludeCorrelateColumn) {
            return super.explainTerms(pw).item("column excluded from output: ", (Object)this.getColumn());
        }
        return super.explainTerms(pw);
    }

    @Override
    public <T, X, E extends Throwable> T accept(PrelVisitor<T, X, E> visitor, X value) throws E {
        return visitor.visitLateral(this, value);
    }

    @Override
    public Iterator<Prel> iterator() {
        return PrelUtil.iter(this.getLeft(), this.getRight());
    }

    @Override
    public boolean needsFinalColumnReordering() {
        return true;
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.DEFAULT;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }
}

