/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.math.BigDecimal;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.ExchangePrel;
import org.apache.drill.exec.planner.physical.LimitPrel;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.RowKeyJoinPrel;
import org.apache.drill.exec.planner.physical.SingleMergeExchangePrel;
import org.apache.drill.exec.planner.physical.UnionExchangePrel;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;

public class LimitExchangeTransposeRule
extends Prule {
    public static final RelOptRule INSTANCE = new LimitExchangeTransposeRule();

    private boolean findRowKeyJoin(RelNode rel) {
        if (rel instanceof RowKeyJoinPrel) {
            return true;
        }
        if (rel instanceof RelSubset) {
            if (((RelSubset)rel).getBest() != null ? this.findRowKeyJoin(((RelSubset)rel).getBest()) : ((RelSubset)rel).getOriginal() != null && this.findRowKeyJoin(((RelSubset)rel).getOriginal())) {
                return true;
            }
        } else if (rel instanceof HepRelVertex) {
            if (((HepRelVertex)rel).getCurrentRel() != null && this.findRowKeyJoin(((HepRelVertex)rel).getCurrentRel())) {
                return true;
            }
        } else {
            for (RelNode child : rel.getInputs()) {
                if (!this.findRowKeyJoin(child)) continue;
                return true;
            }
        }
        return false;
    }

    private LimitExchangeTransposeRule() {
        super(RelOptHelper.some(LimitPrel.class, RelOptHelper.any(ExchangePrel.class), new RelOptRuleOperand[0]), "LimitExchangeTransposeRule");
    }

    public boolean matches(RelOptRuleCall call) {
        LimitPrel limit = (LimitPrel)call.rel(0);
        ExchangePrel exchange = (ExchangePrel)call.rel(1);
        if (!(exchange instanceof UnionExchangePrel) && !(exchange instanceof SingleMergeExchangePrel)) {
            return false;
        }
        return !limit.isPushDown() && limit.getFetch() != null && (!(exchange instanceof SingleMergeExchangePrel) || !this.findRowKeyJoin(exchange));
    }

    public void onMatch(RelOptRuleCall call) {
        LimitPrel limit = (LimitPrel)call.rel(0);
        ExchangePrel exchangePrel = (ExchangePrel)call.rel(1);
        RelNode child = exchangePrel.getInput();
        int offset = limit.getOffset() != null ? Math.max(0, RexLiteral.intValue((RexNode)limit.getOffset())) : 0;
        int fetch = Math.max(0, RexLiteral.intValue((RexNode)limit.getFetch()));
        RexLiteral childFetch = limit.getCluster().getRexBuilder().makeExactLiteral(BigDecimal.valueOf(offset + fetch));
        LimitPrel limitUnderExchange = new LimitPrel(child.getCluster(), child.getTraitSet(), child, null, (RexNode)childFetch);
        RelNode newExch = exchangePrel.copy(exchangePrel.getTraitSet(), ImmutableList.of(limitUnderExchange));
        LimitPrel limitAboveExchange = new LimitPrel(limit.getCluster(), limit.getTraitSet(), newExch, limit.getOffset(), limit.getFetch(), true);
        call.transformTo((RelNode)limitAboveExchange);
    }
}

