/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.drill.exec.planner.logical.DrillJoinRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.JoinPruleBase;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;

public class MergeJoinPrule
extends JoinPruleBase {
    public static final RelOptRule DIST_INSTANCE = new MergeJoinPrule("Prel.MergeJoinDistPrule", RelOptHelper.any(DrillJoinRel.class), true);
    public static final RelOptRule BROADCAST_INSTANCE = new MergeJoinPrule("Prel.MergeJoinBroadcastPrule", RelOptHelper.any(DrillJoinRel.class), false);
    protected static final Logger tracer = CalciteTrace.getPlannerTracer();
    private final boolean isDist;

    private MergeJoinPrule(String name, RelOptRuleOperand operand, boolean isDist) {
        super(operand, name);
        this.isDist = isDist;
    }

    public boolean matches(RelOptRuleCall call) {
        return PrelUtil.getPlannerSettings(call.getPlanner()).isMergeJoinEnabled();
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode right;
        RelNode left;
        PlannerSettings settings = PrelUtil.getPlannerSettings(call.getPlanner());
        DrillJoinRel join = (DrillJoinRel)call.rel(0);
        if (!this.checkPreconditions(join, left = join.getLeft(), right = join.getRight(), settings)) {
            return;
        }
        boolean hashSingleKey = PrelUtil.getPlannerSettings(call.getPlanner()).isHashSingleKey();
        try {
            RelCollation collationLeft = this.getCollation(join.getLeftKeys());
            RelCollation collationRight = this.getCollation(join.getRightKeys());
            if (this.isDist) {
                this.createDistBothPlan(call, join, JoinPruleBase.PhysicalJoinType.MERGE_JOIN, left, right, collationLeft, collationRight, hashSingleKey);
            } else if (this.checkBroadcastConditions(call.getPlanner(), join, left, right)) {
                this.createBroadcastPlan(call, join, join.getCondition(), JoinPruleBase.PhysicalJoinType.MERGE_JOIN, left, right, collationLeft, collationRight);
            }
        }
        catch (InvalidRelException e) {
            tracer.warn(e.toString());
        }
    }

    private RelCollation getCollation(List<Integer> keys) {
        ArrayList<RelFieldCollation> fields = Lists.newArrayList();
        for (int key : keys) {
            fields.add(new RelFieldCollation(key));
        }
        return RelCollations.of(fields);
    }
}

