/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationImpl;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.MetadataAggRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.AggPrelBase;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.DrillDistributionTraitDef;
import org.apache.drill.exec.planner.physical.HashToMergeExchangePrel;
import org.apache.drill.exec.planner.physical.MetadataHashAggPrel;
import org.apache.drill.exec.planner.physical.MetadataStreamAggPrel;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.SortPrel;
import org.apache.drill.exec.planner.physical.SubsetTransformer;
import org.apache.drill.exec.store.parquet.FilterEvaluatorUtils;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;

public class MetadataAggPrule
extends Prule {
    public static final MetadataAggPrule INSTANCE = new MetadataAggPrule();

    public MetadataAggPrule() {
        super(RelOptHelper.any(MetadataAggRel.class, (RelTrait)DrillRel.DRILL_LOGICAL), "MetadataAggPrule");
    }

    public void onMatch(RelOptRuleCall call) {
        MetadataAggRel aggregate = (MetadataAggRel)call.rel(0);
        RelNode input = aggregate.getInput();
        int groupByExprsSize = aggregate.getContext().groupByExpressions().size();
        ArrayList<RelFieldCollation> collations = new ArrayList<RelFieldCollation>();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < groupByExprsSize; ++i) {
            collations.add(new RelFieldCollation(i + 1));
            FieldReference fieldPath = MetadataAggPrule.getArgumentReference(aggregate.getContext().groupByExpressions().get(i));
            names.add(fieldPath.getRootSegmentPath());
        }
        NamedRelCollation collation = new NamedRelCollation(collations, names);
        if (aggregate.getContext().groupByExpressions().isEmpty()) {
            DrillDistributionTrait singleDist = DrillDistributionTrait.SINGLETON;
            RelTraitSet singleDistTrait = call.getPlanner().emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)singleDist);
            this.createTransformRequest(call, aggregate, input, singleDistTrait);
        } else {
            RelTraitSet traits;
            boolean smallInput;
            DrillDistributionTrait distOnAllKeys = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(MetadataAggPrule.getDistributionFields(aggregate.getContext().groupByExpressions())));
            PlannerSettings settings = PrelUtil.getPlannerSettings(call.getPlanner());
            boolean bl = smallInput = input.estimateRowCount(input.getCluster().getMetadataQuery()) < (double)settings.getSliceTarget();
            if (aggregate.getContext().createNewAggregations() && !smallInput) {
                traits = call.getPlanner().emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL);
                RelNode convertedInput = MetadataAggPrule.convert(input, traits);
                new TwoPhaseMetadataAggSubsetTransformer(call, (RelCollation)collation, distOnAllKeys).go(aggregate, convertedInput);
            } else {
                traits = call.getPlanner().emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)collation).plus((RelTrait)DrillDistributionTrait.SINGLETON);
                this.createTransformRequest(call, aggregate, input, traits);
            }
        }
    }

    private void createTransformRequest(RelOptRuleCall call, MetadataAggRel aggregate, RelNode input, RelTraitSet traits) {
        RelNode convertedInput = MetadataAggPrule.convert(input, PrelUtil.fixTraits(call, traits));
        MetadataStreamAggPrel newAgg = new MetadataStreamAggPrel(aggregate.getCluster(), traits, convertedInput, aggregate.getContext(), AggPrelBase.OperatorPhase.PHASE_1of1);
        call.transformTo((RelNode)newAgg);
    }

    private static List<DrillDistributionTrait.NamedDistributionField> getDistributionFields(List<NamedExpression> namedExpressions) {
        ArrayList<DrillDistributionTrait.NamedDistributionField> distributionFields = new ArrayList<DrillDistributionTrait.NamedDistributionField>();
        int groupByExprsSize = namedExpressions.size();
        for (int index = 0; index < groupByExprsSize; ++index) {
            FieldReference fieldPath = MetadataAggPrule.getArgumentReference(namedExpressions.get(index));
            DrillDistributionTrait.NamedDistributionField field = new DrillDistributionTrait.NamedDistributionField(index + 1, fieldPath.getRootSegmentPath());
            distributionFields.add(field);
        }
        return distributionFields;
    }

    private static FieldReference getArgumentReference(NamedExpression namedExpression) {
        Set<SchemaPath> arguments = namedExpression.getExpr().accept(FilterEvaluatorUtils.FieldReferenceFinder.INSTANCE, null);
        assert (arguments.size() == 1) : "Group by expression contains more than one argument";
        return new FieldReference(arguments.iterator().next());
    }

    public static class NamedRelCollation
    extends RelCollationImpl {
        private final List<String> names;

        protected NamedRelCollation(List<RelFieldCollation> fieldCollations, List<String> names) {
            super(com.google.common.collect.ImmutableList.copyOf(fieldCollations));
            this.names = Collections.unmodifiableList(names);
        }

        public String getName(int collationIndex) {
            return this.names.get(collationIndex - 1);
        }
    }

    private static class TwoPhaseMetadataAggSubsetTransformer
    extends SubsetTransformer<MetadataAggRel, RuntimeException> {
        private final RelCollation collation;
        private final DrillDistributionTrait distributionTrait;

        public TwoPhaseMetadataAggSubsetTransformer(RelOptRuleCall call, RelCollation collation, DrillDistributionTrait distributionTrait) {
            super(call);
            this.collation = collation;
            this.distributionTrait = distributionTrait;
        }

        @Override
        public RelNode convertChild(MetadataAggRel aggregate, RelNode child) {
            DrillDistributionTrait toDist = (DrillDistributionTrait)child.getTraitSet().getTrait((RelTraitDef)DrillDistributionTraitDef.INSTANCE);
            RelTraitSet traits = this.newTraitSet(new RelTrait[]{Prel.DRILL_PHYSICAL, RelCollations.EMPTY, toDist});
            RelNode newInput = Prule.convert(child, traits);
            List<NamedExpression> identityExpressions = aggregate.getContext().groupByExpressions().stream().map(namedExpression -> new NamedExpression(namedExpression.getExpr(), MetadataAggPrule.getArgumentReference(namedExpression))).collect(Collectors.toList());
            MetadataHashAggPrel phase1Agg = new MetadataHashAggPrel(aggregate.getCluster(), traits, newInput, aggregate.getContext().toBuilder().groupByExpressions(identityExpressions).build(), AggPrelBase.OperatorPhase.PHASE_1of2);
            traits = this.newTraitSet(new RelTrait[]{Prel.DRILL_PHYSICAL, this.collation, toDist}).plus((RelTrait)this.distributionTrait);
            SortPrel sort = new SortPrel(aggregate.getCluster(), traits, phase1Agg, (RelCollation)traits.getTrait(this.collation.getTraitDef()));
            int numEndPoints = PrelUtil.getSettings(phase1Agg.getCluster()).numEndPoints();
            HashToMergeExchangePrel exch = new HashToMergeExchangePrel(phase1Agg.getCluster(), traits, sort, ImmutableList.copyOf(MetadataAggPrule.getDistributionFields(aggregate.getContext().groupByExpressions())), this.collation, numEndPoints);
            return new MetadataStreamAggPrel(aggregate.getCluster(), this.newTraitSet(new RelTrait[]{Prel.DRILL_PHYSICAL, this.collation, DrillDistributionTrait.SINGLETON}), exch, aggregate.getContext(), AggPrelBase.OperatorPhase.PHASE_2of2);
        }
    }
}

