/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.exec.metastore.analyze.MetadataControllerContext;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.MetadataControllerPOP;
import org.apache.drill.exec.planner.common.DrillRelNode;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.visitor.PrelVisitor;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class MetadataControllerPrel
extends BiRel
implements DrillRelNode,
Prel {
    private final MetadataControllerContext context;

    protected MetadataControllerPrel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, MetadataControllerContext context) {
        super(cluster, traits, left, right);
        this.context = context;
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        Prel left = (Prel)this.getLeft();
        Prel right = (Prel)this.getRight();
        MetadataControllerPOP physicalOperator = new MetadataControllerPOP(left.getPhysicalOperator(creator), right.getPhysicalOperator(creator), this.context);
        return creator.addMetadata(this, physicalOperator);
    }

    @Override
    public <T, X, E extends Throwable> T accept(PrelVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitPrel(this, value);
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.ALL;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        Preconditions.checkArgument(inputs.size() == 2);
        return new MetadataControllerPrel(this.getCluster(), traitSet, inputs.get(0), inputs.get(1), this.context);
    }

    @Override
    public boolean needsFinalColumnReordering() {
        return true;
    }

    @Override
    public Iterator<Prel> iterator() {
        return PrelUtil.iter(this.getLeft(), this.getRight());
    }

    protected RelDataType deriveRowType() {
        return new RelDataTypeFactory.Builder(this.getCluster().getTypeFactory()).add("ok", SqlTypeName.BOOLEAN).add("summary", SqlTypeName.VARCHAR).build();
    }
}

