/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.OrderedMuxExchange;
import org.apache.drill.exec.planner.physical.ExchangePrel;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.record.BatchSchema;

public class OrderedMuxExchangePrel
extends ExchangePrel {
    private final RelCollation fieldCollation;

    public OrderedMuxExchangePrel(RelOptCluster cluster, RelTraitSet traits, RelNode child, RelCollation collation) {
        super(cluster, traits, child);
        this.fieldCollation = collation;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new OrderedMuxExchangePrel(this.getCluster(), traitSet, (RelNode)OrderedMuxExchangePrel.sole(inputs), this.fieldCollation);
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        Prel child = (Prel)this.getInput();
        PhysicalOperator childPOP = child.getPhysicalOperator(creator);
        OrderedMuxExchange p = new OrderedMuxExchange(childPOP, PrelUtil.getOrdering(this.fieldCollation, this.getInput().getRowType()));
        return creator.addMetadata(this, p);
    }

    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        for (Ord ord : Ord.zip((List)this.fieldCollation.getFieldCollations())) {
            pw.item("sort" + ord.i, ord.e);
        }
        return pw;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }
}

