/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.drill.common.logical.PlanProperties;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.cost.PrelCostEstimates;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.explain.PrelSequencer;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class PhysicalPlanCreator {
    private final Map<Prel, PrelSequencer.OpId> opIdMap;
    private final List<PhysicalOperator> popList;
    private final QueryContext context;
    private PhysicalPlan plan;

    public PhysicalPlanCreator(QueryContext context, Map<Prel, PrelSequencer.OpId> opIdMap) {
        this.context = context;
        this.opIdMap = opIdMap;
        this.popList = Lists.newArrayList();
    }

    public QueryContext getContext() {
        return this.context;
    }

    public PhysicalOperator addMetadata(Prel originalPrel, PhysicalOperator op) {
        op.setOperatorId(this.opIdMap.get(originalPrel).getAsSingleInt());
        op.setCost(this.getPrelCostEstimates(originalPrel, op));
        return op;
    }

    private PrelCostEstimates getPrelCostEstimates(Prel originalPrel, PhysicalOperator op) {
        RelMetadataQuery mq = originalPrel.getCluster().getMetadataQuery();
        double estimatedRowCount = originalPrel.estimateRowCount(mq);
        DrillCostBase costBase = (DrillCostBase)originalPrel.computeSelfCost(originalPrel.getCluster().getPlanner(), mq);
        PrelCostEstimates costEstimates = !op.isBufferedOperator(this.context) ? new PrelCostEstimates(this.context.getOptions().getLong("drill.exec.memory.operator.output_batch_size"), estimatedRowCount) : new PrelCostEstimates(costBase.getMemory(), estimatedRowCount);
        return costEstimates;
    }

    public PhysicalPlan build(Prel rootPrel, boolean forceRebuild) {
        if (this.plan != null && !forceRebuild) {
            return this.plan;
        }
        PlanProperties.PlanPropertiesBuilder propsBuilder = PlanProperties.builder();
        propsBuilder.type(PlanProperties.PlanType.APACHE_DRILL_PHYSICAL);
        propsBuilder.version(1);
        propsBuilder.resultMode(PlanProperties.Generator.ResultMode.EXEC);
        propsBuilder.generator(PhysicalPlanCreator.class.getName(), "");
        try {
            PhysicalOperator rootPOP = rootPrel.getPhysicalOperator(this);
            if (rootPOP != null) {
                assert (this.popList.size() > 0);
                this.plan = new PhysicalPlan(propsBuilder.build(), this.popList);
            }
        }
        catch (IOException e) {
            this.plan = null;
            throw new UnsupportedOperationException("Physical plan created failed with error : " + e.toString());
        }
        return this.plan;
    }
}

