/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.MetadataAggPrule;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.SelectionVectorRemoverPrel;
import org.apache.drill.exec.record.BatchSchema;

public class PrelUtil {
    public static List<Order.Ordering> getOrdering(RelCollation collation, RelDataType rowType) {
        ArrayList<Order.Ordering> orderExpr = new ArrayList<Order.Ordering>();
        List childFields = rowType.getFieldNames();
        Function<RelFieldCollation, String> fieldNameProvider = collation instanceof MetadataAggPrule.NamedRelCollation ? fieldCollation -> {
            MetadataAggPrule.NamedRelCollation namedCollation = (MetadataAggPrule.NamedRelCollation)collation;
            return namedCollation.getName(fieldCollation.getFieldIndex());
        } : fieldCollation -> (String)childFields.get(fieldCollation.getFieldIndex());
        collation.getFieldCollations().forEach(fieldCollation -> {
            FieldReference fieldReference = new FieldReference((CharSequence)fieldNameProvider.apply((RelFieldCollation)fieldCollation), ExpressionPosition.UNKNOWN);
            orderExpr.add(new Order.Ordering(fieldCollation.getDirection(), (LogicalExpression)fieldReference, fieldCollation.nullDirection));
        });
        return orderExpr;
    }

    public static Iterator<Prel> iter(RelNode ... nodes) {
        return Arrays.asList(nodes).iterator();
    }

    public static Iterator<Prel> iter(List<RelNode> nodes) {
        return nodes.iterator();
    }

    public static PlannerSettings getSettings(RelOptCluster cluster) {
        return PrelUtil.getPlannerSettings(cluster);
    }

    public static PlannerSettings getPlannerSettings(RelOptCluster cluster) {
        return (PlannerSettings)cluster.getPlanner().getContext().unwrap(PlannerSettings.class);
    }

    public static PlannerSettings getPlannerSettings(RelOptPlanner planner) {
        return (PlannerSettings)planner.getContext().unwrap(PlannerSettings.class);
    }

    public static Prel removeSvIfRequired(Prel prel, BatchSchema.SelectionVectorMode ... allowed) {
        BatchSchema.SelectionVectorMode current = prel.getEncoding();
        for (BatchSchema.SelectionVectorMode m : allowed) {
            if (current != m) continue;
            return prel;
        }
        return new SelectionVectorRemoverPrel(prel);
    }

    public static int getLastUsedColumnReference(List<RexNode> projects) {
        LastUsedRefVisitor lastUsed = new LastUsedRefVisitor();
        for (RexNode rex : projects) {
            rex.accept((RexVisitor)lastUsed);
        }
        return lastUsed.getLastUsedReference();
    }

    public static RelTraitSet fixTraits(RelOptRuleCall call, RelTraitSet set) {
        return PrelUtil.fixTraits(call.getPlanner(), set);
    }

    public static RelTraitSet fixTraits(RelOptPlanner cluster, RelTraitSet set) {
        if (PrelUtil.getPlannerSettings(cluster).isSingleMode()) {
            return set.replace((RelTrait)DrillDistributionTrait.ANY);
        }
        return set;
    }

    public static RelTraitSet removeCollation(RelTraitSet traitSet, RelOptRuleCall call) {
        RelTraitSet newTraitSet = call.getPlanner().emptyTraitSet();
        for (RelTrait trait : traitSet) {
            if (trait.getTraitDef().getTraitClass().equals(RelCollation.class)) continue;
            newTraitSet = newTraitSet.plus(trait);
        }
        return newTraitSet;
    }

    private static class LastUsedRefVisitor
    extends RexVisitorImpl<Void> {
        int lastUsedRef = -1;

        protected LastUsedRefVisitor() {
            super(true);
        }

        public Void visitInputRef(RexInputRef inputRef) {
            this.lastUsedRef = Math.max(this.lastUsedRef, inputRef.getIndex());
            return null;
        }

        public Void visitCall(RexCall call) {
            for (RexNode operand : call.operands) {
                operand.accept((RexVisitor)this);
            }
            return null;
        }

        public int getLastUsedReference() {
            return this.lastUsedRef;
        }
    }
}

